/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class MoCEntityHorseMob
extends MoCEntityMob {
    public int mouthCounter;
    public int textCounter;
    public int standCounter;
    public int tailCounter;
    public int eatingCounter;
    public int wingFlapCounter;
    private boolean isImmuneToFire;

    public MoCEntityHorseMob(EntityType<? extends MoCEntityHorseMob> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0);
    }

    @Override
    public void selectType() {
        if (this.m_9236_().m_6042_().f_63857_()) {
            this.setTypeMoC(38);
            this.isImmuneToFire = true;
        } else if (this.getTypeMoC() == 0) {
            int j = this.f_19796_.m_188503_(100);
            if (j <= 40) {
                this.setTypeMoC(23);
            } else if (j <= 80) {
                this.setTypeMoC(26);
            } else {
                this.setTypeMoC(32);
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 23: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getModelTexture("horseundead.png");
                }
                String baseTex = "horseundead";
                int max = 79;
                if (this.f_19796_.m_188503_(3) == 0) {
                    ++this.textCounter;
                }
                if (this.textCounter < 10) {
                    this.textCounter = 10;
                }
                if (this.textCounter > max) {
                    this.textCounter = 10;
                }
                String iteratorTex = String.valueOf(this.textCounter);
                iteratorTex = iteratorTex.substring(0, 1);
                String decayTex = String.valueOf(this.getMoCAge() / 100);
                decayTex = decayTex.substring(0, 1);
                return MoCreatures.proxy.getModelTexture(baseTex + decayTex + iteratorTex + ".png");
            }
            case 26: {
                return MoCreatures.proxy.getModelTexture("horseskeleton.png");
            }
            case 32: {
                return MoCreatures.proxy.getModelTexture("horsebat.png");
            }
            case 38: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getModelTexture("horsenightmare1.png");
                }
                ++this.textCounter;
                if (this.textCounter < 10) {
                    this.textCounter = 10;
                }
                if (this.textCounter > 59) {
                    this.textCounter = 10;
                }
                String NTA = "horsenightmare";
                String NTB = String.valueOf(this.textCounter);
                NTB = NTB.substring(0, 1);
                String NTC = ".png";
                return MoCreatures.proxy.getModelTexture(NTA + NTB + NTC);
            }
        }
        return MoCreatures.proxy.getModelTexture("horseundead.png");
    }

    protected SoundEvent m_5592_() {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_DEATH_UNDEAD.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openMouth();
        this.stand();
        return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_UNDEAD.get();
    }

    protected SoundEvent m_7515_() {
        this.openMouth();
        if (this.f_19796_.m_188503_(10) == 0) {
            this.stand();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_AMBIENT_UNDEAD.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (!blockIn.m_278721_()) {
            SoundType soundtype = blockIn.m_60734_().getSoundType(blockIn, (LevelReader)this.m_9236_(), pos, (Entity)this);
            if (this.m_9236_().m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50125_) {
                soundtype = Blocks.f_50125_.getSoundType(this.m_9236_().m_8055_(pos.m_7494_()), (LevelReader)this.m_9236_(), pos, (Entity)this);
            } else if (soundtype == SoundType.f_56736_) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    public boolean isOnAir() {
        return this.m_9236_().m_46859_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 0.2)), Mth.m_14107_((double)this.m_20189_())));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.eatingCounter > 0 && ++this.eatingCounter > 50) {
            this.eatingCounter = 0;
        }
        if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
            this.wingFlapCounter = 0;
        }
    }

    @Override
    public boolean isFlyer() {
        return this.getTypeMoC() == 25 || this.getTypeMoC() == 32 || this.getTypeMoC() == 28;
    }

    public boolean isUnicorned() {
        return this.getTypeMoC() == 24 || this.getTypeMoC() == 27 || this.getTypeMoC() == 32;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isOnAir() && this.isFlyer() && this.f_19796_.m_188503_(5) == 0) {
            this.wingFlapCounter = 1;
        }
        if (this.f_19796_.m_188503_(200) == 0) {
            this.moveTail();
        }
        if (!this.isOnAir() && !this.m_20160_() && this.f_19796_.m_188503_(250) == 0) {
            this.stand();
        }
        if (this.m_9236_().m_5776_() && this.getTypeMoC() == 38 && this.f_19796_.m_188503_(50) == 0) {
            this.LavaFX();
        }
        if (this.m_9236_().m_5776_() && this.getTypeMoC() == 23 && this.f_19796_.m_188503_(50) == 0) {
            this.UndeadFX();
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.isFlyer() && this.f_19796_.m_188503_(500) == 0) {
                this.wingFlap();
            }
            if (!this.isOnAir() && !this.m_20160_() && this.f_19796_.m_188503_(300) == 0) {
                this.setEating();
            }
            if (!this.m_20160_() && this.f_19796_.m_188503_(100) == 0) {
                MoCTools.findMobRider((Entity)this);
            }
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    private void setEating() {
        this.eatingCounter = 1;
    }

    private void stand() {
        this.standCounter = 1;
    }

    public void wingFlap() {
        this.wingFlapCounter = 1;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        boolean flag;
        super.m_7472_(source, looting, recentlyHitIn);
        boolean bl = flag = this.f_19796_.m_188503_(100) < MoCreatures.proxy.rareItemDropChance;
        if (this.getTypeMoC() == 32 && MoCreatures.proxy.rareItemDropChance < 25) {
            flag = this.f_19796_.m_188503_(100) < 25;
        }
        Item drop = Items.f_42454_;
        if (flag && (this.getTypeMoC() == 36 || this.getTypeMoC() >= 50 && this.getTypeMoC() < 60)) {
            drop = (Item)MoCItems.UNICORNHORN.get();
        }
        if (this.getTypeMoC() == 38 && flag && this.m_9236_().m_6042_().f_63857_()) {
            drop = (Item)MoCItems.HEARTFIRE.get();
        }
        if (this.getTypeMoC() == 32 && flag) {
            drop = (Item)MoCItems.HEARTDARKNESS.get();
        }
        if (this.getTypeMoC() == 26) {
            drop = Items.f_42500_;
        }
        if (this.getTypeMoC() == 23 || this.getTypeMoC() == 24 || this.getTypeMoC() == 25) {
            drop = flag ? (Item)MoCItems.HEARTUNDEAD.get() : Items.f_42583_;
        }
        if (this.getTypeMoC() == 21 || this.getTypeMoC() == 22) {
            drop = Items.f_42586_;
        }
        int i = this.f_19796_.m_188503_(3);
        if (looting > 0) {
            i += this.f_19796_.m_188503_(looting + 1);
        }
        this.m_19983_(new ItemStack((ItemLike)drop, i));
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (entityIn instanceof Player && !this.shouldAttackPlayers()) {
            return false;
        }
        if (this.m_20096_() && !this.isOnAir()) {
            this.stand();
        }
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_HORSE_ANGRY_UNDEAD.get());
        return super.m_7327_(entityIn);
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        if (this.getTypeMoC() == 23 || this.getTypeMoC() == 24 || this.getTypeMoC() == 25) {
            MoCTools.spawnSlimes(this.m_9236_(), (Entity)this);
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.75 - 0.1;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        if (this.m_20186_() < 50.0 && !this.m_9236_().m_6042_().f_63857_()) {
            this.setTypeMoC(32);
        }
        return super.m_5545_(worldIn, spawnReasonIn);
    }

    public void UndeadFX() {
        MoCreatures.proxy.UndeadFX((Entity)this);
    }

    public void LavaFX() {
        MoCreatures.proxy.LavaFX((Entity)this);
    }

    public MobType m_6336_() {
        if (this.getTypeMoC() == 23 || this.getTypeMoC() == 24 || this.getTypeMoC() == 25) {
            return MobType.f_21641_;
        }
        return super.m_6336_();
    }

    @Override
    protected boolean isDaylightSensitive() {
        return true;
    }

    @Override
    public int maxFlyingHeight() {
        return 10;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            double dist = 0.4;
            double newPosX = this.m_20185_() + dist * Math.sin(this.m_146908_() / 57.29578f);
            double newPosZ = this.m_20189_() - dist * Math.cos(this.m_146908_() / 57.29578f);
            double newPosY = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
            moveFunction.m_20372_(passenger, newPosX, newPosY, newPosZ);
            passenger.m_146922_(this.m_146908_());
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.9f;
    }

    public boolean m_5825_() {
        return this.isImmuneToFire ? true : super.m_5825_();
    }
}

