/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityManticore
extends MoCEntityMob {
    public int mouthCounter;
    public int tailCounter;
    public int wingFlapCounter;
    private boolean isPoisoning;
    private int poisontimer;

    public MoCEntityManticore(EntityType<? extends MoCEntityManticore> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new AIManticoreAttack(this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AIManticoreTarget<Player>(this, Player.class, false));
        this.f_21346_.m_25352_(3, new AIManticoreTarget<IronGolem>(this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22279_, (double)0.9f);
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    @Override
    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean getIsRideable() {
        return false;
    }

    @Override
    public int maxFlyingHeight() {
        return 10;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            double dist = -0.1;
            double newPosX = this.m_20185_() + dist * Math.sin(this.m_146908_() / 57.29578f);
            double newPosZ = this.m_20189_() - dist * Math.cos(this.m_146908_() / 57.29578f);
            double newPosY = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
            moveFunction.m_20372_(passenger, newPosX, newPosY, newPosZ);
            passenger.m_146922_(this.m_146908_());
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.75 - 0.1;
    }

    protected void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public boolean isOnAir() {
        return this.m_9236_().m_46859_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 0.2)), Mth.m_14107_((double)this.m_20189_())));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().m_5776_()) {
            if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
                this.mouthCounter = 0;
            }
            if (this.f_19796_.m_188503_(250) == 0) {
                this.moveTail();
            }
            if (this.tailCounter > 0 && ++this.tailCounter > 10 && this.f_19796_.m_188503_(15) == 0) {
                this.tailCounter = 0;
            }
        }
        if (this.isFlyer()) {
            if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
                this.wingFlapCounter = 0;
            }
            if (!this.m_9236_().m_5776_() && this.wingFlapCounter == 5) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_WINGFLAP.get());
            }
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_STING.get());
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        if (!this.m_9236_().m_5776_() && !this.m_9236_().m_5776_() && this.isFlyer() && this.isOnAir()) {
            float myFlyingSpeed = MoCTools.getMyMovementSpeed((Entity)this);
            int wingFlapFreq = (int)(25.0f - myFlyingSpeed * 10.0f);
            if (!this.m_20160_() || wingFlapFreq < 5) {
                wingFlapFreq = 5;
            }
            if (this.f_19796_.m_188503_(wingFlapFreq) == 0) {
                this.wingFlap();
            }
        }
        if (!this.m_20160_() && this.f_19796_.m_188503_(200) == 0) {
            MoCTools.findMobRider((Entity)this);
        }
    }

    @Override
    public void makeEntityJump() {
        this.wingFlap();
        super.makeEntityJump();
    }

    public void wingFlap() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.isFlyer() && this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            if (!this.m_9236_().m_5776_()) {
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 3));
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 3) {
            this.wingFlapCounter = 1;
        }
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    public void setPoisoning(boolean flag) {
        if (flag && !this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 0));
        }
        this.isPoisoning = flag;
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    protected SoundEvent m_5592_() {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_LION_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_LION_HURT.get();
    }

    protected SoundEvent m_7515_() {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_LION_AMBIENT.get();
    }

    @Override
    public float getSizeFactor() {
        return 1.4f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.945f;
    }

    static class AIManticoreAttack
    extends MeleeAttackGoal {
        public AIManticoreAttack(MoCEntityManticore manticore, double speed, boolean useLongMemory) {
            super((PathfinderMob)manticore, speed, useLongMemory);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class AIManticoreTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AIManticoreTarget(MoCEntityManticore manticore, Class<T> classTarget, boolean checkSight) {
            super((Mob)manticore, classTarget, checkSight);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f < 0.5f && super.m_8036_();
        }
    }
}

