/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.item.MoCEntityThrowableRock;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MoCEntityMiniGolem
extends MoCEntityMob {
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(MoCEntityMiniGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_ROCK = SynchedEntityData.m_135353_(MoCEntityMiniGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int tCounter;
    public MoCEntityThrowableRock tempRock;

    public MoCEntityMiniGolem(EntityType<? extends MoCEntityMiniGolem> type, Level world) {
        super(type, world);
        this.texture = "mini_golem.png";
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AIGolemAttack(this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AIGolemTarget<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(3, new AIGolemTarget<IronGolem>(this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGRY, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(HAS_ROCK, (Object)Boolean.FALSE);
    }

    public boolean getIsAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void setIsAngry(boolean flag) {
        this.f_19804_.m_135381_(ANGRY, (Object)flag);
    }

    public boolean getHasRock() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ROCK);
    }

    public void setHasRock(boolean flag) {
        this.f_19804_.m_135381_(HAS_ROCK, (Object)flag);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.setIsAngry(this.m_5448_() != null);
            if (this.getIsAngry() && this.m_5448_() != null && !this.getHasRock() && this.f_19796_.m_188503_(30) == 0) {
                this.acquireTRock();
            }
            if (this.getHasRock()) {
                this.m_21573_().m_26573_();
                this.attackWithTRock();
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        if (this.getHasRock() && this.tempRock != null) {
            this.tempRock.transformToItem();
        }
        super.m_6667_(cause);
    }

    protected void acquireTRock() {
        BlockState tRockState = MoCTools.destroyRandomBlockWithIBlockState((Entity)this, 3.0);
        if (tRockState == null) {
            this.tCounter = 1;
            this.setHasRock(false);
            return;
        }
        MoCEntityThrowableRock tRock = MoCEntityThrowableRock.build(this.m_9236_(), (Entity)this, this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
        this.m_9236_().m_7967_((Entity)tRock);
        tRock.setState(tRockState);
        tRock.setBehavior(1);
        this.tempRock = tRock;
        this.setHasRock(true);
    }

    protected void attackWithTRock() {
        ++this.tCounter;
        if (this.tCounter < 50) {
            this.tempRock.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
        }
        if (this.tCounter >= 50) {
            if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 48.0f) {
                MoCTools.throwStone((Entity)this, (Entity)this.m_5448_(), this.tempRock.getState(), 10.0, 0.25);
            } else {
                this.tempRock.transformToItem();
            }
            this.tempRock.m_142687_(Entity.RemovalReason.DISCARDED);
            this.setHasRock(false);
            this.tCounter = 0;
        }
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_WALK.get());
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_DYING.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.MINI_GOLEM;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.92f;
    }

    static class AIGolemAttack
    extends MeleeAttackGoal {
        public AIGolemAttack(MoCEntityMiniGolem golem, double speed, boolean useLongMemory) {
            super((PathfinderMob)golem, speed, useLongMemory);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class AIGolemTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AIGolemTarget(MoCEntityMiniGolem golem, Class<T> classTarget, boolean checkSight) {
            super((Mob)golem, classTarget, checkSight);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f < 0.5f && super.m_8036_();
        }
    }
}

