/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageExplode;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityOgre
extends MoCEntityMob {
    public int attackCounterLeft;
    public int attackCounterRight;
    public int smashCounter;
    public int armToAnimate;
    public int attackCounter;
    private int movingHead;

    public MoCEntityOgre(EntityType<? extends MoCEntityOgre> type, Level world) {
        super(type, world);
        this.f_21364_ = 12;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AIOgreAttack(this, 1.25, false));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AIOgreTarget<Player>(this, Player.class, false));
        this.f_21346_.m_25352_(3, new AIOgreTarget<IronGolem>(this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(2) + 1);
        }
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float damage) {
        if (super.m_6469_(damagesource, damage)) {
            Entity entity = damagesource.m_7639_();
            if (entity != null && this.m_20160_() && this.m_20363_(entity)) {
                return true;
            }
            if (entity != this && this.m_9236_().m_46791_().m_19028_() > 0 && entity instanceof LivingEntity) {
                this.m_6710_((LivingEntity)entity);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.m_213856_() < 0.5f && super.shouldAttackPlayers();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_OGRE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_OGRE_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_OGRE_AMBIENT.get();
    }

    public boolean isFireStarter() {
        return false;
    }

    public float getDestroyForce() {
        return MoCreatures.proxy.ogreStrength;
    }

    public int getAttackRange() {
        return MoCreatures.proxy.ogreAttackRange;
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.smashCounter > 0 && ++this.smashCounter > 10) {
                this.smashCounter = 0;
                this.performDestroyBlastAttack();
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageExplode(this.m_19879_()));
            }
            if (this.m_5448_() != null && this.f_19796_.m_188503_(40) == 0 && this.smashCounter == 0 && this.attackCounter == 0) {
                this.startDestroyBlast();
            }
        }
        if (this.attackCounter > 0) {
            this.attackCounter = this.armToAnimate == 3 ? ++this.attackCounter : (this.attackCounter += 2);
            if (this.attackCounter > 10) {
                this.attackCounter = 0;
                this.armToAnimate = 0;
            }
        }
        super.m_8107_();
    }

    protected void startDestroyBlast() {
        this.smashCounter = 1;
        MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 3));
    }

    public void performDestroyBlastAttack() {
        if (this.f_20919_ > 0) {
            return;
        }
        MoCTools.destroyBlast((Entity)this, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), this.getDestroyForce(), this.isFireStarter());
    }

    protected void startArmSwingAttack() {
        if (!this.m_9236_().m_5776_()) {
            if (this.smashCounter != 0) {
                return;
            }
            boolean leftArmW = (this.getTypeMoC() == 2 || this.getTypeMoC() == 4 || this.getTypeMoC() == 6) && this.f_19796_.m_188503_(2) == 0;
            this.attackCounter = 1;
            if (leftArmW) {
                this.armToAnimate = 1;
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
            } else {
                this.armToAnimate = 2;
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 2));
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType != 0) {
            this.attackCounter = 1;
            this.armToAnimate = animationType;
        }
    }

    public int getMovingHead() {
        if (this.getTypeMoC() == 1) {
            return 1;
        }
        if (this.f_19796_.m_188503_(60) == 0) {
            this.movingHead = this.f_19796_.m_188503_(2) + 2;
        }
        return this.movingHead;
    }

    @Override
    public boolean m_7327_(Entity target) {
        this.startArmSwingAttack();
        return super.m_7327_(target);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions dimensions) {
        return this.m_20206_() * 0.91f;
    }

    static class AIOgreAttack
    extends MeleeAttackGoal {
        public AIOgreAttack(MoCEntityOgre ogre, double speed, boolean useLongMemory) {
            super((PathfinderMob)ogre, speed, useLongMemory);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class AIOgreTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AIOgreTarget(MoCEntityOgre ogre, Class<T> classTarget, boolean checkSight) {
            super((Mob)ogre, classTarget, checkSight);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f < 0.5f && super.m_8036_();
        }
    }
}

