/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;

public class MoCEntityRat
extends MoCEntityMob {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(MoCEntityRat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MoCEntityRat(EntityType<? extends MoCEntityRat> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AIRatAttack(this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AIRatTarget<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(3, new AIRatTarget<IronGolem>(this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)Boolean.FALSE);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getTypeMoC() == 0) {
            int i = this.f_19796_.m_188503_(100);
            if (i <= 65) {
                this.setTypeMoC(1);
            } else if (i <= 98) {
                this.setTypeMoC(2);
            } else {
                this.setTypeMoC(3);
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("rat_black.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("rat_white.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("rat_brown.png");
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_), Mth.m_14107_((double)this.m_20189_()));
        ResourceKey<Biome> currentbiome = MoCTools.biomeKind(this.m_9236_(), pos);
        try {
            if (currentbiome.m_135782_().m_135815_().contains("desert") || currentbiome.m_135782_().m_135815_().contains("mesa")) {
                this.setTypeMoC(1);
            }
            if (currentbiome.m_135782_().m_135815_().contains("snow") || currentbiome.m_135782_().m_135815_().contains("frozen")) {
                this.setTypeMoC(3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_271165_, SoundEvents.f_271165_);
    }

    @Override
    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Entity entity = damagesource.m_7639_();
        if (entity instanceof LivingEntity) {
            this.m_6710_((LivingEntity)entity);
            if (!this.m_9236_().m_5776_()) {
                List list = this.m_9236_().m_45976_(MoCEntityRat.class, new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82377_(16.0, 4.0, 16.0));
                for (MoCEntityRat entityrat : list) {
                    if (entityrat == null || entityrat.m_5448_() != null) continue;
                    entityrat.m_6710_((LivingEntity)entity);
                }
            }
        }
        return super.m_6469_(damagesource, i);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19796_.m_188503_(100) == 0 && this.m_213856_() > 0.5f) {
            this.m_6710_(null);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.setBesideClimbableBlock(this.f_19862_);
        }
    }

    protected SoundEvent m_5592_() {
        return MoCreatures.proxy.legacyRatDeathSound ? (SoundEvent)MoCSoundEvents.ENTITY_RAT_DEATH_LEGACY.get() : (SoundEvent)MoCSoundEvents.ENTITY_RAT_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_RAT_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_RAT_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.RAT;
    }

    @Override
    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.5f;
    }

    static class AIRatAttack
    extends MeleeAttackGoal {
        public AIRatAttack(MoCEntityRat rat, double speed, boolean useLongMemory) {
            super((PathfinderMob)rat, speed, useLongMemory);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class AIRatTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AIRatTarget(MoCEntityRat rat, Class<T> classTarget, boolean checkSight) {
            super((Mob)rat, classTarget, checkSight);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f < 0.5f && super.m_8036_();
        }
    }
}

