/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.hunter.MoCEntityPetScorpion;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityScorpion
extends MoCEntityMob {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(MoCEntityScorpion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_BABIES = SynchedEntityData.m_135353_(MoCEntityScorpion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int mouthCounter;
    public int armCounter;
    public int getTypeMoC;
    private boolean isPoisoning;
    private int poisontimer;

    public MoCEntityScorpion(EntityType<? extends MoCEntityScorpion> type, Level world, int typeMoc) {
        super(type, world);
        this.setAdult(true);
        this.setMoCAge(20);
        this.poisontimer = 0;
        this.getTypeMoC = typeMoc;
        if (!this.m_9236_().m_5776_() && this.getTypeMoC != 3 && this.getTypeMoC != 5) {
            this.setHasBabies(this.getIsAdult() && this.f_19796_.m_188503_(4) == 0);
        }
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new AIScorpionAttack(this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AIScorpionTarget<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(3, new AIScorpionTarget<IronGolem>(this, IronGolem.class, true));
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture("scorpion_dirt.png");
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(HAS_BABIES, (Object)Boolean.FALSE);
    }

    public boolean getHasBabies() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BABIES);
    }

    public void setHasBabies(boolean flag) {
        this.f_19804_.m_135381_(HAS_BABIES, (Object)flag);
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    public void setPoisoning(boolean flag) {
        if (flag && !this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 1) {
            this.armCounter = 1;
            this.swingArm();
        } else if (animationType == 3) {
            this.mouthCounter = 1;
        }
    }

    @Override
    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.poisontimer != 1) {
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_CLAW.get());
        }
        return super.m_7327_(entity);
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20202_() != null) {
            this.m_146922_(this.m_20202_().m_146908_());
        }
        if (this.mouthCounter != 0 && this.mouthCounter++ > 50) {
            this.mouthCounter = 0;
        }
        if (this.armCounter != 0 && this.armCounter++ > 24) {
            this.armCounter = 0;
        }
        if (!this.m_9236_().m_5776_() && !this.m_20160_() && this.getIsAdult() && !this.getHasBabies() && this.f_19796_.m_188503_(100) == 0) {
            MoCTools.findMobRider((Entity)this);
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_STING.get());
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        super.m_8107_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.setBesideClimbableBlock(this.f_19862_);
        }
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (super.m_6469_(damagesource, i)) {
            Entity entity = damagesource.m_7639_();
            if (entity != this && entity instanceof LivingEntity && this.shouldAttackPlayers()) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean entitiesToIgnore(Entity entity) {
        return super.entitiesToIgnore(entity) || this.getIsTamed() && entity instanceof MoCEntityPetScorpion && ((MoCEntityPetScorpion)entity).getIsTamed();
    }

    public void swingArm() {
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
        }
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        if (!this.m_9236_().m_5776_() && this.getIsAdult() && this.getHasBabies()) {
            int k = this.f_19796_.m_188503_(5);
            for (int i = 0; i < k; ++i) {
                Entity entityscorpy = ((EntityType)MoCEntities.PET_SCORPION.get()).m_20615_(this.m_9236_());
                if (!(entityscorpy instanceof MoCEntityPetScorpion)) continue;
                MoCEntityPetScorpion petScorpion = (MoCEntityPetScorpion)entityscorpy;
                petScorpion.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                petScorpion.setAdult(false);
                petScorpion.setMoCAge(20);
                petScorpion.setTypeMoC(this.getTypeMoC);
                this.m_9236_().m_7967_((Entity)petScorpion);
                MoCTools.playCustomSound((Entity)petScorpion, SoundEvents.f_12388_);
            }
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_HURT.get();
    }

    protected SoundEvent m_7515_() {
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 3));
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_AMBIENT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setHasBabies(nbttagcompound.m_128471_("Babies"));
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Babies", this.getHasBabies());
    }

    public int m_8100_() {
        return 300;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public float getAdjustedYOffset() {
        return 30.0f;
    }

    @Override
    protected int getMaxAge() {
        return 120;
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.75 - 0.15;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            double dist = 0.2;
            double offsetX = this.m_20185_() + dist * Math.sin(this.m_146908_() / 57.29578f);
            double offsetZ = this.m_20189_() - dist * Math.cos(this.m_146908_() / 57.29578f);
            double offsetY = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
            moveFunction.m_20372_(passenger, offsetX, offsetY, offsetZ);
            passenger.m_146922_(this.m_146908_());
        }
    }

    static class AIScorpionAttack
    extends MeleeAttackGoal {
        public AIScorpionAttack(MoCEntityScorpion scorpion, double speed, boolean useLongMemory) {
            super((PathfinderMob)scorpion, speed, useLongMemory);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class AIScorpionTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AIScorpionTarget(MoCEntityScorpion scorpion, Class<T> classTarget, boolean checkSight) {
            super((Mob)scorpion, classTarget, checkSight);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f < 0.5f && super.m_8036_();
        }
    }
}

