/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntitySilverSkeleton
extends MoCEntityMob {
    public int attackCounterLeft;
    public int attackCounterRight;

    public MoCEntitySilverSkeleton(EntityType<? extends MoCEntitySilverSkeleton> type, Level world) {
        super(type, world);
        this.texture = "silver_skeleton.png";
        this.f_21364_ = 5 + this.f_19796_.m_188503_(4);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AISkeletonAttack(this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AISkeletonTarget<Player>(this, Player.class, false));
        this.f_21346_.m_25352_(3, new AISkeletonTarget<IronGolem>(this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22284_, 11.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 7.0);
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            this.m_6858_(this.m_5448_() != null);
        }
        if (this.attackCounterLeft > 0 && ++this.attackCounterLeft > 10) {
            this.attackCounterLeft = 0;
        }
        if (this.attackCounterRight > 0 && ++this.attackCounterRight > 10) {
            this.attackCounterRight = 0;
        }
        super.m_8107_();
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 1) {
            this.attackCounterLeft = 1;
        }
        if (animationType == 2) {
            this.attackCounterRight = 1;
        }
    }

    private void startAttackAnimation() {
        if (!this.m_9236_().m_5776_()) {
            boolean leftArmW;
            boolean bl = leftArmW = this.f_19796_.m_188503_(2) == 0;
            if (leftArmW) {
                this.attackCounterLeft = 1;
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
            } else {
                this.attackCounterRight = 1;
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 2));
            }
        }
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        this.startAttackAnimation();
        return super.m_7327_(entityIn);
    }

    public float m_6113_() {
        if (this.m_20142_()) {
            return 0.35f;
        }
        return 0.2f;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_12383_, 0.15f, 1.0f);
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.SILVER_SKELETON;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.905f;
    }

    static class AISkeletonAttack
    extends MeleeAttackGoal {
        public AISkeletonAttack(MoCEntitySilverSkeleton skeleton, double speed, boolean useLongMemory) {
            super((PathfinderMob)skeleton, speed, useLongMemory);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class AISkeletonTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AISkeletonTarget(MoCEntitySilverSkeleton skeleton, Class<T> classTarget, boolean checkSight) {
            super((Mob)skeleton, classTarget, checkSight);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f < 0.5f && super.m_8036_();
        }
    }
}

