/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.hostile.MoCEntitySilverSkeleton;
import drzhark.mocreatures.entity.hunter.MoCEntityBear;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class MoCEntityWWolf
extends MoCEntityMob {
    public int mouthCounter;
    public int tailCounter;

    public MoCEntityWWolf(EntityType<? extends MoCEntityWWolf> type, Level world) {
        super(type, world);
        this.setAdult(true);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AIWolfAttack(this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AIWolfTarget<Player>(this, Player.class, false));
        this.f_21346_.m_25352_(3, new AIWolfTarget<IronGolem>(this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.5);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(4) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 1: {
                return MoCreatures.proxy.getModelTexture("wild_wolf_black.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("wild_wolf_timber.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("wild_wolf_dark.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("wild_wolf_bright.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("wild_wolf_classic.png");
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19796_.m_188503_(200) == 0) {
            this.moveTail();
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 15) {
            this.mouthCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20191_().f_82289_);
        int k = Mth.m_14107_((double)this.m_20189_());
        ResourceKey<Biome> biome = MoCTools.biomeKind(this.m_9236_(), new BlockPos(i, j, k));
        String biomePath = biome.m_135782_().m_135815_();
        if (biomePath.contains("snow") || biomePath.contains("frozen") || biomePath.contains("ice") || biomePath.contains("cold")) {
            this.setTypeMoC(3);
        }
        this.selectType();
        return true;
    }

    public static boolean getCanSpawnHere(EntityType<? extends MoCEntityMob> type, ServerLevel world, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return MoCEntityMob.getCanSpawnHere(type, world, reason, pos, randomIn) && world.m_45527_(new BlockPos((Vec3i)pos));
    }

    public LivingEntity getClosestTarget(Entity entity, double d) {
        double d1 = -1.0;
        LivingEntity entityliving = null;
        List list = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82400_(d), e -> !(!(e instanceof LivingEntity) || e == entity || e == entity.m_20202_() || e instanceof Player || e instanceof Monster || e instanceof MoCEntityBigCat || e instanceof MoCEntityBear || e instanceof Cow || e instanceof Wolf && !MoCreatures.proxy.attackWolves || e instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses));
        for (Entity entity1 : list) {
            if (!(entity1 instanceof LivingEntity)) continue;
            double d2 = entity1.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1) || !((LivingEntity)entity1).m_142582_(entity)) continue;
            d1 = d2;
            entityliving = (LivingEntity)entity1;
        }
        return entityliving;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_WOLF_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_WOLF_HURT.get();
    }

    protected SoundEvent m_7515_() {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_WOLF_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.WILD_WOLF;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            double dist = 0.1;
            double newPosX = this.m_20185_() + dist * Math.sin(this.m_146908_() / 57.29578f);
            double newPosZ = this.m_20189_() - dist * Math.cos(this.m_146908_() / 57.29578f);
            double newPosY = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
            moveFunction.m_20372_(passenger, newPosX, newPosY, newPosZ);
            passenger.m_146922_(this.m_146908_());
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.75 - 0.1;
    }

    public void m_8107_() {
        block0: {
            List list;
            Iterator iterator;
            super.m_8107_();
            if (this.m_9236_().m_5776_() || this.m_20160_() || this.f_19796_.m_188503_(100) != 0 || !(iterator = (list = this.m_9236_().m_6443_(Monster.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0), e -> e.m_20202_() == null && (e instanceof Skeleton || e instanceof Zombie || e instanceof MoCEntitySilverSkeleton))).iterator()).hasNext()) break block0;
            Monster monster = (Monster)iterator.next();
            monster.m_20329_((Entity)this);
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.945f;
    }

    static class AIWolfAttack
    extends MeleeAttackGoal {
        public AIWolfAttack(MoCEntityWWolf wolf, double speed, boolean useLongMemory) {
            super((PathfinderMob)wolf, speed, useLongMemory);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class AIWolfTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AIWolfTarget(MoCEntityWWolf wolf, Class<T> classTarget, boolean checkSight) {
            super((Mob)wolf, classTarget, checkSight);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f < 0.5f && super.m_8036_();
        }
    }
}

