/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;

public class MoCEntityWerewolf
extends MoCEntityMob {
    private static final EntityDataAccessor<Boolean> IS_HUMAN = SynchedEntityData.m_135353_(MoCEntityWerewolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_HUNCHED = SynchedEntityData.m_135353_(MoCEntityWerewolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean transforming = false;
    private int tcounter = 0;
    private int textCounter;
    private boolean isImmuneToFire;

    public MoCEntityWerewolf(EntityType<? extends MoCEntityWerewolf> type, Level world) {
        super(type, world);
        this.setHumanForm(true);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 7.5);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_HUMAN, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(IS_HUNCHED, (Object)Boolean.FALSE);
    }

    public void m_21153_(float par1) {
        if (this.getIsHumanForm() && par1 > 15.0f) {
            par1 = 15.0f;
        }
        super.m_21153_(par1);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            int k = this.f_19796_.m_188503_(100);
            if (k <= 28) {
                this.setTypeMoC(1);
            } else if (k <= 56) {
                this.setTypeMoC(2);
            } else if (k <= 85) {
                this.setTypeMoC(3);
            } else {
                this.setTypeMoC(4);
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.getIsHumanForm()) {
            return MoCreatures.proxy.getModelTexture("wereblank.png");
        }
        switch (this.getTypeMoC()) {
            case 1: {
                return MoCreatures.proxy.getModelTexture("werewolf_black.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("werewolf_white.png");
            }
            case 4: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getModelTexture("werewolf_fire1.png");
                }
                ++this.textCounter;
                if (this.textCounter < 10) {
                    this.textCounter = 10;
                }
                if (this.textCounter > 39) {
                    this.textCounter = 10;
                }
                String NTA = "werewolf_fire";
                String NTB = String.valueOf(this.textCounter);
                NTB = NTB.substring(0, 1);
                String NTC = ".png";
                return MoCreatures.proxy.getModelTexture(NTA + NTB + NTC);
            }
        }
        return MoCreatures.proxy.getModelTexture("werewolf_brown.png");
    }

    public boolean getIsHumanForm() {
        return (Boolean)this.f_19804_.m_135370_(IS_HUMAN);
    }

    public void setHumanForm(boolean flag) {
        this.f_19804_.m_135381_(IS_HUMAN, (Object)flag);
    }

    public boolean getIsHunched() {
        return (Boolean)this.f_19804_.m_135370_(IS_HUNCHED);
    }

    public void setHunched(boolean flag) {
        this.f_19804_.m_135381_(IS_HUNCHED, (Object)flag);
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (this.getIsHumanForm()) {
            this.m_6710_(null);
            return false;
        }
        if (this.getTypeMoC() == 4 && entityIn instanceof LivingEntity) {
            entityIn.m_20254_(10);
        }
        return super.m_7327_(entityIn);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Player entityplayer;
        ItemStack stack;
        Entity entity = damagesource.m_7639_();
        if (!this.getIsHumanForm() && entity instanceof Player && !(stack = (entityplayer = (Player)entity).m_21205_()).m_41619_()) {
            if (stack.m_41720_() == MoCItems.SILVERSWORD.get()) {
                i = 10.0f;
            } else if (stack.m_41720_() instanceof SwordItem) {
                String swordMaterial = ((SwordItem)stack.m_41720_()).m_43314_().toString();
                String swordName = stack.m_41720_().m_5524_();
                i = swordMaterial.toLowerCase().contains("silver") || swordName.toLowerCase().contains("silver") ? ((SwordItem)stack.m_41720_()).m_43299_() + 6.0f : ((SwordItem)stack.m_41720_()).m_43299_() + 2.0f;
            } else if (stack.m_41720_() instanceof TieredItem) {
                String swordMaterial = ((TieredItem)stack.m_41720_()).m_43314_().toString();
                String swordName = stack.m_41720_().m_5524_();
                i = swordMaterial.toLowerCase().contains("silver") || swordName.toLowerCase().contains("silver") ? ((TieredItem)stack.m_41720_()).m_43314_().m_6631_() * 3.0f : ((TieredItem)stack.m_41720_()).m_43314_().m_6631_() * 0.5f;
            } else {
                i = stack.m_41720_().m_5524_().toLowerCase().contains("silver") ? 6.0f : Math.min(i * 0.5f, 4.0f);
            }
        }
        return super.m_6469_(damagesource, i);
    }

    @Override
    public boolean shouldAttackPlayers() {
        return !this.getIsHumanForm() && super.shouldAttackPlayers();
    }

    protected SoundEvent m_5592_() {
        if (this.getIsHumanForm()) {
            return MoCreatures.proxy.legacyWerehumanSounds ? (SoundEvent)MoCSoundEvents.ENTITY_WEREWOLF_DEATH_HUMAN.get() : SoundEvents.f_11915_;
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_WEREWOLF_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (this.getIsHumanForm()) {
            if (!this.transforming) {
                return MoCreatures.proxy.legacyWerehumanSounds ? (SoundEvent)MoCSoundEvents.ENTITY_WEREWOLF_HURT_HUMAN.get() : SoundEvents.f_11915_;
            }
            return null;
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_WEREWOLF_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.getIsHumanForm()) {
            return null;
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_WEREWOLF_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        if (this.getIsHumanForm()) {
            return MoCLootTables.WEREHUMAN;
        }
        return MoCLootTables.WEREWOLF;
    }

    public boolean IsNight() {
        return !this.m_9236_().m_46461_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            if ((this.IsNight() && this.getIsHumanForm() || !this.IsNight() && !this.getIsHumanForm()) && this.f_19796_.m_188503_(250) == 0) {
                this.transforming = true;
            }
            if (this.getIsHumanForm() && this.m_5448_() != null) {
                this.m_6710_(null);
            }
            if (this.m_5448_() != null && !this.getIsHumanForm()) {
                boolean hunch = this.m_20280_((Entity)this.m_5448_()) > 12.0;
                this.setHunched(hunch);
            }
            if (this.transforming && this.f_19796_.m_188503_(3) == 0) {
                ++this.tcounter;
                if (this.tcounter % 2 == 0) {
                    this.m_6034_(this.m_20185_() + 0.3, this.m_20186_() + (double)this.tcounter / 30.0, this.m_20189_());
                    this.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f);
                }
                if (this.tcounter % 2 != 0) {
                    this.m_6034_(this.m_20185_() - 0.3, this.m_20186_(), this.m_20189_());
                }
                if (this.tcounter == 10) {
                    MoCTools.playCustomSound((Entity)this, MoCreatures.proxy.legacyWerehumanSounds ? (SoundEvent)MoCSoundEvents.ENTITY_WEREWOLF_TRANSFORM_HUMAN.get() : (SoundEvent)MoCSoundEvents.ENTITY_WEREWOLF_TRANSFORM.get());
                }
                if (this.tcounter > 30) {
                    this.Transform();
                    this.tcounter = 0;
                    this.transforming = false;
                }
            }
            if (this.f_19796_.m_188503_(300) == 0) {
                this.f_20891_ -= 100 * this.m_9236_().m_46791_().m_19028_();
                if (this.f_20891_ < 0) {
                    this.f_20891_ = 0;
                }
            }
        }
    }

    public static boolean getCanSpawnHere(EntityType<? extends MoCEntityMob> type, ServerLevel world, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return MoCEntityMob.getCanSpawnHere(type, world, reason, pos, randomIn) && world.m_45527_(new BlockPos((Vec3i)pos));
    }

    private void Transform() {
        if (this.f_20919_ > 0) {
            return;
        }
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20191_().f_82289_) + 1;
        int k = Mth.m_14107_((double)this.m_20189_());
        float f = 0.1f;
        for (int l = 0; l < 30; ++l) {
            double d = (float)i + this.m_9236_().m_213780_().m_188501_();
            double d1 = (float)j + this.m_9236_().m_213780_().m_188501_();
            double d2 = (float)k + this.m_9236_().m_213780_().m_188501_();
            double d3 = d - (double)i;
            double d4 = d1 - (double)j;
            double d5 = d2 - (double)k;
            double d6 = Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5)));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)f + 0.1);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (d + (double)i * 1.0) / 2.0, (d1 + (double)j * 1.0) / 2.0, (d2 + (double)k * 1.0) / 2.0, d3 *= (d7 *= (double)(this.m_9236_().m_213780_().m_188501_() * this.m_9236_().m_213780_().m_188501_() + 0.3f)), d4 *= d7, d5 *= d7);
        }
        if (this.getIsHumanForm()) {
            this.setHumanForm(false);
            this.m_21153_(40.0f);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.5);
        } else {
            this.setHumanForm(true);
            this.m_21153_(15.0f);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
        }
        this.m_6210_();
        this.transforming = false;
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setHumanForm(nbttagcompound.m_128471_("HumanForm"));
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("HumanForm", this.getIsHumanForm());
    }

    public float m_6113_() {
        if (this.getIsHumanForm()) {
            return 0.1f;
        }
        if (this.getIsHunched()) {
            return 0.35f;
        }
        return 0.2f;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        if (this.getIsHumanForm()) {
            return EntityDimensions.m_20398_((float)0.6f, (float)1.8f);
        }
        return EntityDimensions.m_20398_((float)1.2f, (float)2.4f);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.getIsHumanForm() ? 1.62f : 2.0f;
    }

    @Override
    public void setTypeMoC(int i) {
        this.isImmuneToFire = i == 4;
        super.setTypeMoC(i);
    }

    public boolean m_5825_() {
        return this.isImmuneToFire ? true : super.m_5825_();
    }
}

