/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.inventory.MoCAnimalChest;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityBear
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Integer> BEAR_STATE = SynchedEntityData.m_135353_(MoCEntityBear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RIDEABLE = SynchedEntityData.m_135353_(MoCEntityBear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(MoCEntityBear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GHOST = SynchedEntityData.m_135353_(MoCEntityBear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int mouthCounter;
    public MoCAnimalChest localchest;
    public ItemStack localstack;
    private int attackCounter;
    private int standingCounter;

    public MoCEntityBear(EntityType<? extends MoCEntityBear> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setMoCAge(55);
        this.setAdult(this.f_19796_.m_188503_(4) != 0);
        this.m_274367_(1.0f);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIPanicMoC((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFollowOwnerPlayer((Mob)this, 1.0, 2.0f, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIFollowAdult((Mob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new EntityAIHunt<Player>((PathfinderMob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22277_, 20.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BEAR_STATE, (Object)0);
        this.f_19804_.m_135372_(RIDEABLE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(GHOST, (Object)Boolean.FALSE);
    }

    public int getBearState() {
        return (Integer)this.f_19804_.m_135370_(BEAR_STATE);
    }

    public void setBearState(int i) {
        this.f_19804_.m_135381_(BEAR_STATE, (Object)i);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.f_19804_.m_135370_(RIDEABLE);
    }

    public boolean getIsChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setIsChested(boolean flag) {
        this.f_19804_.m_135381_(CHESTED, (Object)flag);
    }

    @Override
    public boolean getIsGhost() {
        return (Boolean)this.f_19804_.m_135370_(GHOST);
    }

    public void setIsGhost(boolean flag) {
        this.f_19804_.m_135381_(GHOST, (Object)flag);
    }

    @Override
    public void setRideable(boolean flag) {
        this.f_19804_.m_135381_(RIDEABLE, (Object)flag);
    }

    @Override
    public void selectType() {
        if (this.getIsAdult()) {
            this.setMoCAge(this.getMoCMaxAge());
        }
    }

    public float getBearSize() {
        return 1.0f;
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        this.startAttack();
        return super.m_7327_(entityIn);
    }

    @Override
    public boolean isMovementCeased() {
        return this.getBearState() == 2;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (super.m_6469_(damagesource, i)) {
            Entity entity = damagesource.m_7639_();
            if (entity != null && this.m_20160_() && this.m_20365_(entity)) {
                return true;
            }
            if (entity != this && entity instanceof LivingEntity && super.shouldAttackPlayers()) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNotScared() {
        return this.getIsAdult();
    }

    public void m_8107_() {
        ItemEntity entityitem;
        Player entityplayer1;
        super.m_8107_();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 20) {
            this.mouthCounter = 0;
        }
        if (this.attackCounter > 0 && ++this.attackCounter > 9) {
            this.attackCounter = 0;
        }
        if (!this.m_9236_().m_5776_() && !this.getIsAdult() && this.getMoCAge() < 80 && this.f_19796_.m_188503_(300) == 0) {
            this.setBearState(2);
        }
        if (!this.m_9236_().m_5776_() && this.getBearState() == 2 && !this.getIsTamed() && this.f_19796_.m_188503_(800) == 0) {
            this.setBearState(0);
        }
        if (!(this.m_9236_().m_5776_() || this.getBearState() != 2 || this.getIsTamed() || this.m_21573_().m_26571_())) {
            this.setBearState(0);
        }
        if (!this.m_9236_().m_5776_() && this.standingCounter > 0 && ++this.standingCounter > 100) {
            this.standingCounter = 0;
            this.setBearState(0);
        }
        if (!this.m_9236_().m_5776_() && !this.getIsTamed() && this.getIsStanding() && this.getBearState() != 2 && this.getIsAdult() && this.f_19796_.m_188503_(200) == 0 && this.shouldAttackPlayers() && (entityplayer1 = this.m_9236_().m_45930_((Entity)this, 4.0)) != null && this.m_142582_((Entity)entityplayer1) && !entityplayer1.m_150110_().f_35934_) {
            this.setStand();
            this.setBearState(1);
        }
        if (!this.m_9236_().m_5776_() && this.getTypeMoC() == 3 && this.f_20919_ == 0 && this.getBearState() != 2 && (entityitem = this.getClosestItem((Entity)this, 12.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_, Items.f_42501_}))) != null) {
            float f = entityitem.m_20270_((Entity)this);
            if (f > 2.0f) {
                this.setPathToEntity((Entity)entityitem, f);
            }
            if (f < 2.0f && this.f_20919_ == 0) {
                entityitem.m_142687_(Entity.RemovalReason.DISCARDED);
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
                this.m_21153_(this.m_21233_());
            }
        }
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return !(entity instanceof MoCEntityBear) && (double)entity.m_20206_() <= 1.0 && (double)entity.m_20205_() <= 1.0;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_BEAR_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_BEAR_HURT.get();
    }

    protected SoundEvent m_7515_() {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_BEAR_AMBIENT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    public float getAttackSwing() {
        if (this.attackCounter == 0) {
            return 0.0f;
        }
        return 1.5f + ((float)this.attackCounter / 10.0f - 10.0f) * 5.0f;
    }

    private void startAttack() {
        if (!this.m_9236_().m_5776_() && this.attackCounter == 0 && this.getBearState() == 1) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 0));
            this.attackCounter = 1;
        }
    }

    @Override
    public void performAnimation(int i) {
        this.attackCounter = 1;
    }

    protected void eatingAnimal() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
    }

    @Override
    public double getCustomSpeed() {
        if (this.getBearState() == 2) {
            return 0.0;
        }
        return super.getCustomSpeed();
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    public boolean getIsStanding() {
        return this.standingCounter != 0;
    }

    public void setStand() {
        this.standingCounter = 1;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getIsTamed() && !this.getIsRideable() && this.getMoCAge() > 80 && (stack.m_41720_() instanceof SaddleItem || stack.m_41720_() == MoCItems.HORSE_SADDLE.get())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setRideable(true);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && MoCTools.isItemEdibleForCarnivores(stack.m_41720_())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_21153_(this.m_21233_());
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            this.setIsHunting(false);
            this.setHasEaten(true);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getIsAdult() && !this.getIsChested() && stack.m_41720_() == Item.m_41439_((Block)Blocks.f_50087_)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            return InteractionResult.SUCCESS;
        }
        if (this.getIsChested() && player.m_6047_()) {
            if (this.localchest == null) {
                this.localchest = new MoCAnimalChest("BigBearChest", MoCAnimalChest.Size.small);
            }
            if (!this.m_9236_().m_5776_()) {
                player.m_5893_((MenuProvider)this.localchest);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public double m_6048_() {
        double Yfactor = (0.086 * (double)this.getMoCAge() - 2.5) / 10.0;
        return (double)this.m_20206_() * Yfactor;
    }

    @Override
    public int nameYOffset() {
        return (int)((0.445 * (double)this.getMoCAge() + 15.0) * -1.0);
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getMoCAge() * 0.01f;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        double dist = (double)this.getSizeFactor() * 0.1;
        double newPosX = this.m_20185_() + dist * Math.sin(this.f_20883_ / 57.29578f);
        double newPosZ = this.m_20189_() - dist * Math.cos(this.f_20883_ / 57.29578f);
        passenger.m_6034_(newPosX, this.m_20186_() + this.m_6048_() + passenger.m_6049_(), newPosZ);
    }

    @Override
    public void dropMyStuff() {
        if (!this.m_9236_().m_5776_()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.m_9236_());
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localchest);
                MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)Blocks.f_50087_, 1));
                this.setIsChested(false);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Saddle", this.getIsRideable());
        nbttagcompound.m_128379_("Chested", this.getIsChested());
        nbttagcompound.m_128379_("Ghost", this.getIsGhost());
        nbttagcompound.m_128405_("BearState", this.getBearState());
        if (this.getIsChested() && this.localchest != null) {
            this.localchest.write(nbttagcompound);
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.localchest.m_6643_(); ++i) {
                this.localstack = this.localchest.m_8020_(i);
                if (this.localstack.m_41619_()) continue;
                CompoundTag nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localstack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items", (Tag)nbttaglist);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setRideable(nbttagcompound.m_128471_("Saddle"));
        this.setIsChested(nbttagcompound.m_128471_("Chested"));
        this.setIsGhost(nbttagcompound.m_128471_("Ghost"));
        this.setBearState(nbttagcompound.m_128451_("BearState"));
        if (this.getIsChested()) {
            ListTag nbttaglist = nbttagcompound.m_128437_("Items", 10);
            this.localchest = new MoCAnimalChest("BigBearChest", MoCAnimalChest.Size.small);
            this.localchest.read(nbttagcompound);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag nbttagcompound1 = nbttaglist.m_128728_(i);
                int j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localchest.m_6643_()) continue;
                this.localchest.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
    }
}

