/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.inventory.MoCAnimalChest;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.util.MoCTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityBigCat
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> RIDEABLE = SynchedEntityData.m_135353_(MoCEntityBigCat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_AMULET = SynchedEntityData.m_135353_(MoCEntityBigCat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(MoCEntityBigCat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GHOST = SynchedEntityData.m_135353_(MoCEntityBigCat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(MoCEntityBigCat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int mouthCounter;
    public int tailCounter;
    public int wingFlapCounter;
    public MoCAnimalChest localchest;
    public ItemStack localstack;
    protected String chestName = "BigCatChest";
    private int tCounter;
    private float fTransparency;

    public MoCEntityBigCat(EntityType<? extends MoCEntityBigCat> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        boolean isAdult = this.f_19796_.m_188503_(4) != 0;
        this.setAdult(isAdult);
        if (isAdult) {
            this.setMoCAge(45);
        } else {
            this.setMoCAge(20);
        }
        this.m_274367_(1.0f);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIFollowAdult((Mob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIFollowOwnerPlayer((Mob)this, 1.0, 2.0f, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 0.8, 30));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new EntityAIHunt<Player>((PathfinderMob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22277_, 24.0);
    }

    @Override
    public void selectType() {
        if (this.getIsAdult()) {
            this.setMoCAge(this.getMoCMaxAge());
        }
    }

    @Override
    public double getCustomSpeed() {
        return 2.0;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIDEABLE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SITTING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(GHOST, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(HAS_AMULET, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
    }

    public boolean getHasAmulet() {
        return (Boolean)this.f_19804_.m_135370_(HAS_AMULET);
    }

    public void setHasAmulet(boolean flag) {
        this.f_19804_.m_135381_(HAS_AMULET, (Object)flag);
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.f_19804_.m_135370_(RIDEABLE);
    }

    public boolean getIsChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setIsChested(boolean flag) {
        this.f_19804_.m_135381_(CHESTED, (Object)flag);
    }

    @Override
    public boolean getIsGhost() {
        return (Boolean)this.f_19804_.m_135370_(GHOST);
    }

    public void setIsGhost(boolean flag) {
        this.f_19804_.m_135381_(GHOST, (Object)flag);
    }

    public void setSitting(boolean flag) {
        this.f_19804_.m_135381_(SITTING, (Object)flag);
    }

    @Override
    public void setRideable(boolean flag) {
        this.f_19804_.m_135381_(RIDEABLE, (Object)flag);
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Entity entity = damagesource.m_7639_();
        if (this.m_20159_() && entity == this.m_20202_()) {
            return false;
        }
        if (super.m_6469_(damagesource, i)) {
            if (entity != null && this.getIsTamed() && entity instanceof Player) {
                return false;
            }
            if (entity != this && entity instanceof LivingEntity && this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    protected SoundEvent m_5592_() {
        this.openMouth();
        if (this.getIsAdult()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_LION_DEATH.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_LION_DEATH_BABY.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openMouth();
        if (this.getIsAdult()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_LION_HURT.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_LION_HURT_BABY.get();
    }

    protected SoundEvent m_7515_() {
        this.openMouth();
        if (this.getIsAdult()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_LION_AMBIENT.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_LION_AMBIENT_BABY.get();
    }

    @Override
    public void m_6667_(DamageSource damagesource) {
        if (!this.m_9236_().m_5776_()) {
            if (this.getHasAmulet()) {
                MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)MoCItems.MEDALLION.get(), 1));
                this.setHasAmulet(false);
            }
            if (this.getIsTamed() && !this.getIsGhost() && this.f_19796_.m_188503_(4) == 0) {
                this.spawnGhost();
            }
        }
        super.m_6667_(damagesource);
    }

    public void spawnGhost() {
        try {
            EntityType entityType = this.m_6095_();
            Mob templiving = (Mob)entityType.m_20615_(this.m_9236_());
            if (templiving instanceof MoCEntityBigCat) {
                MoCEntityBigCat ghost = (MoCEntityBigCat)templiving;
                ghost.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)ghost);
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR.get());
                ghost.setOwnerId(this.getOwnerId());
                ghost.setTamed(true);
                Player entityplayer = this.m_9236_().m_45930_((Entity)this, 24.0);
                if (entityplayer != null) {
                    MoCTools.tameWithName(entityplayer, ghost);
                }
                ghost.setAdult(false);
                ghost.setMoCAge(this.getMoCAge());
                ghost.setTypeMoC(this.getTypeMoC());
                ghost.selectType();
                ghost.setIsGhost(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void m_8107_() {
        ItemEntity entityitem;
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.m_6858_(this.m_5448_() != null);
        }
        if (this.m_9236_().m_5776_()) {
            if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
                this.mouthCounter = 0;
            }
            if (this.f_19796_.m_188503_(250) == 0) {
                this.moveTail();
            }
            if (this.tailCounter > 0 && ++this.tailCounter > 10 && this.f_19796_.m_188503_(15) == 0) {
                this.tailCounter = 0;
            }
        } else {
            if (this.getIsGhost() && this.getMoCAge() > 0 && this.getMoCAge() < 10 && this.f_19796_.m_188503_(5) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() == 9) {
                    this.setMoCAge(this.getMoCMaxAge());
                    this.setAdult(true);
                }
            }
            if (!this.getIsGhost() && this.getMoCAge() < 10) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (!this.m_9236_().m_5776_() && this.isFlyer() && this.isOnAir()) {
            float myFlyingSpeed = MoCTools.getMyMovementSpeed((Entity)this);
            int wingFlapFreq = (int)(25.0f - myFlyingSpeed * 10.0f);
            if (!this.m_20159_() || wingFlapFreq < 5) {
                wingFlapFreq = 5;
            }
            if (this.f_19796_.m_188503_(wingFlapFreq) == 0) {
                this.wingFlap();
            }
        }
        if (this.isFlyer()) {
            if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
                this.wingFlapCounter = 0;
            }
            if (!this.m_9236_().m_5776_() && this.wingFlapCounter == 5) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_WINGFLAP.get());
            }
        }
        if (this.f_19796_.m_188503_(300) == 0 && this.m_21223_() <= this.m_21233_() && this.f_20919_ == 0 && !this.m_9236_().m_5776_()) {
            this.m_21153_(this.m_21223_() + 1.0f);
        }
        if (this.f_20919_ == 0 && !this.isMovementCeased() && (entityitem = this.getClosestItem((Entity)this, 12.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42485_}), Ingredient.m_204132_(MoCTags.Items.RAW_FISHES))) != null) {
            float f = entityitem.m_20270_((Entity)this);
            if (f > 2.0f) {
                this.setPathToEntity((Entity)entityitem, f);
            }
            if (f < 2.0f && this.f_20919_ == 0) {
                entityitem.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_21153_(this.m_21233_());
                this.setHasEaten(true);
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            }
        }
    }

    @Override
    public boolean readytoBreed() {
        return !this.getIsGhost() && super.readytoBreed();
    }

    public void wingFlap() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 3));
        }
    }

    @Override
    public boolean isNotScared() {
        return this.getIsAdult() || this.getMoCAge() > 80;
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        double dist = (double)this.getSizeFactor() * 0.1;
        double newPosX = this.m_20185_() + dist * Math.sin(this.f_20883_ / 57.29578f);
        double newPosZ = this.m_20189_() - dist * Math.cos(this.f_20883_ / 57.29578f);
        passenger.m_6034_(newPosX, this.m_20186_() + this.m_6048_() + passenger.m_6049_(), newPosZ);
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Saddle", this.getIsRideable());
        nbttagcompound.m_128379_("Sitting", this.getIsSitting());
        nbttagcompound.m_128379_("Chested", this.getIsChested());
        nbttagcompound.m_128379_("Ghost", this.getIsGhost());
        nbttagcompound.m_128379_("Amulet", this.getHasAmulet());
        if (this.getIsChested() && this.localchest != null) {
            this.localchest.write(nbttagcompound);
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.localchest.m_6643_(); ++i) {
                this.localstack = this.localchest.m_8020_(i);
                if (this.localstack.m_41619_()) continue;
                CompoundTag nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localstack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items", (Tag)nbttaglist);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setRideable(nbttagcompound.m_128471_("Saddle"));
        this.setSitting(nbttagcompound.m_128471_("Sitting"));
        this.setIsChested(nbttagcompound.m_128471_("Chested"));
        this.setIsGhost(nbttagcompound.m_128471_("Ghost"));
        this.setHasAmulet(nbttagcompound.m_128471_("Amulet"));
        if (this.getIsChested()) {
            ListTag nbttaglist = nbttagcompound.m_128437_("Items", 10);
            this.localchest = new MoCAnimalChest("BigCatChest", MoCAnimalChest.Size.small);
            this.localchest.read(nbttagcompound);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag nbttagcompound1 = nbttaglist.m_128728_(i);
                int j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localchest.m_6643_()) continue;
                this.localchest.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && !this.getIsTamed() && this.getHasEaten() && !this.getIsAdult() && stack.m_41720_() == MoCItems.MEDALLION.get()) {
            if (!this.m_9236_().m_5776_()) {
                this.setHasAmulet(true);
                MoCTools.tameWithName(player, this);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && !this.getHasAmulet() && stack.m_41720_() == MoCItems.MEDALLION.get()) {
            if (!this.m_9236_().m_5776_()) {
                this.setHasAmulet(true);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == MoCItems.WHIP.get()) {
            this.setSitting(!this.getIsSitting());
            this.setIsJumping(false);
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && MoCTools.isItemEdibleForCarnivores(stack.m_41720_())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_21153_(this.m_21233_());
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            this.setIsHunting(false);
            this.setHasEaten(true);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && !this.getIsRideable() && this.getMoCAge() > 80 && (stack.m_41720_() instanceof SaddleItem || stack.m_41720_() == MoCItems.HORSE_SADDLE.get())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setRideable(true);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsGhost() && this.getIsTamed() && stack.m_41720_() == MoCItems.AMULET_GHOST.get()) {
            player.m_21008_(hand, ItemStack.f_41583_);
            if (!this.m_9236_().m_5776_()) {
                MoCPetData petData = MoCreatures.instance.mapData.getPetData(this.getOwnerId());
                if (petData != null) {
                    petData.setInAmulet(this.getOwnerPetId(), true);
                }
                this.dropMyStuff();
                MoCTools.dropAmulet(this, 3, player);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getIsAdult() && !this.getIsChested() && stack.m_41720_() == Item.m_41439_((Block)Blocks.f_50087_)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            return InteractionResult.SUCCESS;
        }
        if (this.getIsChested() && player.m_6047_()) {
            if (this.localchest == null) {
                this.localchest = new MoCAnimalChest(this.chestName, MoCAnimalChest.Size.small);
            }
            if (!this.m_9236_().m_5776_()) {
                player.m_5893_((MenuProvider)this.localchest);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getMoCAge() * 0.01f;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        if (this.isFlyer()) {
            return false;
        }
        float i = (float)(Math.ceil(distance - 3.0f) / 2.0);
        if (!this.m_9236_().m_5776_() && i > 0.0f) {
            if ((i /= 2.0f) > 1.0f) {
                this.m_6469_(damageSource, i);
            }
            if (this.m_20160_() && i > 1.0f) {
                for (Entity entity : this.m_20197_()) {
                    entity.m_6469_(damageSource, i);
                }
            }
            BlockPos blockpos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 0.2 - (double)this.f_19860_), (double)this.m_20189_());
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            if (!blockstate.m_60795_() && !this.m_20067_()) {
                SoundType soundtype = block.m_49962_(blockstate);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundtype.m_56776_(), this.m_5720_(), soundtype.m_56773_() * 0.5f, soundtype.m_56774_() * 0.75f);
            }
            return true;
        }
        return false;
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    public boolean hasMane() {
        return false;
    }

    public int m_8100_() {
        return 400;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public boolean hasSaberTeeth() {
        return false;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType != 0 && animationType == 3) {
            this.wingFlapCounter = 1;
        }
    }

    @Override
    public void makeEntityJump() {
        if (this.isFlyer()) {
            this.wingFlap();
        }
        super.makeEntityJump();
    }

    @Override
    public void dropMyStuff() {
        if (!this.m_9236_().m_5776_()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.m_9236_());
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localchest);
                MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)Blocks.f_50087_, 1));
                this.setIsChested(false);
            }
        }
    }

    public boolean getHasStinger() {
        return false;
    }

    public double m_6048_() {
        double Yfactor = (0.0833 * (double)this.getMoCAge() - 2.5) / 10.0;
        return (double)this.m_20206_() * Yfactor;
    }

    public float tFloat() {
        if (++this.tCounter > 30) {
            this.tCounter = 0;
            this.fTransparency = this.f_19796_.m_188501_() * 0.2f + 0.15f;
        }
        if (this.getMoCAge() < 10) {
            return 0.0f;
        }
        return this.fTransparency;
    }

    @Override
    public int nameYOffset() {
        return (int)((0.445 * (double)this.getMoCAge() + 15.0) * -1.0);
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    public float m_6113_() {
        if (this.m_20142_()) {
            return 0.37f;
        }
        return 0.18f;
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return !this.getIsGhost() && super.canBeTrappedInNet();
    }
}

