/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBear;
import drzhark.mocreatures.entity.neutral.MoCEntityPandaBear;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MoCEntityBlackBear
extends MoCEntityBear {
    public MoCEntityBlackBear(EntityType<? extends MoCEntityBlackBear> type, Level world) {
        super((EntityType<? extends MoCEntityBear>)type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityBear.createAttributes().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.5);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(1);
        }
        super.selectType();
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture("bear_black.png");
    }

    @Override
    public float getBearSize() {
        return 0.9f;
    }

    @Override
    public int getMoCMaxAge() {
        return 90;
    }

    public double getAttackRange() {
        int factor = 1;
        if (this.m_9236_().m_46791_().m_19028_() > 1) {
            factor = 2;
        }
        return 6.0 * (double)factor;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return super.shouldAttackPlayers();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getMoCAge() < 80 && MoCTools.isItemEdibleForCarnivores(stack.m_41720_())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.getIsTamed() && !this.m_9236_().m_5776_()) {
                MoCTools.tameWithName(player, this);
            }
            this.m_21153_(this.m_21233_());
            this.eatingAnimal();
            if (!this.m_9236_().m_5776_() && !this.getIsAdult() && this.getMoCAge() < 100) {
                this.setMoCAge(this.getMoCAge() + 1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_150930_((Item)MoCItems.WHIP.get())) {
            if (this.getBearState() == 0) {
                this.setBearState(2);
            } else {
                this.setBearState(0);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.m_6144_() || this.m_20160_())) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.setBearState(0);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.BLACK_BEAR;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        return "BlackBear";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        return 1;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof MoCEntityPandaBear;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.7f;
    }
}

