/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MoCEntityCrocodile
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> IS_RESTING = SynchedEntityData.m_135353_(MoCEntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING_PREY = SynchedEntityData.m_135353_(MoCEntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_BITING = SynchedEntityData.m_135353_(MoCEntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float biteProgress;
    public float spin;
    public int spinInt;
    private boolean waterbound;

    public MoCEntityCrocodile(EntityType<? extends MoCEntityCrocodile> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.texture = "crocodile.png";
        this.setAdult(true);
        this.setMoCAge(80);
        this.setTamed(false);
        this.f_21364_ = 5;
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFleeFromPlayer((PathfinderMob)this, 0.8, 4.0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new EntityAIHunt<Player>((PathfinderMob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_RESTING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(EATING_PREY, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(IS_BITING, (Object)Boolean.FALSE);
    }

    public boolean getIsBiting() {
        return (Boolean)this.f_19804_.m_135370_(IS_BITING);
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.f_19804_.m_135370_(IS_RESTING);
    }

    public void setIsSitting(boolean flag) {
        this.f_19804_.m_135381_(IS_RESTING, (Object)flag);
    }

    public boolean getHasCaughtPrey() {
        return (Boolean)this.f_19804_.m_135370_(EATING_PREY);
    }

    public void setHasCaughtPrey(boolean flag) {
        this.f_19804_.m_135381_(EATING_PREY, (Object)flag);
    }

    public void setBiting(boolean flag) {
        this.f_19804_.m_135381_(IS_BITING, (Object)flag);
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    @Override
    public void m_6135_() {
        if (this.m_6069_()) {
            if (this.getHasCaughtPrey()) {
                return;
            }
            this.m_20334_(this.m_20184_().f_82479_, 0.3, this.m_20184_().f_82481_);
            this.f_19812_ = true;
        } else if (this.m_5448_() != null || this.getHasCaughtPrey()) {
            super.m_6135_();
        }
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting();
    }

    public void m_8107_() {
        if (this.getIsSitting()) {
            this.m_146926_(-5.0f);
            if (!this.m_6069_() && this.biteProgress < 0.3f && this.f_19796_.m_188503_(5) == 0) {
                this.biteProgress += 0.005f;
            }
            if (this.m_5448_() != null) {
                this.setIsSitting(false);
            }
            if (!this.m_9236_().m_5776_() && this.m_5448_() != null || this.m_6069_() || this.getHasCaughtPrey() || this.f_19796_.m_188503_(500) == 0) {
                this.setIsSitting(false);
                this.biteProgress = 0.0f;
            }
        } else if (!(this.m_9236_().m_5776_() || this.f_19796_.m_188503_(500) != 0 || this.m_5448_() != null || this.getHasCaughtPrey() || this.m_6069_())) {
            this.setIsSitting(true);
            this.m_21573_().m_26573_();
        }
        if (this.f_19796_.m_188503_(500) == 0 && !this.getHasCaughtPrey() && !this.getIsSitting()) {
            this.crocBite();
        }
        if (!(this.m_9236_().m_5776_() || this.f_19796_.m_188503_(500) != 0 || this.waterbound || this.getIsSitting() || this.m_6069_())) {
            MoCTools.moveToWater((PathfinderMob)this);
        }
        if (this.waterbound) {
            if (!this.m_204029_(FluidTags.f_13131_)) {
                MoCTools.moveToWater((PathfinderMob)this);
            } else {
                this.waterbound = false;
            }
        }
        if (this.getHasCaughtPrey()) {
            if (this.m_20160_()) {
                this.m_6710_(null);
                this.biteProgress = 0.4f;
                this.setIsSitting(false);
                if (!this.m_204029_(FluidTags.f_13131_)) {
                    this.waterbound = true;
                    if (this.m_146895_() instanceof LivingEntity && ((LivingEntity)this.m_146895_()).m_21223_() > 0.0f) {
                        ((LivingEntity)this.m_146895_()).f_20919_ = 0;
                    }
                    if (!this.m_9236_().m_5776_() && this.f_19796_.m_188503_(50) == 0) {
                        this.m_146895_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 2.0f);
                    }
                }
            } else {
                this.setHasCaughtPrey(false);
                this.biteProgress = 0.0f;
                this.waterbound = false;
            }
            if (this.isSpinning()) {
                this.spinInt += 3;
                if (this.spinInt % 20 == 0) {
                    MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_CROCODILE_ROLL.get());
                }
                if (this.spinInt > 80) {
                    this.spinInt = 0;
                    this.m_146895_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 4.0f);
                }
            }
        }
        super.m_8107_();
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    public void crocBite() {
        if (!this.getIsBiting()) {
            this.setBiting(true);
            this.biteProgress = 0.0f;
        }
    }

    @Override
    public void m_8119_() {
        if (this.getIsBiting() && !this.getHasCaughtPrey()) {
            this.biteProgress += 0.1f;
            if (this.biteProgress == 0.4f) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_CROCODILE_JAWSNAP.get());
            }
            if (this.biteProgress > 0.6f) {
                this.setBiting(false);
                this.biteProgress = 0.0f;
            }
        }
        super.m_8119_();
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (this.getHasCaughtPrey()) {
            return false;
        }
        if (super.m_7327_(entityIn)) {
            if (!this.m_9236_().m_5776_() && !this.getHasCaughtPrey()) {
                this.crocBite();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Entity entity;
        if (this.m_20160_() && (entity = damagesource.m_7639_()) != null && this.m_146895_() == entity) {
            if (this.f_19796_.m_188503_(2) != 0) {
                return false;
            }
            this.unMount();
        }
        if (super.m_6469_(damagesource, i)) {
            entity = damagesource.m_7639_();
            if (this.m_20160_() && this.m_146895_() == entity && entity != this && entity instanceof LivingEntity && super.shouldAttackPlayers()) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return !(entity instanceof MoCEntityCrocodile);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (!this.m_20160_()) {
            return;
        }
        double dist = (double)((float)this.getMoCAge() * 0.01f + passenger.m_20205_()) - 0.4;
        double newPosX = this.m_20185_() - dist * Math.cos(MoCTools.realAngle(this.m_146908_() - 90.0f) / 57.29578f);
        double newPosZ = this.m_20189_() - dist * Math.sin(MoCTools.realAngle(this.m_146908_() - 90.0f) / 57.29578f);
        moveFunction.m_20372_(passenger, newPosX, this.m_20186_() + this.m_6048_() + passenger.m_6049_(), newPosZ);
        int direction = this.spinInt > 40 ? -1 : 1;
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).f_20883_ = this.m_146908_() * (float)direction;
            ((LivingEntity)passenger).f_20885_ = this.m_146908_() * (float)direction;
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.35;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_CROCODILE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_CROCODILE_HURT.get();
    }

    protected SoundEvent m_7515_() {
        if (this.getIsSitting()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_CROCODILE_RESTING.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_CROCODILE_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.CROCODILE;
    }

    public boolean isSpinning() {
        return this.getHasCaughtPrey() && this.m_20160_() && this.m_6069_();
    }

    @Override
    public void m_6667_(DamageSource damagesource) {
        this.unMount();
        MoCTools.checkForTwistedEntities(this.m_9236_());
        super.m_6667_(damagesource);
    }

    public void unMount() {
        if (this.m_20160_()) {
            if (this.m_146895_() instanceof LivingEntity && ((LivingEntity)this.m_146895_()).m_21223_() > 0.0f) {
                ((LivingEntity)this.m_146895_()).f_20919_ = 0;
            }
            this.m_20153_();
            this.setHasCaughtPrey(false);
        }
    }

    public int m_8100_() {
        return 400;
    }

    @Override
    public boolean isAmphibian() {
        return true;
    }

    @Override
    public boolean m_6069_() {
        return this.m_20069_();
    }

    @Override
    public boolean isReadyToHunt() {
        return this.isNotScared() && !this.isMovementCeased() && !this.m_20160_() && !this.getHasCaughtPrey();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.8f;
    }
}

