/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MoCEntityFox
extends MoCEntityTameableAnimal {
    public MoCEntityFox(EntityType<? extends MoCEntityFox> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setMoCAge(this.f_19796_.m_188503_(15) + 50);
        this.setAdult(this.f_19796_.m_188503_(3) != 0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIPanicMoC((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFleeFromPlayer((PathfinderMob)this, 1.0, 4.0));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFollowOwnerPlayer((Mob)this, 0.8, 2.0f, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIFollowAdult((Mob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        if (!this.getIsAdult()) {
            if (this.getTypeMoC() == 2) {
                return MoCreatures.proxy.getModelTexture("fox_snow.png");
            }
            return MoCreatures.proxy.getModelTexture("fox_cub.png");
        }
        if (this.getTypeMoC() == 2) {
            return MoCreatures.proxy.getModelTexture("fox_snow.png");
        }
        return MoCreatures.proxy.getModelTexture("fox.png");
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (super.m_6469_(damagesource, i)) {
            Entity entity = damagesource.m_7639_();
            if (entity != null && this.m_20365_(entity)) {
                return true;
            }
            if (entity != this && this.isNotScared() && entity instanceof LivingEntity && super.shouldAttackPlayers()) {
                this.m_6710_((LivingEntity)entity);
                this.m_6703_((LivingEntity)entity);
                return true;
            }
        }
        return false;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() == MoCItems.RAW_TURKEY.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().m_5776_()) {
                MoCTools.tameWithName(player, this);
            }
            this.m_21153_(this.m_21233_());
            if (!this.m_9236_().m_5776_() && !this.getIsAdult() && this.getMoCAge() < 100) {
                this.setMoCAge(this.getMoCAge() + 1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsAdult();
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_), Mth.m_14107_((double)this.m_20189_()));
        String biomePath = ((ResourceKey)this.m_9236_().m_204166_(pos).m_203543_().orElseThrow()).m_135782_().m_135815_();
        if (biomePath.contains("snow") || biomePath.contains("frozen") || biomePath.contains("cold")) {
            this.setTypeMoC(2);
        }
        return true;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_FOX_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_FOX_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_FOX_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.FOX;
    }

    protected float m_6121_() {
        return 0.3f;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() == MoCItems.RAT_RAW.get();
    }

    @Override
    public int nameYOffset() {
        return -50;
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return !(entity instanceof MoCEntityFox) && (double)entity.m_20206_() <= 0.7 && (double)entity.m_20205_() <= 0.7;
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    @Override
    public float getSizeFactor() {
        if (this.getIsAdult()) {
            return 0.9f;
        }
        return 0.9f * (float)this.getMoCAge() * 0.01f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.86f;
    }
}

