/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityKomodo
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> RIDEABLE = SynchedEntityData.m_135353_(MoCEntityKomodo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int tailCounter;
    public int tongueCounter;
    public int mouthCounter;
    private int sitCounter;

    public MoCEntityKomodo(EntityType<? extends MoCEntityKomodo> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.texture = "komodo_dragon.png";
        this.setTamed(false);
        this.setAdult(true);
        this.m_274367_(1.0f);
        this.setMoCAge(90);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new EntityAIPanicMoC((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFleeFromPlayer((PathfinderMob)this, 1.1, 4.0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new EntityAIHunt<Player>((PathfinderMob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 4.5).m_22268_(Attributes.f_22279_, 0.18);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIDEABLE, (Object)Boolean.FALSE);
    }

    @Override
    public void setRideable(boolean flag) {
        this.f_19804_.m_135381_(RIDEABLE, (Object)flag);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.f_19804_.m_135370_(RIDEABLE);
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    protected SoundEvent m_5592_() {
        this.openmouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openmouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_HURT.get();
    }

    protected SoundEvent m_7515_() {
        this.openmouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.KOMODO_DRAGON;
    }

    public int m_8100_() {
        return 500;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.sitCounter > 0 && (this.m_20160_() || ++this.sitCounter > 150)) {
            this.sitCounter = 0;
        }
        if (!this.m_9236_().m_5776_()) {
            if (!this.m_6069_() && !this.m_20160_() && this.sitCounter == 0 && this.f_19796_.m_188503_(500) == 0) {
                this.sit();
            }
        } else {
            if (this.tailCounter > 0 && ++this.tailCounter > 60) {
                this.tailCounter = 0;
            }
            if (this.f_19796_.m_188503_(100) == 0) {
                this.tailCounter = 1;
            }
            if (this.f_19796_.m_188503_(100) == 0) {
                this.tongueCounter = 1;
            }
            if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
                this.mouthCounter = 0;
            }
            if (this.tongueCounter > 0 && ++this.tongueCounter > 20) {
                this.tongueCounter = 0;
            }
        }
    }

    private void openmouth() {
        this.mouthCounter = 1;
    }

    private void sit() {
        this.sitCounter = 1;
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 0));
        }
        this.m_21573_().m_26573_();
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.sitCounter = 1;
            this.m_21573_().m_26573_();
        }
    }

    @Override
    public float getSizeFactor() {
        if (!this.getIsAdult()) {
            return (float)this.getMoCAge() * 0.01f;
        }
        return 1.2f;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!(stack.m_41619_() || !this.getIsTamed() || this.getMoCAge() <= 90 && !this.getIsAdult() || this.getIsRideable() || !(stack.m_41720_() instanceof SaddleItem) && stack.m_41720_() != MoCItems.HORSE_SADDLE.get())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setRideable(true);
            return InteractionResult.SUCCESS;
        }
        if (this.getIsRideable() && this.getIsTamed() && this.getMoCAge() > 90 && !this.m_20160_()) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting() || this.m_20160_();
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult()) {
            return -50;
        }
        return -50 + this.getMoCAge() / 2;
    }

    @Override
    public boolean m_6040_() {
        return true;
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Saddle", this.getIsRideable());
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setRideable(nbttagcompound.m_128471_("Saddle"));
    }

    public double m_6048_() {
        double yOff = 0.15f;
        if (this.getIsAdult()) {
            return yOff + (double)this.m_20206_();
        }
        return (double)this.m_20206_() * (120.0 / (double)this.getMoCAge());
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (super.m_6469_(damagesource, i)) {
            Entity entity = damagesource.m_7639_();
            if (entity != null && this.getIsTamed() && entity instanceof Player || !(entity instanceof LivingEntity)) {
                return false;
            }
            if (this.m_20160_() && entity == this.m_20202_()) {
                return false;
            }
            if (entity != this && super.shouldAttackPlayers()) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() == MoCItems.RAT_RAW.get() || stack.m_41720_() == MoCItems.RAW_TURKEY.get());
    }

    public boolean m_5829_() {
        return !this.m_20160_();
    }

    @Override
    public void dropMyStuff() {
        if (!this.m_9236_().m_5776_()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.m_9236_());
        }
    }

    public int m_5792_() {
        return 2;
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return !(entity instanceof MoCEntityKomodo) && super.canAttackTarget(entity);
    }

    @Override
    public int getMoCMaxAge() {
        return 120;
    }

    @Override
    public boolean getIsSitting() {
        return this.sitCounter != 0;
    }

    @Override
    public boolean isNotScared() {
        return this.getMoCAge() > 70;
    }

    public void m_19970_(LivingEntity entityLivingBaseIn, Entity entityIn) {
        ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 150, 0));
        super.m_19970_(entityLivingBaseIn, entityIn);
    }

    @Override
    public boolean isReadyToHunt() {
        return this.isNotScared() && !this.isMovementCeased() && !this.m_20160_();
    }

    @Override
    public boolean isAmphibian() {
        return true;
    }

    @Override
    public boolean m_6069_() {
        return this.m_20069_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return !this.isMovementCeased() ? this.m_20206_() * 0.7f : this.m_20206_() * 0.365f;
    }
}

