/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.hunter.MoCEntityLion;
import drzhark.mocreatures.entity.hunter.MoCEntityPanther;
import drzhark.mocreatures.entity.hunter.MoCEntityTiger;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.init.MoCLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class MoCEntityLeopard
extends MoCEntityBigCat {
    public MoCEntityLeopard(EntityType<? extends MoCEntityLeopard> type, Level world) {
        super((EntityType<? extends MoCEntityBigCat>)type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityBigCat.createAttributes().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.checkSpawningBiome();
        }
        super.selectType();
    }

    @Override
    public boolean checkSpawningBiome() {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20191_().f_82289_);
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos pos = new BlockPos(i, j, k);
        ResourceKey<Biome> currentbiome = MoCTools.biomeKind(this.m_9236_(), pos);
        try {
            String biomePath = currentbiome.m_135782_().m_135815_();
            if (biomePath.contains("snow") || biomePath.contains("frozen")) {
                this.setTypeMoC(2);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTypeMoC(1);
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        if (MoCreatures.proxy.legacyBigCatModels) {
            if (this.getTypeMoC() == 2) {
                return MoCreatures.proxy.getModelTexture("big_cat_snow_leopard_legacy.png");
            }
            return MoCreatures.proxy.getModelTexture("big_cat_leopard_legacy.png");
        }
        if (this.getTypeMoC() == 2) {
            return MoCreatures.proxy.getModelTexture("big_cat_snow_leopard.png");
        }
        return MoCreatures.proxy.getModelTexture("big_cat_leopard.png");
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.m_6144_() || this.m_20160_())) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.setSitting(false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.LEOPARD;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        if (mate instanceof MoCEntityPanther && mate.getTypeMoC() == 1) {
            return "Panthard";
        }
        if (mate instanceof MoCEntityTiger && mate.getTypeMoC() == 1) {
            return "Leoger";
        }
        if (mate instanceof MoCEntityLion && mate.getTypeMoC() == 2) {
            return "Liard";
        }
        return "Leopard";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        if (mate instanceof MoCEntityPanther && mate.getTypeMoC() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityTiger && mate.getTypeMoC() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityLion && mate.getTypeMoC() == 2) {
            return 1;
        }
        return this.getTypeMoC();
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getTypeMoC() == this.getTypeMoC() || mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getTypeMoC() == 1 || mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getTypeMoC() == 1 || mate instanceof MoCEntityLion && ((MoCEntityLion)mate).getTypeMoC() == 2;
    }

    @Override
    public int getMoCMaxAge() {
        return 95;
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        if (!this.getIsAdult() && (double)this.getMoCAge() < (double)this.getMoCMaxAge() * 0.8) {
            return false;
        }
        if (entity instanceof MoCEntityLeopard) {
            return false;
        }
        return entity.m_20206_() < 1.3f && entity.m_20205_() < 1.3f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.92f;
    }
}

