/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.hunter.MoCEntityLeopard;
import drzhark.mocreatures.entity.hunter.MoCEntityPanther;
import drzhark.mocreatures.entity.hunter.MoCEntityTiger;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MoCEntityLion
extends MoCEntityBigCat {
    public MoCEntityLion(EntityType<? extends MoCEntityLion> type, Level world) {
        super((EntityType<? extends MoCEntityBigCat>)type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityBigCat.createAttributes().m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            if (this.f_19796_.m_188503_(20) == 0) {
                this.setTypeMoC(this.f_19796_.m_188503_(2) + 6);
            } else {
                this.setTypeMoC(this.f_19796_.m_188503_(2) + 1);
            }
        }
        super.selectType();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.calculateMaxHealth());
        this.m_21153_(this.m_21233_());
        this.m_21051_(Attributes.f_22281_).m_22100_(this.calculateAttackDmg());
    }

    @Override
    public ResourceLocation getTexture() {
        if (MoCreatures.proxy.legacyBigCatModels) {
            switch (this.getTypeMoC()) {
                case 6: 
                case 7: 
                case 8: {
                    return MoCreatures.proxy.getModelTexture("big_cat_white_lion_legacy.png");
                }
            }
            return MoCreatures.proxy.getModelTexture("big_cat_lion_legacy.png");
        }
        switch (this.getTypeMoC()) {
            case 2: 
            case 3: {
                return MoCreatures.proxy.getModelTexture("big_cat_lion_male.png");
            }
            case 6: 
            case 7: 
            case 8: {
                return MoCreatures.proxy.getModelTexture("big_cat_white_lion.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("big_cat_lion_female.png");
    }

    @Override
    public boolean hasMane() {
        return this.getIsAdult() && (double)this.getMoCAge() >= (double)this.getMoCMaxAge() * 0.8 && (this.getTypeMoC() == 2 || this.getTypeMoC() == 3 || this.getTypeMoC() == 7);
    }

    @Override
    public boolean isFlyer() {
        return this.getTypeMoC() == 3 || this.getTypeMoC() == 5 || this.getTypeMoC() == 8;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getIsTamed() && (this.getTypeMoC() == 2 || this.getTypeMoC() == 7) && stack.m_41720_() == MoCItems.ESSENCE_LIGHT.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            this.setTypeMoC(this.getTypeMoC() + 1);
            return InteractionResult.SUCCESS;
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.m_6144_() || this.m_20160_())) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.setSitting(false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.LION;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        if (mate instanceof MoCEntityTiger && mate.getTypeMoC() < 3) {
            return "Liger";
        }
        if (this.getTypeMoC() == 2 && mate instanceof MoCEntityLeopard && mate.getTypeMoC() == 1) {
            return "Liard";
        }
        if (this.getTypeMoC() == 2 && mate instanceof MoCEntityPanther && mate.getTypeMoC() == 1) {
            return "Lither";
        }
        return "Lion";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        int x = 0;
        if (mate instanceof MoCEntityTiger && mate.getTypeMoC() < 3) {
            return 1;
        }
        if (this.getTypeMoC() == 2 && mate instanceof MoCEntityLeopard && mate.getTypeMoC() == 1) {
            return 1;
        }
        if (this.getTypeMoC() == 2 && mate instanceof MoCEntityPanther && mate.getTypeMoC() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityLion) {
            int lionMateType = mate.getTypeMoC();
            if (this.getTypeMoC() == 1 && lionMateType == 2) {
                x = this.f_19796_.m_188503_(2) + 1;
            }
            if (this.getTypeMoC() == 2 && lionMateType == 1) {
                x = this.f_19796_.m_188503_(2) + 1;
            }
            if (this.getTypeMoC() == 6 && lionMateType == 7) {
                x = this.f_19796_.m_188503_(2) + 6;
            }
            if (this.getTypeMoC() == 7 && lionMateType == 6) {
                x = this.f_19796_.m_188503_(2) + 6;
            }
            if (this.getTypeMoC() == 7 && lionMateType == 1) {
                x = this.f_19796_.m_188503_(2) + 1;
            }
            if (this.getTypeMoC() == 6 && lionMateType == 2) {
                x = this.f_19796_.m_188503_(2) + 1;
            }
            if (this.getTypeMoC() == 1 && lionMateType == 7) {
                x = this.f_19796_.m_188503_(2) + 1;
            }
            if (this.getTypeMoC() == 2 && lionMateType == 6) {
                x = this.f_19796_.m_188503_(2) + 1;
            }
        }
        return x;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        if (this.getTypeMoC() == 2 && mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getTypeMoC() < 3) {
            return true;
        }
        if (this.getTypeMoC() == 2 && mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getTypeMoC() == 1) {
            return true;
        }
        if (this.getTypeMoC() == 2 && mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getTypeMoC() == 1) {
            return true;
        }
        if (mate instanceof MoCEntityLion) {
            return this.getOffspringTypeInt((MoCEntityLion)mate) != 0;
        }
        return false;
    }

    @Override
    public boolean readytoBreed() {
        return (this.getTypeMoC() < 3 || this.getTypeMoC() == 6 || this.getTypeMoC() == 7) && super.readytoBreed();
    }

    public float calculateMaxHealth() {
        if (this.getTypeMoC() == 2 || this.getTypeMoC() == 7) {
            return 35.0f;
        }
        if (this.getTypeMoC() == 4) {
            return 40.0f;
        }
        return 30.0f;
    }

    @Override
    public int getMoCMaxAge() {
        if (this.getTypeMoC() == 1 || this.getTypeMoC() == 6) {
            return 110;
        }
        if (this.getTypeMoC() == 9) {
            return 100;
        }
        return 120;
    }

    public double calculateAttackDmg() {
        if (this.getTypeMoC() == 6 || this.getTypeMoC() == 7 || this.getTypeMoC() == 8) {
            return 7.5;
        }
        return 7.0;
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        if (!this.getIsAdult() && (double)this.getMoCAge() < (double)this.getMoCMaxAge() * 0.8) {
            return false;
        }
        if (entity instanceof MoCEntityLion) {
            return false;
        }
        return entity.m_20206_() < 2.0f && entity.m_20205_() < 2.0f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.92f;
    }
}

