/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MoCEntityManticorePet
extends MoCEntityBigCat {
    public MoCEntityManticorePet(EntityType<? extends MoCEntityManticorePet> type, Level world) {
        super((EntityType<? extends MoCEntityBigCat>)type, world);
        this.chestName = "ManticoreChest";
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityBigCat.createAttributes().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 7.0);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(4) + 1);
        }
        super.selectType();
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("manticore_dark.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("manticore_frost.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("manticore_toxic.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("manticore_plain.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("manticore_fire.png");
    }

    @Override
    public boolean hasMane() {
        return true;
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.m_6144_() || this.m_20160_())) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.setSitting(false);
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_150930_((Item)MoCItems.WHIP.get())) {
            this.setSitting(!this.getIsSitting());
            this.setIsJumping(false);
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return false;
    }

    @Override
    public boolean readytoBreed() {
        return false;
    }

    @Override
    public int getMoCMaxAge() {
        return 130;
    }

    @Override
    public boolean getHasStinger() {
        return true;
    }

    @Override
    public boolean hasSaberTeeth() {
        return true;
    }

    @Nullable
    protected ResourceLocation m_7582_() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCLootTables.DARK_MANTICORE;
            }
            case 3: {
                return MoCLootTables.FROST_MANTICORE;
            }
            case 4: {
                return MoCLootTables.TOXIC_MANTICORE;
            }
            case 5: {
                return MoCLootTables.PLAIN_MANTICORE;
            }
        }
        return MoCLootTables.FIRE_MANTICORE;
    }
}

