/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.hunter.MoCEntityLeopard;
import drzhark.mocreatures.entity.hunter.MoCEntityLion;
import drzhark.mocreatures.entity.hunter.MoCEntityTiger;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MoCEntityPanther
extends MoCEntityBigCat {
    public MoCEntityPanther(EntityType<? extends MoCEntityPanther> type, Level world) {
        super((EntityType<? extends MoCEntityBigCat>)type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityBigCat.createAttributes().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 6.0);
    }

    @Override
    public ResourceLocation getTexture() {
        if (MoCreatures.proxy.legacyBigCatModels) {
            return MoCreatures.proxy.getModelTexture("big_cat_panther_legacy.png");
        }
        return MoCreatures.proxy.getModelTexture("big_cat_panther.png");
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(1);
        }
        super.selectType();
    }

    @Override
    public boolean isFlyer() {
        return this.getTypeMoC() == 2;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getIsTamed() && this.getTypeMoC() == 1 && stack.m_150930_((Item)MoCItems.ESSENCE_DARKNESS.get())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            this.setTypeMoC(2);
            return InteractionResult.SUCCESS;
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.m_6144_() || this.m_20160_())) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.setSitting(false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.PANTHER;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        if (mate instanceof MoCEntityLeopard && mate.getTypeMoC() == 1) {
            return "Panthard";
        }
        if (mate instanceof MoCEntityTiger && mate.getTypeMoC() == 1) {
            return "Panthger";
        }
        if (mate instanceof MoCEntityLion && mate.getTypeMoC() == 2) {
            return "Lither";
        }
        return "Panther";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        if (mate instanceof MoCEntityLeopard && mate.getTypeMoC() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityTiger && mate.getTypeMoC() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityLion && mate.getTypeMoC() == 2) {
            return 1;
        }
        return 1;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getTypeMoC() == 1 || mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getTypeMoC() == 1 || mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getTypeMoC() == 1 || mate instanceof MoCEntityLion && ((MoCEntityLion)mate).getTypeMoC() == 2;
    }

    @Override
    public int getMoCMaxAge() {
        if (this.getTypeMoC() >= 4) {
            return 110;
        }
        return 100;
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        if (!this.getIsAdult() && (double)this.getMoCAge() < (double)this.getMoCMaxAge() * 0.8) {
            return false;
        }
        if (entity instanceof MoCEntityPanther) {
            return false;
        }
        return entity.m_20206_() < 1.5f && entity.m_20205_() < 1.5f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.92f;
    }
}

