/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.hunter.MoCEntityFox;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityPetScorpion
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(MoCEntityPetScorpion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIDEABLE = SynchedEntityData.m_135353_(MoCEntityPetScorpion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_BABIES = SynchedEntityData.m_135353_(MoCEntityPetScorpion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SITTING = SynchedEntityData.m_135353_(MoCEntityPetScorpion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int mouthCounter;
    public int armCounter;
    public int transformType;
    private boolean isPoisoning;
    private int poisontimer = 0;
    private int transformCounter;

    public MoCEntityPetScorpion(EntityType<? extends MoCEntityPetScorpion> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setAdult(false);
        this.setMoCAge(20);
        this.setHasBabies(false);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new AIPetScorpionAttack(this));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIFleeFromPlayer((PathfinderMob)this, 1.2, 4.0));
        this.f_21345_.m_25352_(6, (Goal)new EntityAIFollowOwnerPlayer((Mob)this, 1.0, 2.0f, 10.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        boolean saddle = this.getIsRideable();
        if (this.transformCounter != 0 && this.transformType != 0) {
            String newText;
            switch (this.transformType) {
                case 3: {
                    newText = saddle ? "scorpion_fire_saddled.png" : "scorpion_fire.png";
                    break;
                }
                case 5: {
                    newText = saddle ? "scorpion_undead_saddled.png" : "scorpion_undead.png";
                    break;
                }
                default: {
                    String string = newText = saddle ? "scorpion_undead_saddled.png" : "scorpion_undead.png";
                }
            }
            if (this.transformCounter > 60 && this.transformCounter % 3 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
        }
        switch (this.getTypeMoC()) {
            case 1: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_dirt.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_dirt_saddled.png");
            }
            case 2: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_cave.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_cave_saddled.png");
            }
            case 3: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_fire.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_fire_saddled.png");
            }
            case 4: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_frost.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_frost_saddled.png");
            }
            case 5: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_undead.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_undead_saddled.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("scorpion_dirt.png");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(HAS_BABIES, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(IS_SITTING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(RIDEABLE, (Object)Boolean.FALSE);
    }

    @Override
    public void setRideable(boolean flag) {
        this.f_19804_.m_135381_(RIDEABLE, (Object)flag);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.f_19804_.m_135370_(RIDEABLE);
    }

    public boolean getHasBabies() {
        return this.getIsAdult() && (Boolean)this.f_19804_.m_135370_(HAS_BABIES) != false;
    }

    public void setHasBabies(boolean flag) {
        this.f_19804_.m_135381_(HAS_BABIES, (Object)flag);
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.f_19804_.m_135370_(IS_SITTING);
    }

    public void setSitting(boolean flag) {
        this.f_19804_.m_135381_(IS_SITTING, (Object)flag);
    }

    public void setPoisoning(boolean flag) {
        if (flag && !this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 1) {
            this.armCounter = 1;
            this.swingArm();
        } else if (animationType == 3) {
            this.mouthCounter = 1;
        } else if (animationType == 5) {
            this.transformCounter = 1;
        }
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20202_() != null) {
            this.m_146922_(this.m_20202_().m_146908_());
        }
        if (this.mouthCounter != 0 && this.mouthCounter++ > 50) {
            this.mouthCounter = 0;
        }
        if (this.armCounter != 0 && this.armCounter++ > 24) {
            this.armCounter = 0;
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_STING.get());
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 60) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_TRANSFORM.get());
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.setTypeMoC(this.transformType);
                }
            }
        }
        super.m_8107_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (!this.m_20197_().isEmpty()) {
                for (Entity passenger : this.m_20197_()) {
                    this.positionMyRider(passenger);
                }
            }
            this.setBesideClimbableBlock(this.f_19862_);
        }
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_HURT.get();
    }

    protected SoundEvent m_7515_() {
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 3));
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_AMBIENT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.5f);
    }

    protected ResourceLocation m_7582_() {
        switch (this.getTypeMoC()) {
            case 1: {
                return MoCLootTables.DIRT_SCORPION;
            }
            case 2: {
                return MoCLootTables.CAVE_SCORPION;
            }
            case 3: {
                return MoCLootTables.FIRE_SCORPION;
            }
            case 4: {
                return MoCLootTables.FROST_SCORPION;
            }
            case 5: {
                return MoCLootTables.UNDEAD_SCORPION;
            }
        }
        return MoCLootTables.DIRT_SCORPION;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getIsAdult() && !this.getIsRideable() && (stack.m_150930_(Items.f_42450_) || stack.m_150930_((Item)MoCItems.HORSE_SADDLE.get()))) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setRideable(true);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && stack.m_150930_((Item)MoCItems.WHIP.get()) && this.getIsTamed() && !this.m_20160_()) {
            this.setSitting(!this.getIsSitting());
            this.setIsJumping(false);
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && !this.m_20160_() && !this.m_20159_() && this.transformCounter < 1) {
            if (stack.m_150930_((Item)MoCItems.ESSENCE_FIRE.get()) && this.getTypeMoC() != 3) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (stack.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
                } else {
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                }
                this.transform(3);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_150930_((Item)MoCItems.ESSENCE_UNDEAD.get()) && this.getTypeMoC() != 5) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (stack.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
                } else {
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                }
                this.transform(5);
                return InteractionResult.SUCCESS;
            }
        }
        if (!stack.m_41619_() && this.getIsTamed() && !this.m_20160_() && !this.m_20159_() && stack.m_150930_((Item)MoCItems.ESSENCE_DARKNESS.get())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            this.m_21153_(this.m_21233_());
            if (!this.m_9236_().m_5776_()) {
                int i = this.getTypeMoC() + 40;
                MoCEntityEgg entityegg = (MoCEntityEgg)((EntityType)MoCEntities.EGG.get()).m_20615_(this.m_9236_());
                entityegg.setEggType(i);
                entityegg.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)entityegg);
                entityegg.m_20334_((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.3f, this.m_9236_().f_46441_.m_188501_() * 0.05f, (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.3f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_20202_() == null && this.getMoCAge() < 60 && !this.getIsAdult()) {
            if (this.m_20329_((Entity)player)) {
                this.m_146922_(player.m_146908_());
                if (!this.m_9236_().m_5776_() && !this.getIsTamed()) {
                    MoCTools.tameWithName(player, this);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_20202_() != null) {
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            this.m_8127_();
            this.m_20256_(player.m_20184_().m_82542_(5.0, 0.5, 5.0));
            return InteractionResult.SUCCESS;
        }
        if (this.getIsRideable() && this.getIsTamed() && this.getIsAdult() && !this.m_20160_()) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            if (!this.m_9236_().f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setHasBabies(nbttagcompound.m_128471_("Babies"));
        this.setRideable(nbttagcompound.m_128471_("Saddled"));
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Babies", this.getHasBabies());
        nbttagcompound.m_128379_("Saddled", this.getIsRideable());
    }

    @Override
    public int nameYOffset() {
        int n = (int)(1.0 - (double)this.getMoCAge() * 0.8);
        if (n < -60) {
            n = -60;
        }
        if (this.getIsAdult()) {
            n = -60;
        }
        if (this.getIsSitting()) {
            n = (int)((double)n * 0.8);
        }
        return n;
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    protected boolean isMyHealFood(ItemStack itemstack) {
        return itemstack.m_150930_((Item)MoCItems.RAT_RAW.get()) || itemstack.m_150930_((Item)MoCItems.RAT_COOKED.get());
    }

    public int m_8100_() {
        return 300;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_5829_() {
        return !this.m_20160_();
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public boolean isMovementCeased() {
        return this.m_20160_() || this.getIsSitting();
    }

    @Override
    public void dropMyStuff() {
        MoCTools.dropSaddle(this, this.m_9236_());
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.2f;
    }

    @Override
    public int getMoCMaxAge() {
        return 120;
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.75 - 0.15;
    }

    public void positionMyRider(Entity passenger) {
        double dist = 0.2;
        double newPosX = this.m_20185_() + dist * Math.sin(this.f_20883_ / 57.29578f);
        double newPosZ = this.m_20189_() - dist * Math.cos(this.f_20883_ / 57.29578f);
        passenger.m_6034_(newPosX, this.m_20186_() + this.m_6048_() + (double)0.1f, newPosZ);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsTamed();
    }

    public void transform(int tType) {
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), tType));
        }
        this.transformType = tType;
        if (this.transformType != 0) {
            this.transformCounter = 1;
        }
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return !(entity instanceof MoCEntityFox) && (double)entity.m_20206_() <= 1.0 && (double)entity.m_20205_() <= 1.0;
    }

    public void swingArm() {
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
        }
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (super.m_6469_(damagesource, i)) {
            Entity entity = damagesource.m_7639_();
            if (!(entity instanceof LivingEntity) || entity instanceof Player && this.getIsTamed()) {
                return false;
            }
            if (entity != this && super.shouldAttackPlayers() && this.getIsAdult()) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.poisontimer != 1) {
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SCORPION_CLAW.get());
        }
        if (super.m_7327_(entity) && entity instanceof LivingEntity) {
            if (!this.getIsPoisoning() && this.f_19796_.m_188503_(5) == 0) {
                this.setPoisoning(true);
                if (this.getTypeMoC() <= 1) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 300, 1));
                } else if (this.getTypeMoC() == 2) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 0));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, 300, 0));
                } else if (this.getTypeMoC() == 3) {
                    entity.m_20254_(15);
                } else if (this.getTypeMoC() == 4) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 500, 0));
                } else if (this.getTypeMoC() == 5) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300, 0));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 300, 0));
                }
            } else {
                this.swingArm();
            }
            return true;
        }
        return false;
    }

    static class AIPetScorpionAttack
    extends MeleeAttackGoal {
        public AIPetScorpionAttack(MoCEntityPetScorpion scorpion) {
            super((PathfinderMob)scorpion, 1.0, true);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }
}

