/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntitySnake
extends MoCEntityTameableAnimal {
    public float bodyswing = 2.0f;
    private float fTongue;
    private float fMouth;
    private boolean isBiting;
    private float fRattle;
    private boolean isPissed;
    private int hissCounter;
    private int movInt = this.f_19796_.m_188503_(10);
    private boolean isNearPlayer;

    public MoCEntitySnake(EntityType<? extends MoCEntitySnake> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setMoCAge(50 + this.f_19796_.m_188503_(50));
        this.f_21364_ = 3;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIPanicMoC((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFleeFromPlayer((PathfinderMob)this, 0.8, 4.0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 0.8, 30));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new EntityAIHunt<Player>((PathfinderMob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (this.m_9236_().m_46472_() == MoCreatures.proxy.wyvernDimension) {
            this.m_21530_();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_21532_() {
        return this.m_9236_().m_46472_() == MoCreatures.proxy.wyvernDimension || super.m_21532_();
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(8) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("snake_wolf.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("snake_orange.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("snake_green_bright.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("snake_coral.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("snake_cobra.png");
            }
            case 7: {
                return MoCreatures.proxy.getModelTexture("snake_rattle.png");
            }
            case 8: {
                return MoCreatures.proxy.getModelTexture("snake_python.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("snake_green_dark.png");
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean m_6147_() {
        return this.f_19862_;
    }

    @Override
    public void m_6135_() {
        if (this.m_20069_()) {
            super.m_6135_();
        }
    }

    public boolean pickedUp() {
        return this.m_20202_() != null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (!this.getIsTamed()) {
            return InteractionResult.FAIL;
        }
        if (this.m_20202_() == null) {
            if (this.m_20329_((Entity)player)) {
                this.m_146922_(player.m_146908_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean isNotScared() {
        return this.getTypeMoC() > 2 && this.getMoCAge() > 50;
    }

    public boolean isClimbing() {
        return this.m_6147_() && this.m_20184_().f_82480_ > (double)0.01f;
    }

    public boolean isResting() {
        return !this.getNearPlayer() && this.m_20096_() && this.m_20184_().f_82479_ < 0.01 && this.m_20184_().f_82479_ > -0.01 && this.m_20184_().f_82481_ < 0.01 && this.m_20184_().f_82481_ > -0.01;
    }

    public boolean getNearPlayer() {
        return this.isNearPlayer || this.isBiting();
    }

    public void setNearPlayer(boolean flag) {
        this.isNearPlayer = flag;
    }

    public int getMovInt() {
        return this.movInt;
    }

    @Override
    public boolean m_6040_() {
        return true;
    }

    public double m_6048_() {
        if (this.m_20202_() instanceof Player) {
            return 0.1f;
        }
        return this.m_6048_();
    }

    public float getSizeF() {
        float factor = 1.0f;
        if (this.getTypeMoC() == 1 || this.getTypeMoC() == 2) {
            factor = 0.8f;
        } else if (this.getTypeMoC() == 5) {
            factor = 0.6f;
        }
        if (this.getTypeMoC() == 6) {
            factor = 1.1f;
        }
        if (this.getTypeMoC() == 7) {
            factor = 0.9f;
        }
        if (this.getTypeMoC() == 8) {
            factor = 1.5f;
        }
        return (float)this.getMoCAge() * 0.01f * factor;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            int chance;
            if (this.getfTongue() != 0.0f) {
                this.setfTongue(this.getfTongue() + 0.2f);
                if (this.getfTongue() > 8.0f) {
                    this.setfTongue(0.0f);
                }
            }
            if (this.getfMouth() != 0.0f && this.hissCounter == 0) {
                this.setfMouth(this.getfMouth() + 0.1f);
                if (this.getfMouth() > 0.5f) {
                    this.setfMouth(0.0f);
                }
            }
            if (this.getTypeMoC() == 7 && this.getfRattle() != 0.0f) {
                this.setfRattle(this.getfRattle() + 0.2f);
                if (this.getfRattle() == 1.0f) {
                    MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_RATTLE.get());
                }
                if (this.getfRattle() > 8.0f) {
                    this.setfRattle(0.0f);
                }
            }
            if (this.f_19796_.m_188503_(50) == 0 && this.getfTongue() == 0.0f) {
                this.setfTongue(0.1f);
            }
            if (this.f_19796_.m_188503_(100) == 0 && this.getfMouth() == 0.0f) {
                this.setfMouth(0.1f);
            }
            if (this.getTypeMoC() == 7 && this.f_19796_.m_188503_(chance = this.getNearPlayer() ? 30 : 100) == 0) {
                this.setfRattle(0.1f);
            }
            if (!this.isResting() && !this.pickedUp() && this.f_19796_.m_188503_(50) == 0) {
                this.movInt = this.f_19796_.m_188503_(10);
            }
            if (this.isBiting()) {
                this.bodyswing -= 0.5f;
                this.setfMouth(0.3f);
                if (this.bodyswing < 0.0f) {
                    MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_SNAP.get());
                    this.bodyswing = 2.5f;
                    this.setfMouth(0.0f);
                    this.setBiting(false);
                }
            }
        }
        if (this.pickedUp()) {
            this.movInt = 0;
        }
        if (this.isResting()) {
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
        }
        if (!this.m_20096_() && this.m_20202_() != null) {
            this.m_146922_(this.m_20202_().m_146908_());
        }
        if (this.m_9236_().m_46791_().m_19028_() > 0 && this.getNearPlayer() && !this.getIsTamed() && this.isNotScared()) {
            ++this.hissCounter;
            if (this.hissCounter % 25 == 0) {
                this.setfMouth(0.3f);
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_ANGRY.get());
            }
            if (this.hissCounter % 35 == 0) {
                this.setfMouth(0.0f);
            }
            if (this.hissCounter > 100 && this.f_19796_.m_188503_(50) == 0) {
                this.setPissed(true);
                this.hissCounter = 0;
            }
        }
        if (this.hissCounter > 500) {
            this.hissCounter = 0;
        }
    }

    public float getfTongue() {
        return this.fTongue;
    }

    public void setfTongue(float fTongue) {
        this.fTongue = fTongue;
    }

    public float getfMouth() {
        return this.fMouth;
    }

    public void setfMouth(float fMouth) {
        this.fMouth = fMouth;
    }

    public float getfRattle() {
        return this.fRattle;
    }

    public void setfRattle(float fRattle) {
        this.fRattle = fRattle;
    }

    public void m_8107_() {
        Player entityplayer1;
        super.m_8107_();
        if (this.m_5448_() != null && this.f_19796_.m_188503_(300) == 0) {
            this.m_6710_(null);
        }
        if ((entityplayer1 = this.m_9236_().m_45930_((Entity)this, 12.0)) != null) {
            double distP = MoCTools.getSqDistanceTo((Entity)entityplayer1, this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (this.isNotScared()) {
                this.setNearPlayer(distP < 5.0);
            } else {
                this.setNearPlayer(false);
            }
        } else {
            this.setNearPlayer(false);
        }
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && entityIn instanceof LivingEntity && this.getTypeMoC() > 2) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
            this.setBiting(true);
        }
        return flag;
    }

    @Override
    public void performAnimation(int i) {
        if (i == 1) {
            this.setBiting(true);
        }
    }

    public boolean isBiting() {
        return this.isBiting;
    }

    public void setBiting(boolean flag) {
        this.isBiting = flag;
        if (!this.m_9236_().m_5776_() && flag) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
        }
    }

    public boolean isPissed() {
        return this.isPissed;
    }

    public void setPissed(boolean isPissed) {
        this.isPissed = isPissed;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (this.getTypeMoC() < 3) {
            return super.m_6469_(damagesource, i);
        }
        if (super.m_6469_(damagesource, i)) {
            Entity entity = damagesource.m_7640_();
            if (entity != null && this.m_20160_()) {
                return true;
            }
            if (entity != this && entity instanceof LivingEntity && super.shouldAttackPlayers()) {
                this.setPissed(true);
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        if (this.getMoCAge() > 60) {
            int j = this.f_19796_.m_188503_(3);
            for (int l = 0; l < j; ++l) {
                int snakeEggType = this.getTypeMoC() + 20;
                ItemStack snakeEgg = new ItemStack((ItemLike)MoCItems.MOC_EGG.get(), 1);
                snakeEgg.m_41784_().m_128405_("EggType", snakeEggType);
                this.m_5552_(snakeEgg, 1.0f);
            }
        }
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return !(entity instanceof MoCEntitySnake) && (double)entity.m_20206_() < 0.5 && (double)entity.m_20205_() < 0.5;
    }

    protected void m_7355_(BlockPos pos, BlockState par4) {
        if (this.m_204029_(FluidTags.f_13131_)) {
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_SWIM.get());
        }
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_SNAKE_AMBIENT.get();
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_), Mth.m_14107_((double)this.m_20189_()));
        try {
            String biomePath = ((ResourceKey)this.m_9236_().m_204166_(pos).m_203543_().orElseThrow()).m_135782_().m_135815_();
            int l = this.f_19796_.m_188503_(10);
            if (biomePath.contains("snow") || biomePath.contains("frozen") || biomePath.contains("ice") || biomePath.contains("cold")) {
                return false;
            }
            if (biomePath.contains("desert") || biomePath.contains("mesa") || biomePath.contains("badlands")) {
                if (l < 5) {
                    this.setTypeMoC(7);
                } else {
                    this.setTypeMoC(2);
                }
            }
            if (biomePath.contains("plains")) {
                if (l < 3) {
                    this.setTypeMoC(1);
                } else if (l < 5) {
                    this.setTypeMoC(5);
                } else {
                    this.setTypeMoC(2);
                }
            }
            if (biomePath.contains("savanna")) {
                if (l < 4) {
                    this.setTypeMoC(8);
                } else if (l < 8) {
                    this.setTypeMoC(2);
                } else {
                    this.setTypeMoC(7);
                }
            }
            if (biomePath.contains("forest") && !biomePath.contains("jungle")) {
                if (l < 5) {
                    this.setTypeMoC(1);
                } else {
                    this.setTypeMoC(2);
                }
            }
            if (biomePath.contains("swamp")) {
                if (l < 5) {
                    this.setTypeMoC(8);
                } else if (l < 7) {
                    this.setTypeMoC(6);
                } else {
                    this.setTypeMoC(1);
                }
            }
            if (biomePath.contains("jungle")) {
                if (l < 3) {
                    this.setTypeMoC(4);
                } else if (l < 5) {
                    this.setTypeMoC(3);
                } else if (l < 7) {
                    this.setTypeMoC(6);
                } else if (l < 9) {
                    this.setTypeMoC(8);
                } else {
                    this.setTypeMoC(1);
                }
            }
            if (biomePath.contains("magical")) {
                this.setTypeMoC(1);
            }
            if (this.m_9236_().m_46472_() == MoCreatures.proxy.wyvernDimension) {
                if (l < 3) {
                    this.setTypeMoC(4);
                } else if (l < 5) {
                    this.setTypeMoC(3);
                } else if (l < 7) {
                    this.setTypeMoC(2);
                } else {
                    this.setTypeMoC(1);
                }
            }
            if (!(this.getTypeMoC() != 7 || biomePath.contains("desert") || biomePath.contains("mesa") || biomePath.contains("badlands") || biomePath.contains("savanna"))) {
                this.setTypeMoC(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int nameYOffset() {
        return -30;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() == MoCItems.RAT_RAW.get();
    }

    public int m_5792_() {
        return 2;
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    public void m_19970_(LivingEntity entityLivingBaseIn, Entity entityIn) {
        if (this.isVenomous() && entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 150, 2));
        }
        super.m_19970_(entityLivingBaseIn, entityIn);
    }

    private boolean isVenomous() {
        return this.getTypeMoC() == 3 || this.getTypeMoC() == 4 || this.getTypeMoC() == 5 || this.getTypeMoC() == 6 || this.getTypeMoC() == 7 || this.getTypeMoC() == 9;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.isPissed() && super.shouldAttackPlayers();
    }

    public int m_8100_() {
        return 400;
    }

    @Override
    public boolean isAmphibian() {
        return true;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    @Override
    protected double maxDivingDepth() {
        return (double)this.getMoCAge() / 100.0;
    }
}

