/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CombinedContainer
implements Container {
    private final Container[] containers;
    private final int[] baseIndices;
    private final int totalSize;

    public CombinedContainer(Container ... containers) {
        this.containers = containers;
        this.baseIndices = new int[containers.length];
        int index = 0;
        for (int i = 0; i < containers.length; ++i) {
            this.baseIndices[i] = index;
            index += containers[i].m_6643_();
        }
        this.totalSize = index;
    }

    public int m_6643_() {
        return this.totalSize;
    }

    public boolean m_7983_() {
        for (Container container : this.containers) {
            if (container.m_7983_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        if (containerIndex < 0) {
            return ItemStack.f_41583_;
        }
        return this.containers[containerIndex].m_8020_(slot - this.baseIndices[containerIndex]);
    }

    public ItemStack m_7407_(int slot, int amount) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        if (containerIndex < 0) {
            return ItemStack.f_41583_;
        }
        return this.containers[containerIndex].m_7407_(slot - this.baseIndices[containerIndex], amount);
    }

    public ItemStack m_8016_(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        if (containerIndex < 0) {
            return ItemStack.f_41583_;
        }
        return this.containers[containerIndex].m_8016_(slot - this.baseIndices[containerIndex]);
    }

    public void m_6836_(int slot, ItemStack stack) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        if (containerIndex >= 0) {
            this.containers[containerIndex].m_6836_(slot - this.baseIndices[containerIndex], stack);
        }
    }

    public void m_6596_() {
        for (Container container : this.containers) {
            container.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        for (Container container : this.containers) {
            if (container.m_6542_(player)) continue;
            return false;
        }
        return true;
    }

    public void m_6211_() {
        for (Container container : this.containers) {
            container.m_6211_();
        }
    }

    private int getContainerIndexForSlot(int slot) {
        if (slot < 0 || slot >= this.totalSize) {
            return -1;
        }
        for (int i = this.containers.length - 1; i >= 0; --i) {
            if (slot < this.baseIndices[i]) continue;
            return i;
        }
        return -1;
    }
}

