/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.item;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.aquatic.MoCEntityFishy;
import drzhark.mocreatures.entity.aquatic.MoCEntityMediumFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityPiranha;
import drzhark.mocreatures.entity.aquatic.MoCEntityShark;
import drzhark.mocreatures.entity.aquatic.MoCEntitySmallFish;
import drzhark.mocreatures.entity.hunter.MoCEntityKomodo;
import drzhark.mocreatures.entity.hunter.MoCEntityManticorePet;
import drzhark.mocreatures.entity.hunter.MoCEntityPetScorpion;
import drzhark.mocreatures.entity.hunter.MoCEntitySnake;
import drzhark.mocreatures.entity.neutral.MoCEntityOstrich;
import drzhark.mocreatures.entity.neutral.MoCEntityWyvern;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.init.MoCEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class MoCEntityEgg
extends Mob {
    public int eggType;
    private int tCounter;
    private int lCounter;

    public MoCEntityEgg(EntityType<? extends Mob> type, Level level) {
        super(type, level);
        this.m_21557_(true);
        this.m_20225_(true);
        this.tCounter = 0;
        this.lCounter = 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0);
    }

    protected void m_8099_() {
    }

    public boolean m_6040_() {
        return true;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture("egg.png");
    }

    public void m_8107_() {
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        this.f_20885_ = this.m_146908_();
        this.f_20883_ = this.m_146908_();
        if (!this.m_9236_().f_46443_) {
            boolean inWater;
            if (this.f_19796_.m_188503_(20) == 0) {
                ++this.lCounter;
            }
            if (this.lCounter > 500 && this.m_9236_().m_45930_((Entity)this, 24.0) == null) {
                this.m_146870_();
            }
            if ((inWater = this.m_20069_()) && (this.getEggType() < 12 || this.getEggType() > 69) && this.f_19796_.m_188503_(20) == 0) {
                this.handleAquaticHatching();
            } else if (!inWater && this.getEggType() > 20 && this.f_19796_.m_188503_(20) == 0) {
                this.handleLandHatching();
            }
        }
    }

    private void handleAquaticHatching() {
        ++this.tCounter;
        if (this.tCounter % 5 == 0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.2, 0.0));
        }
        if (this.tCounter == 5) {
            this.notifyEggHatching();
        }
        if (this.tCounter >= 30) {
            Player player = this.m_9236_().m_45930_((Entity)this, 24.0);
            switch (this.getEggType()) {
                case 11: {
                    this.spawnEggEntity((Mob)new MoCEntityShark((EntityType<? extends MoCEntityShark>)((EntityType)MoCEntities.SHARK.get()), this.m_9236_()), player);
                    break;
                }
                case 90: {
                    this.spawnEggEntity((Mob)new MoCEntityPiranha((EntityType<? extends MoCEntityPiranha>)((EntityType)MoCEntities.PIRANHA.get()), this.m_9236_()), player);
                    break;
                }
                default: {
                    if (this.getEggType() <= 10) {
                        MoCEntityFishy fishy = new MoCEntityFishy((EntityType<? extends MoCEntityFishy>)((EntityType)MoCEntities.FISHY.get()), this.m_9236_());
                        fishy.setTypeMoC(this.getEggType());
                        this.spawnEggEntity((Mob)fishy, player);
                        break;
                    }
                    if (this.getEggType() >= 80) {
                        this.spawnEggEntity((Mob)MoCEntitySmallFish.createEntity(this.m_9236_(), this.getEggType() - 79), player);
                        break;
                    }
                    if (this.getEggType() < 70) break;
                    this.spawnEggEntity((Mob)MoCEntityMediumFish.createEntity(this.m_9236_(), this.getEggType() - 69), player);
                }
            }
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            this.m_146870_();
        }
    }

    public int getSize() {
        if (this.getEggType() == 30 || this.getEggType() == 31) {
            return 170;
        }
        return 100;
    }

    private void handleLandHatching() {
        ++this.tCounter;
        if (this.tCounter % 5 == 0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.2, 0.0));
        }
        if (this.tCounter == 5) {
            this.notifyEggHatching();
        }
        if (this.tCounter >= 30) {
            Player player = this.m_9236_().m_45930_((Entity)this, 24.0);
            if (this.getEggType() > 20 && this.getEggType() < 29) {
                MoCEntitySnake snakey = new MoCEntitySnake((EntityType<? extends MoCEntitySnake>)((EntityType)MoCEntities.SNAKE.get()), this.m_9236_());
                snakey.setTypeMoC(this.getEggType() - 20);
                snakey.m_146762_(50);
                this.spawnEggEntity((Mob)snakey, player);
            }
            if (this.getEggType() == 30 || this.getEggType() == 31 || this.getEggType() == 32) {
                MoCEntityOstrich ostrich = new MoCEntityOstrich((EntityType<? extends MoCEntityOstrich>)((EntityType)MoCEntities.OSTRICH.get()), this.m_9236_());
                ostrich.setTypeMoC(this.m_9236_().m_46472_().m_135782_().m_135815_().contains("nether") || this.getEggType() == 32 ? 5 : 1);
                ostrich.m_146762_(35);
                ostrich.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)ostrich);
                if (this.getEggType() == 31 && player != null) {
                    MoCTools.tameWithName(player, ostrich);
                }
            }
            if (this.getEggType() == 33) {
                MoCEntityKomodo komodo = new MoCEntityKomodo((EntityType<? extends MoCEntityKomodo>)((EntityType)MoCEntities.KOMODO_DRAGON.get()), this.m_9236_());
                komodo.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                komodo.m_146762_(35);
                this.m_9236_().m_7967_((Entity)komodo);
                if (player != null) {
                    MoCTools.tameWithName(player, komodo);
                }
            }
            if (this.getEggType() > 40 && this.getEggType() < 46) {
                MoCEntityPetScorpion scorp = new MoCEntityPetScorpion((EntityType<? extends MoCEntityPetScorpion>)((EntityType)MoCEntities.PET_SCORPION.get()), this.m_9236_());
                scorp.setTypeMoC(this.getEggType() - 40);
                scorp.setAdult(false);
                scorp.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)scorp);
                if (player != null) {
                    MoCTools.tameWithName(player, scorp);
                }
            }
            if (this.getEggType() > 49 && this.getEggType() < 62) {
                MoCEntityWyvern wyv = new MoCEntityWyvern((EntityType<? extends MoCEntityWyvern>)((EntityType)MoCEntities.WYVERN.get()), this.m_9236_());
                wyv.setTypeMoC(this.getEggType() - 49);
                wyv.setAdult(false);
                wyv.m_146762_(30);
                this.spawnEggEntity((Mob)wyv, player);
                wyv.m_21153_(wyv.m_21233_());
            }
            if (this.getEggType() > 61 && this.getEggType() < 67) {
                MoCEntityManticorePet mant = new MoCEntityManticorePet((EntityType<? extends MoCEntityManticorePet>)((EntityType)MoCEntities.MANTICORE_PET.get()), this.m_9236_());
                mant.setTypeMoC(this.getEggType() - 61);
                mant.setAdult(false);
                mant.m_146762_(30);
                this.spawnEggEntity((Mob)mant, player);
                mant.m_21153_(mant.m_21233_());
            }
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            this.m_146870_();
        }
    }

    private void spawnEggEntity(Mob entity, Player owner) {
        entity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (entity instanceof AgeableMob) {
            ((AgeableMob)entity).m_146762_(-24000);
        }
        this.m_9236_().m_7967_((Entity)entity);
        if (owner != null) {
            MoCTools.tameWithName(owner, (IMoCTameable)entity);
        }
    }

    private void notifyEggHatching() {
        Player player = this.m_9236_().m_45930_((Entity)this, 24.0);
        if (player != null) {
            player.m_213846_((Component)Component.m_237110_((String)"msg.mocreatures.egg", (Object[])new Object[]{(int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()}));
        }
    }

    public int getEggType() {
        return this.eggType;
    }

    public void setEggType(int eggType) {
        this.eggType = eggType;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.eggType = compound.m_128451_("EggType");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("EggType", this.eggType);
    }

    public boolean m_6783_(double distanceSq) {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

