/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.item;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hostile.MoCEntityOgre;
import drzhark.mocreatures.init.MoCItems;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class MoCEntityLitterBox
extends Mob {
    private static final EntityDataAccessor<Boolean> PICKED_UP = SynchedEntityData.m_135353_(MoCEntityLitterBox.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> USED_LITTER = SynchedEntityData.m_135353_(MoCEntityLitterBox.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int litterTime;

    public MoCEntityLitterBox(EntityType<? extends MoCEntityLitterBox> type, Level world) {
        super(type, world);
        this.m_21557_(true);
    }

    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture("litter_box.png");
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PICKED_UP, (Object)false);
        this.f_19804_.m_135372_(USED_LITTER, (Object)false);
    }

    public boolean getPickedUp() {
        return (Boolean)this.f_19804_.m_135370_(PICKED_UP);
    }

    public void setPickedUp(boolean flag) {
        this.f_19804_.m_135381_(PICKED_UP, (Object)flag);
    }

    public boolean getUsedLitter() {
        return (Boolean)this.f_19804_.m_135370_(USED_LITTER);
    }

    public void setUsedLitter(boolean flag) {
        this.f_19804_.m_135381_(USED_LITTER, (Object)flag);
    }

    public boolean m_6094_() {
        return !this.m_213877_();
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected float m_6121_() {
        return 0.0f;
    }

    public double m_6048_() {
        return 0.0;
    }

    public void m_7822_(byte byte0) {
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_150930_(Item.m_41439_((Block)Blocks.f_49992_))) {
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_12334_);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setUsedLitter(false);
            this.litterTime = 0;
            return InteractionResult.SUCCESS;
        }
        if (this.m_20202_() == null) {
            if (player.m_6047_()) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)MoCItems.LITTER_BOX.get()));
                MoCTools.playCustomSound((Entity)this, SoundEvents.f_12019_, 0.2f);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                this.m_5616_((float)MoCTools.roundToNearest90Degrees(this.m_6080_()) + 90.0f);
                MoCTools.playCustomSound((Entity)this, SoundEvents.f_12017_);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        if (!(this.m_9236_().m_5776_() || this.m_20202_() == null && this.m_20096_() && MoCreatures.proxy.staticLitter)) {
            super.m_6478_(type, pos);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20096_()) {
            this.setPickedUp(false);
        }
        if (this.getUsedLitter()) {
            if (!this.m_9236_().m_5776_()) {
                ++this.litterTime;
                List list = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(12.0, 4.0, 12.0), entity -> entity instanceof Monster);
                for (Entity entity2 : list) {
                    if (!(entity2 instanceof Monster)) continue;
                    Monster entityMob = (Monster)entity2;
                    entityMob.m_6710_((LivingEntity)this);
                    if (entityMob instanceof Creeper) {
                        ((Creeper)entityMob).m_32283_(-1);
                    }
                    if (!(entityMob instanceof MoCEntityOgre)) continue;
                    ((MoCEntityOgre)entityMob).smashCounter = 0;
                }
            } else {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        if (this.litterTime > 5000 && !this.m_9236_().m_5776_()) {
            this.setUsedLitter(false);
            this.litterTime = 0;
        }
        if (this.m_20159_()) {
            MoCTools.dismountSneakingPlayer(this);
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("UsedLitter", this.getUsedLitter());
    }

    public void m_7378_(CompoundTag compound) {
        this.setUsedLitter(compound.m_128471_("UsedLitter"));
    }

    public boolean m_6469_(DamageSource damagesource, float i) {
        return false;
    }
}

