/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.item;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.hostile.MoCEntityGolem;
import drzhark.mocreatures.init.MoCEntities;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class MoCEntityThrowableRock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> ROCK_STATE = SynchedEntityData.m_135353_(MoCEntityThrowableRock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MASTERS_ID = SynchedEntityData.m_135353_(MoCEntityThrowableRock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BEHAVIOUR_TYPE = SynchedEntityData.m_135353_(MoCEntityThrowableRock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int acceleration = 100;
    private int rockTimer;
    private double oPosX;
    private double oPosY;
    private double oPosZ;

    public MoCEntityThrowableRock(EntityType<? extends MoCEntityThrowableRock> type, Level world) {
        super(type, world);
        this.f_19794_ = false;
    }

    public static MoCEntityThrowableRock build(Level world, Entity entitythrower, double posX, double posY, double posZ) {
        MoCEntityThrowableRock rock = new MoCEntityThrowableRock((EntityType<? extends MoCEntityThrowableRock>)((EntityType)MoCEntities.TROCK.get()), world);
        rock.m_6034_(posX, posY, posZ);
        rock.rockTimer = 250;
        rock.f_19854_ = rock.oPosX = posX;
        rock.f_19855_ = rock.oPosY = posY;
        rock.f_19856_ = rock.oPosZ = posZ;
        rock.setMasterID(entitythrower.m_19879_());
        return rock;
    }

    public BlockState getState() {
        BlockState state = Block.m_49803_((int)((Integer)this.f_19804_.m_135370_(ROCK_STATE) & 0xFFFF));
        return state == null || state.m_60795_() ? Blocks.f_50069_.m_49966_() : state;
    }

    public void setState(BlockState state) {
        this.f_19804_.m_135381_(ROCK_STATE, (Object)(Block.m_49956_((BlockState)state) & 0xFFFF));
    }

    public int getMasterID() {
        return (Integer)this.f_19804_.m_135370_(MASTERS_ID);
    }

    public void setMasterID(int i) {
        this.f_19804_.m_135381_(MASTERS_ID, (Object)i);
    }

    public int getBehavior() {
        return (Integer)this.f_19804_.m_135370_(BEHAVIOUR_TYPE);
    }

    public void setBehavior(int i) {
        this.f_19804_.m_135381_(BEHAVIOUR_TYPE, (Object)i);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BEHAVIOUR_TYPE, (Object)0);
        this.f_19804_.m_135372_(ROCK_STATE, (Object)0);
        this.f_19804_.m_135372_(MASTERS_ID, (Object)0);
    }

    public void m_7380_(CompoundTag nbttagcompound) {
        BlockState iblockstate = this.getState();
        nbttagcompound = MoCTools.getEntityData(this);
        nbttagcompound.m_128405_("Behavior", this.getBehavior());
        nbttagcompound.m_128405_("MasterID", this.getMasterID());
        nbttagcompound.m_128376_("BlockID", (short)(Block.m_49956_((BlockState)iblockstate) & 0xFFFF));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7378_(CompoundTag nbttagcompound) {
        nbttagcompound = MoCTools.getEntityData(this);
        this.setBehavior(nbttagcompound.m_128451_("Behavior"));
        this.setMasterID(nbttagcompound.m_128451_("MasterID"));
        BlockState iblockstate = Block.m_49803_((int)(nbttagcompound.m_128448_("BlockID") & 0xFFFF));
        this.setState(iblockstate);
    }

    public boolean m_5829_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        Entity master = this.getMaster();
        if (this.rockTimer-- <= -50 && this.getBehavior() == 0 || master == null) {
            this.transformToItem();
        }
        if (this.getBehavior() == 1) {
            return;
        }
        if (!this.m_20096_()) {
            List list = this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82310_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_).m_82377_(1.0, 1.0, 1.0));
            for (Entity entity : list) {
                if (master != null && entity.m_19879_() == master.m_19879_() || entity instanceof MoCEntityGolem || entity != null && !(entity instanceof LivingEntity) || !(entity instanceof LivingEntity)) continue;
                if (master instanceof LivingEntity) {
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)master), 4.0f);
                    continue;
                }
                entity.m_6469_(this.m_269291_().m_269264_(), 4.0f);
            }
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.getBehavior() == 2) {
            float tZ;
            float tX;
            float distXZToMaster;
            if (master == null) {
                this.setBehavior(0);
                this.rockTimer = -50;
                return;
            }
            --this.acceleration;
            if (this.acceleration < 10) {
                this.acceleration = 10;
            }
            if ((distXZToMaster = (tX = (float)this.m_20185_() - (float)master.m_20185_()) * tX + (tZ = (float)this.m_20189_() - (float)master.m_20189_()) * tZ) < 1.5f && master instanceof MoCEntityGolem) {
                ((MoCEntityGolem)master).receiveRock(this.getState());
                this.setBehavior(0);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            double summonedSpeed = this.acceleration;
            this.m_20334_((master.m_20185_() - this.m_20185_()) / summonedSpeed, (master.m_20186_() - this.m_20186_()) / 20.0 + 0.15, (master.m_20189_() - this.m_20189_()) / summonedSpeed);
            if (!this.m_9236_().m_5776_()) {
                this.m_6478_(MoverType.SELF, this.m_20184_());
            }
            return;
        }
        if (this.getBehavior() == 4) {
            if (master == null) {
                if (!this.m_9236_().m_5776_()) {
                    this.setBehavior(5);
                }
                return;
            }
            this.acceleration = 10;
            float tX = (float)this.m_20185_() - (float)master.m_20185_();
            float tZ = (float)this.m_20189_() - (float)master.m_20189_();
            float distXZToMaster = tX * tX + tZ * tZ;
            double summonedSpeed = this.acceleration;
            this.m_20334_((master.m_20185_() - this.m_20185_()) / summonedSpeed, (master.m_20186_() - this.m_20186_()) / 20.0 + 0.15, (master.m_20189_() - this.m_20189_()) / summonedSpeed);
            if (distXZToMaster < 2.5f && master instanceof MoCEntityGolem) {
                this.m_20334_(0.0, 0.0, 0.0);
            }
        }
        if (this.getBehavior() == 5) {
            --this.acceleration;
            if (this.acceleration < 3) {
                this.acceleration = 3;
            }
            double explodingSpeed = this.acceleration / 5;
            this.m_20334_(this.m_20184_().f_82479_ / explodingSpeed, this.m_20184_().f_82480_ / explodingSpeed, this.m_20184_().f_82481_ / explodingSpeed);
        }
        if (this.getBehavior() == 0) {
            Vec3 motion = this.m_20184_();
            if (!this.m_20068_()) {
                motion = motion.m_82520_(0.0, -0.04, 0.0);
            }
            motion = motion.m_82490_((double)0.98f);
            this.m_20256_(motion);
            this.m_6478_(MoverType.SELF, motion);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void transformToItem() {
        if (!this.m_9236_().m_5776_()) {
            ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)this.getState().m_60734_(), 1));
            entityitem.m_20334_(0.0, 0.1, 0.0);
            entityitem.m_32060_();
            this.m_9236_().m_7967_((Entity)entityitem);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private Entity getMaster() {
        Entity master = null;
        List list = this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82377_(120.0, 120.0, 120.0));
        for (Entity entity : list) {
            if (entity.m_19879_() != this.getMasterID()) continue;
            master = entity;
            return master;
        }
        return master;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        BlockState state = this.getState();
        buffer.writeInt(Block.m_49956_((BlockState)state));
        buffer.writeInt(this.getBehavior());
        buffer.writeInt(this.getMasterID());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.setState(Block.m_49803_((int)buffer.readInt()));
        this.setBehavior(buffer.readInt());
        this.setMasterID(buffer.readInt());
    }
}

