/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.neutral;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.inventory.CombinedContainer;
import drzhark.mocreatures.entity.inventory.MoCAnimalChest;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityElephant
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Integer> TUSK_TYPE = SynchedEntityData.m_135353_(MoCEntityElephant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STORAGE_TYPE = SynchedEntityData.m_135353_(MoCEntityElephant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HARNESS_TYPE = SynchedEntityData.m_135353_(MoCEntityElephant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int sprintCounter;
    public int sitCounter;
    public MoCAnimalChest localelephantchest;
    public MoCAnimalChest localelephantchest2;
    public MoCAnimalChest localelephantchest3;
    public MoCAnimalChest localelephantchest4;
    public ItemStack localstack;
    public int tailCounter;
    public int trunkCounter;
    public int earCounter;
    boolean hasPlatform;
    private byte tuskUses;
    private byte temper;
    private int xpReward;

    public MoCEntityElephant(EntityType<? extends MoCEntityElephant> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setAdult(true);
        this.setTamed(false);
        this.setMoCAge(50);
        this.m_274367_(1.0f);
        this.xpReward = 10;
        if (!this.m_9236_().m_5776_()) {
            this.setAdult(this.f_19796_.m_188503_(4) != 0);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIFollowAdult((Mob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(2) + 1);
        }
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.calculateMaxHealth());
        this.m_21153_(this.m_21233_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TUSK_TYPE, (Object)0);
        this.f_19804_.m_135372_(STORAGE_TYPE, (Object)0);
        this.f_19804_.m_135372_(HARNESS_TYPE, (Object)0);
    }

    public int getTusks() {
        return (Integer)this.f_19804_.m_135370_(TUSK_TYPE);
    }

    public void setTusks(int i) {
        this.f_19804_.m_135381_(TUSK_TYPE, (Object)i);
    }

    @Override
    public int getArmorType() {
        return (Integer)this.f_19804_.m_135370_(HARNESS_TYPE);
    }

    @Override
    public void setArmorType(int i) {
        this.f_19804_.m_135381_(HARNESS_TYPE, (Object)i);
    }

    public int getStorage() {
        return (Integer)this.f_19804_.m_135370_(STORAGE_TYPE);
    }

    public void setStorage(int i) {
        this.f_19804_.m_135381_(STORAGE_TYPE, (Object)i);
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("elephant_asian.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("mammoth_woolly.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("mammoth_songhua.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("elephant_asian_decorated.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("elephant_african.png");
    }

    public int m_213860_() {
        return this.xpReward;
    }

    public float calculateMaxHealth() {
        switch (this.getTypeMoC()) {
            case 1: 
            case 5: {
                return 40.0f;
            }
            case 3: {
                return 50.0f;
            }
            case 4: {
                return 60.0f;
            }
        }
        return 30.0f;
    }

    @Override
    public double getCustomSpeed() {
        if (this.sitCounter != 0) {
            return 0.0;
        }
        double tSpeed = 0.5;
        if (this.getTypeMoC() == 1) {
            tSpeed = 0.55;
        } else if (this.getTypeMoC() == 2) {
            tSpeed = 0.6;
        } else if (this.getTypeMoC() == 4) {
            tSpeed = 0.55;
        }
        if (this.sprintCounter > 0 && this.sprintCounter < 150) {
            tSpeed *= 1.5;
        }
        if (this.sprintCounter > 150) {
            tSpeed *= 0.5;
        }
        return tSpeed;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20197_().isEmpty()) {
            Entity passenger = (Entity)this.m_20197_().get(0);
            double dist = 0.0;
            switch (this.getTypeMoC()) {
                case 1: {
                    dist = 1.0;
                    break;
                }
                case 2: 
                case 5: {
                    dist = 0.75;
                    break;
                }
                case 3: {
                    dist = 1.2;
                    break;
                }
                case 4: {
                    dist = 1.5;
                }
            }
            double cosYaw = Math.cos(MoCTools.realAngle(this.m_146908_() - 90.0f) / 57.29578f);
            double sinYaw = Math.sin(MoCTools.realAngle(this.m_146908_() - 90.0f) / 57.29578f);
            double newPosX = this.m_20185_() - dist * cosYaw;
            double newPosZ = this.m_20189_() - dist * sinYaw;
            passenger.m_6034_(newPosX, this.m_20186_() + this.m_6048_() + passenger.m_6048_(), newPosZ);
        }
        if (!this.m_9236_().m_5776_()) {
            Player ep;
            if (this.sprintCounter > 0 && this.sprintCounter < 150 && this.m_20160_() && this.f_19796_.m_188503_(15) == 0) {
                MoCTools.buckleMobsNotPlayers((Mob)this, 3.0, this.m_9236_());
            }
            if (this.sprintCounter > 0 && ++this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
            if (this.getIsTamed() && !this.m_20160_() && this.getArmorType() >= 1 && this.f_19796_.m_188503_(20) == 0 && (ep = this.m_9236_().m_45930_((Entity)this, 3.0)) != null && (!MoCreatures.proxy.enableOwnership || ep.m_20148_().equals(this.getOwnerId())) && ep.m_6047_()) {
                this.sit();
            }
            if (MoCreatures.proxy.elephantBulldozer && this.getIsTamed() && this.m_20160_() && this.getTusks() > 0) {
                int height = 2;
                if (this.getTypeMoC() == 3) {
                    height = 3;
                }
                if (this.getTypeMoC() == 4) {
                    height = 3;
                }
                int dmg = MoCTools.destroyBlocksInFront((Entity)this, 2.0, this.getTusks(), height);
                this.checkTusks(dmg);
            }
        } else {
            if (this.tailCounter > 0 && ++this.tailCounter > 8) {
                this.tailCounter = 0;
            }
            if (this.f_19796_.m_188503_(200) == 0) {
                this.tailCounter = 1;
            }
            if (this.trunkCounter > 0 && ++this.trunkCounter > 38) {
                this.trunkCounter = 0;
            }
            if (this.trunkCounter == 0 && this.f_19796_.m_188503_(200) == 0) {
                this.trunkCounter = this.f_19796_.m_188503_(10) + 1;
            }
            if (this.earCounter > 0 && ++this.earCounter > 10) {
                this.earCounter = 0;
            }
            if (this.earCounter == 0 && this.f_19796_.m_188503_(250) == 0) {
                this.earCounter = 1;
            }
        }
        if (this.sitCounter != 0 && ++this.sitCounter > 300) {
            this.sitCounter = 0;
        }
    }

    private void checkTusks(int dmg) {
        this.tuskUses = (byte)(this.tuskUses + (byte)dmg);
        if (this.getTusks() == 1 && this.tuskUses > 59 || this.getTusks() == 2 && this.tuskUses > 250 || this.getTusks() == 3 && this.tuskUses > 1000) {
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_TURTLE_HURT.get());
            this.setTusks(0);
        }
    }

    private void sit() {
        this.sitCounter = 1;
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
        }
        this.m_21573_().m_26573_();
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.sitCounter = 1;
            this.m_21573_().m_26573_();
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (!(stack.m_41619_() || this.getIsTamed() || this.getIsAdult() || stack.m_41720_() != Items.f_42502_)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            this.temper = (byte)(this.temper + 2);
            this.m_21153_(this.m_21233_());
            if (!(this.m_9236_().m_5776_() || this.getIsAdult() || this.getIsTamed() || this.temper < 10)) {
                MoCTools.tameWithName(player, this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (!(stack.m_41619_() || this.getIsTamed() || this.getIsAdult() || stack.m_41720_() != MoCItems.SUGAR_LUMP.get())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            this.temper = (byte)(this.temper + 1);
            this.m_21153_(this.m_21233_());
            if (!(this.m_9236_().m_5776_() || this.getIsAdult() || this.getIsTamed() || this.temper < 10)) {
                this.setTamed(true);
                MoCTools.tameWithName(player, this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.getIsTamed() && stack.m_41619_() && !player.m_6144_() && this.getStorage() > 0) {
            if (!this.m_9236_().m_5776_()) {
                if (this.localelephantchest == null) {
                    this.initChest();
                }
                if (this.getStorage() == 1) {
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ChestMenu(MenuType.f_39958_, id, inventory, (Container)this.localelephantchest, 2), (Component)Component.m_237115_((String)"container.elephant_chest")));
                } else if (this.getStorage() == 2) {
                    CombinedContainer combinedContainer = new CombinedContainer(new Container[]{this.localelephantchest, this.localelephantchest2});
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ChestMenu(MenuType.f_39960_, id, inventory, (Container)combinedContainer, 4), (Component)Component.m_237115_((String)"container.elephant_chest")));
                } else if (this.getStorage() == 3) {
                    CombinedContainer combinedContainer = new CombinedContainer(new Container[]{this.localelephantchest, this.localelephantchest2, this.localelephantchest3});
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ChestMenu(MenuType.f_39961_, id, inventory, (Container)combinedContainer, 5), (Component)Component.m_237115_((String)"container.elephant_chest")));
                } else if (this.getStorage() == 4) {
                    CombinedContainer combinedContainer = new CombinedContainer(new Container[]{this.localelephantchest, this.localelephantchest2, this.localelephantchest3, this.localelephantchest4});
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> ChestMenu.m_39246_((int)id, (Inventory)inventory, (Container)combinedContainer), (Component)Component.m_237115_((String)"container.elephant_chest")));
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.getStorage() < 2 && this.getIsTamed() && stack.m_150930_((Item)MoCItems.ELEPHANTCHEST.get()) && this.getArmorType() != 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setStorage(this.getStorage() + 1);
                this.initChest();
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.getStorage() < 4 && this.getStorage() > 1 && this.getIsTamed() && stack.m_150930_(Blocks.f_50087_.m_5456_()) && this.getArmorType() != 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setStorage(this.getStorage() + 1);
                this.initChest();
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.getArmorType() == 0 && stack.m_150930_((Item)MoCItems.ELEPHANTHARNESS.get()) && this.getIsTamed()) {
            if (!this.m_9236_().m_5776_()) {
                this.setArmorType(1);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getIsAdult() && this.getArmorType() == 1 && this.getTypeMoC() == 2 && stack.m_41720_() == MoCItems.ELEPHANTGARMENT.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ROPING.get());
            this.setArmorType(2);
            this.setTypeMoC(5);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getIsAdult() && this.getArmorType() == 2 && this.getTypeMoC() == 5 && stack.m_41720_() == MoCItems.ELEPHANTHOWDAH.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ROPING.get());
            this.setArmorType(3);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getIsAdult() && this.getArmorType() == 1 && this.getTypeMoC() == 4 && stack.m_41720_() == MoCItems.MAMMOTHPLATFORM.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF.get());
            this.setArmorType(3);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getIsAdult() && stack.m_41720_() == MoCItems.TUSKSWOOD.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF.get());
            this.dropTusks();
            this.tuskUses = (byte)stack.m_41773_();
            this.setTusks(1);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getIsAdult() && stack.m_41720_() == MoCItems.TUSKSIRON.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF.get());
            this.dropTusks();
            this.tuskUses = (byte)stack.m_41773_();
            this.setTusks(2);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getIsAdult() && stack.m_41720_() == MoCItems.TUSKSDIAMOND.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF.get());
            this.dropTusks();
            this.tuskUses = (byte)stack.m_41773_();
            this.setTusks(3);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_()) {
            this.initChest();
            if (this.getStorage() >= 1) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        if (!stack.m_41619_() && this.getTusks() > 0 && stack.m_41720_() instanceof PickaxeItem) {
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF.get());
            this.dropTusks();
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.getIsTamed() && this.getIsAdult() && this.getArmorType() >= 1 && this.sitCounter != 0) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.sitCounter = 0;
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    private void initChest() {
        if (this.getStorage() > 0 && this.localelephantchest == null) {
            this.localelephantchest = new MoCAnimalChest("ElephantChest", MoCAnimalChest.Size.small);
        }
        if (this.getStorage() > 1 && this.localelephantchest2 == null) {
            this.localelephantchest2 = new MoCAnimalChest("ElephantChest", MoCAnimalChest.Size.small);
        }
        if (this.getStorage() > 2 && this.localelephantchest3 == null) {
            this.localelephantchest3 = new MoCAnimalChest("ElephantChest", MoCAnimalChest.Size.tiny);
        }
        if (this.getStorage() > 3 && this.localelephantchest4 == null) {
            this.localelephantchest4 = new MoCAnimalChest("ElephantChest", MoCAnimalChest.Size.tiny);
        }
    }

    private void dropTusks() {
        ItemEntity entityitem;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        int i = this.getTusks();
        this.setTusks(0);
        if (i == 1) {
            entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)MoCItems.TUSKSWOOD.get(), 1));
            entityitem.m_32055_().m_41721_((int)this.tuskUses);
            entityitem.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityitem);
        }
        if (i == 2) {
            entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)MoCItems.TUSKSIRON.get(), 1));
            entityitem.m_32055_().m_41721_((int)this.tuskUses);
            entityitem.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityitem);
        }
        if (i == 3) {
            entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)MoCItems.TUSKSDIAMOND.get(), 1));
            entityitem.m_32055_().m_41721_((int)this.tuskUses);
            entityitem.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityitem);
        }
        this.setTusks(0);
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_), Mth.m_14107_((double)this.m_20189_()));
        ResourceKey<Biome> currentbiome = MoCTools.biomeKind(this.m_9236_(), pos);
        String biomeName = currentbiome.m_135782_().toString().toLowerCase();
        if (biomeName.contains("savanna") || biomeName.contains("desert")) {
            this.setTypeMoC(1);
            return true;
        }
        if (biomeName.contains("jungle")) {
            this.setTypeMoC(2);
            return true;
        }
        if (biomeName.contains("snowy") || biomeName.contains("frozen") || biomeName.contains("cold")) {
            this.setTypeMoC(3 + this.f_19796_.m_188503_(2));
            return true;
        }
        return false;
    }

    @Override
    public float getSizeFactor() {
        float sizeF = 1.25f;
        switch (this.getTypeMoC()) {
            case 4: {
                sizeF *= 1.2f;
                break;
            }
            case 2: 
            case 5: {
                sizeF *= 0.8f;
            }
        }
        if (!this.getIsAdult()) {
            sizeF *= (float)this.getMoCAge() * 0.01f;
        }
        return sizeF;
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        CompoundTag nbttagcompound1;
        int i;
        ListTag nbttaglist;
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128405_("Tusks", this.getTusks());
        nbttagcompound.m_128405_("Harness", this.getArmorType());
        nbttagcompound.m_128405_("Storage", this.getStorage());
        nbttagcompound.m_128344_("Temper", this.temper);
        nbttagcompound.m_128344_("TuskUses", this.tuskUses);
        if (this.getStorage() > 0 && this.localelephantchest != null) {
            nbttaglist = new ListTag();
            for (i = 0; i < this.localelephantchest.m_6643_(); ++i) {
                this.localstack = this.localelephantchest.m_8020_(i);
                if (this.localstack.m_41619_()) continue;
                nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localstack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items", (Tag)nbttaglist);
        }
        if (this.getStorage() >= 2 && this.localelephantchest2 != null) {
            nbttaglist = new ListTag();
            for (i = 0; i < this.localelephantchest2.m_6643_(); ++i) {
                this.localstack = this.localelephantchest2.m_8020_(i);
                if (this.localstack.m_41619_()) continue;
                nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localstack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items2", (Tag)nbttaglist);
        }
        if (this.getStorage() >= 3 && this.localelephantchest3 != null) {
            nbttaglist = new ListTag();
            for (i = 0; i < this.localelephantchest3.m_6643_(); ++i) {
                this.localstack = this.localelephantchest3.m_8020_(i);
                if (this.localstack.m_41619_()) continue;
                nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localstack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items3", (Tag)nbttaglist);
        }
        if (this.getStorage() >= 4 && this.localelephantchest4 != null) {
            nbttaglist = new ListTag();
            for (i = 0; i < this.localelephantchest4.m_6643_(); ++i) {
                this.localstack = this.localelephantchest4.m_8020_(i);
                if (this.localstack.m_41619_()) continue;
                nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localstack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items4", (Tag)nbttaglist);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        int j;
        CompoundTag nbttagcompound1;
        int i;
        ListTag nbttaglist;
        super.m_7378_(nbttagcompound);
        this.setTusks(nbttagcompound.m_128451_("Tusks"));
        this.setArmorType(nbttagcompound.m_128451_("Harness"));
        this.setStorage(nbttagcompound.m_128451_("Storage"));
        this.temper = nbttagcompound.m_128445_("Temper");
        this.tuskUses = nbttagcompound.m_128445_("TuskUses");
        if (this.getStorage() > 0) {
            nbttaglist = nbttagcompound.m_128437_("Items", 10);
            this.localelephantchest = new MoCAnimalChest("ElephantChest", MoCAnimalChest.Size.small);
            for (i = 0; i < nbttaglist.size(); ++i) {
                nbttagcompound1 = nbttaglist.m_128728_(i);
                j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localelephantchest.m_6643_()) continue;
                this.localelephantchest.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
        if (this.getStorage() >= 2) {
            nbttaglist = nbttagcompound.m_128437_("Items2", 10);
            this.localelephantchest2 = new MoCAnimalChest("ElephantChest", MoCAnimalChest.Size.small);
            for (i = 0; i < nbttaglist.size(); ++i) {
                nbttagcompound1 = nbttaglist.m_128728_(i);
                j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localelephantchest2.m_6643_()) continue;
                this.localelephantchest2.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
        if (this.getStorage() >= 3) {
            nbttaglist = nbttagcompound.m_128437_("Items3", 10);
            this.localelephantchest3 = new MoCAnimalChest("ElephantChest", MoCAnimalChest.Size.tiny);
            for (i = 0; i < nbttaglist.size(); ++i) {
                nbttagcompound1 = nbttaglist.m_128728_(i);
                j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localelephantchest3.m_6643_()) continue;
                this.localelephantchest3.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
        if (this.getStorage() >= 4) {
            nbttaglist = nbttagcompound.m_128437_("Items4", 10);
            this.localelephantchest4 = new MoCAnimalChest("ElephantChest", MoCAnimalChest.Size.tiny);
            for (i = 0; i < nbttaglist.size(); ++i) {
                nbttagcompound1 = nbttaglist.m_128728_(i);
                j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localelephantchest4.m_6643_()) continue;
                this.localelephantchest4.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() == Items.f_42674_ || stack.m_41720_() == Items.f_42406_ || stack.m_41720_() == MoCItems.HAYSTACK.get());
    }

    @Override
    public boolean isMovementCeased() {
        return this.m_20160_() || this.sitCounter != 0;
    }

    @Override
    public void riding() {
        if (this.m_20160_() && this.m_146895_() instanceof Player) {
            Player player = (Player)this.m_146895_();
            List list = this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82377_(1.0, 0.0, 1.0));
            for (Entity entity : list) {
                if (entity.m_213877_() || !((double)this.m_20270_(entity) < 2.0) || entity instanceof Player) continue;
                entity.m_7334_((Entity)this);
            }
            if (player.m_6047_() && !this.m_9236_().m_5776_()) {
                if (this.sitCounter == 0) {
                    this.sit();
                }
                if (this.sitCounter >= 50) {
                    player.m_8127_();
                }
            }
        }
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    public boolean m_5829_() {
        return !this.m_20160_();
    }

    public double m_6048_() {
        double yOff = 0.0;
        boolean sit = this.sitCounter != 0;
        switch (this.getTypeMoC()) {
            case 1: 
            case 3: {
                yOff = 0.55;
                if (!sit) break;
                yOff = -0.05;
                break;
            }
            case 2: 
            case 5: {
                yOff = -0.17;
                if (!sit) break;
                yOff = -0.5;
                break;
            }
            case 4: {
                yOff = 1.2;
                if (!sit) break;
                yOff = 0.45;
            }
        }
        return yOff + (double)this.m_20206_() * 0.75;
    }

    @Override
    public boolean m_5830_() {
        return false;
    }

    public int m_8100_() {
        return 300;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_ELEPHANT_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_ELEPHANT_HURT.get();
    }

    protected SoundEvent m_7515_() {
        if (!this.getIsAdult() && this.getMoCAge() < 80) {
            return (SoundEvent)MoCSoundEvents.ENTITY_ELEPHANT_AMBIENT_BABY.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_ELEPHANT_AMBIENT.get();
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        int i = this.f_19796_.m_188503_(3);
        if (looting > 0) {
            i += this.f_19796_.m_188503_(looting + 1);
        }
        this.m_19983_(new ItemStack((ItemLike)MoCItems.ANIMALHIDE.get(), i));
    }

    @Override
    public void dropMyStuff() {
        if (!this.m_9236_().m_5776_()) {
            this.dropTusks();
            if (this.getStorage() > 0) {
                if (this.getStorage() > 0) {
                    MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)MoCItems.ELEPHANTCHEST.get(), 1));
                    if (this.localelephantchest != null) {
                        MoCTools.dropInventory((Entity)this, this.localelephantchest);
                    }
                }
                if (this.getStorage() >= 2) {
                    if (this.localelephantchest2 != null) {
                        MoCTools.dropInventory((Entity)this, this.localelephantchest2);
                    }
                    MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)MoCItems.ELEPHANTCHEST.get(), 1));
                }
                if (this.getStorage() >= 3) {
                    if (this.localelephantchest3 != null) {
                        MoCTools.dropInventory((Entity)this, this.localelephantchest3);
                    }
                    MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)Blocks.f_50087_, 1));
                }
                if (this.getStorage() >= 4) {
                    if (this.localelephantchest4 != null) {
                        MoCTools.dropInventory((Entity)this, this.localelephantchest4);
                    }
                    MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)Blocks.f_50087_, 1));
                }
                this.setStorage(0);
            }
            this.dropArmor();
        }
    }

    @Override
    public void dropArmor() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.getArmorType() >= 1) {
            MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)MoCItems.ELEPHANTHARNESS.get(), 1));
        }
        if (this.getTypeMoC() == 5 && this.getArmorType() >= 2) {
            MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)MoCItems.ELEPHANTGARMENT.get(), 1));
            if (this.getArmorType() == 3) {
                MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)MoCItems.ELEPHANTHOWDAH.get(), 1));
            }
            this.setTypeMoC(2);
        }
        if (this.getTypeMoC() == 4 && this.getArmorType() == 3) {
            MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)MoCItems.MAMMOTHPLATFORM.get(), 1));
        }
        this.setArmorType(0);
    }

    @Override
    public int nameYOffset() {
        int yOff = (int)((float)(100 / this.getMoCAge()) * (this.getSizeFactor() * -110.0f));
        if (this.getIsAdult()) {
            yOff = (int)(this.getSizeFactor() * -110.0f);
        }
        if (this.sitCounter != 0) {
            yOff += 25;
        }
        return yOff;
    }

    @Override
    public boolean isNotScared() {
        return this.getIsAdult() || this.getMoCAge() > 80 || this.getIsTamed();
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (super.m_6469_(damagesource, amount)) {
            Entity entity = damagesource.m_7639_();
            if (entity != null && this.getIsTamed() && entity instanceof Player || !(entity instanceof LivingEntity)) {
                return false;
            }
            if (this.m_20160_() && this.m_20363_(entity)) {
                return true;
            }
            if (entity != this && super.shouldAttackPlayers()) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        int i = (int)Math.ceil(distance - 3.0f);
        if (i > 0) {
            if ((i /= 2) > 0) {
                this.m_6469_(this.m_269291_().m_268989_(), i);
            }
            if (this.m_20160_() && i > 0) {
                for (Entity entity : this.m_20197_()) {
                    entity.m_6469_(this.m_269291_().m_268989_(), (float)i);
                }
            }
            BlockPos blockPos = this.m_20183_();
            BlockState blockState = this.m_9236_().m_8055_(blockPos);
            Block block = blockState.m_60734_();
            if (!this.m_20067_()) {
                SoundType soundtype = block.getSoundType(blockState, (LevelReader)this.m_9236_(), blockPos, (Entity)this);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundtype.m_56776_(), this.m_5720_(), soundtype.m_56773_() * 0.5f, soundtype.m_56774_() * 0.75f);
            }
            return true;
        }
        return false;
    }
}

