/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.neutral;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.inventory.MoCAnimalChest;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityOstrich
extends MoCEntityTameableAnimal {
    private static final BiMap<DyeColor, Item> WOOL_BY_COLOR = (BiMap)Util.m_137469_((Object)EnumHashBiMap.create(DyeColor.class), p_203402_0_ -> {
        p_203402_0_.put((Enum)DyeColor.WHITE, (Object)Items.f_41870_);
        p_203402_0_.put((Enum)DyeColor.ORANGE, (Object)Items.f_41871_);
        p_203402_0_.put((Enum)DyeColor.MAGENTA, (Object)Items.f_41872_);
        p_203402_0_.put((Enum)DyeColor.LIGHT_BLUE, (Object)Items.f_41873_);
        p_203402_0_.put((Enum)DyeColor.YELLOW, (Object)Items.f_41874_);
        p_203402_0_.put((Enum)DyeColor.LIME, (Object)Items.f_41875_);
        p_203402_0_.put((Enum)DyeColor.PINK, (Object)Items.f_41876_);
        p_203402_0_.put((Enum)DyeColor.GRAY, (Object)Items.f_41877_);
        p_203402_0_.put((Enum)DyeColor.LIGHT_GRAY, (Object)Items.f_41878_);
        p_203402_0_.put((Enum)DyeColor.CYAN, (Object)Items.f_41932_);
        p_203402_0_.put((Enum)DyeColor.PURPLE, (Object)Items.f_41933_);
        p_203402_0_.put((Enum)DyeColor.BLUE, (Object)Items.f_41934_);
        p_203402_0_.put((Enum)DyeColor.BROWN, (Object)Items.f_41935_);
        p_203402_0_.put((Enum)DyeColor.GREEN, (Object)Items.f_41936_);
        p_203402_0_.put((Enum)DyeColor.RED, (Object)Items.f_41937_);
        p_203402_0_.put((Enum)DyeColor.BLACK, (Object)Items.f_41938_);
    });
    private static final EntityDataAccessor<Boolean> RIDEABLE = SynchedEntityData.m_135353_(MoCEntityOstrich.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EGG_WATCH = SynchedEntityData.m_135353_(MoCEntityOstrich.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(MoCEntityOstrich.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_HIDING = SynchedEntityData.m_135353_(MoCEntityOstrich.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FERTILE = SynchedEntityData.m_135353_(MoCEntityOstrich.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> HELMET_TYPE = SynchedEntityData.m_135353_(MoCEntityOstrich.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLAG_COLOR = SynchedEntityData.m_135353_(MoCEntityOstrich.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int mouthCounter;
    public int wingCounter;
    public int sprintCounter;
    public int jumpCounter;
    public int transformCounter;
    public int transformType;
    public MoCAnimalChest localchest;
    public ItemStack localstack;
    private int eggCounter;
    private int hidingCounter;
    private boolean isImmuneToFire;

    public MoCEntityOstrich(EntityType<? extends MoCEntityOstrich> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setAdult(true);
        this.setMoCAge(35);
        this.eggCounter = this.f_19796_.m_188503_(1000) + 1000;
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIFollowAdult((Mob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EGG_WATCH, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(RIDEABLE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(IS_HIDING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(FERTILE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(HELMET_TYPE, (Object)0);
        this.f_19804_.m_135372_(FLAG_COLOR, (Object)-1);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.f_19804_.m_135370_(RIDEABLE);
    }

    @Override
    public void setRideable(boolean flag) {
        this.f_19804_.m_135381_(RIDEABLE, (Object)flag);
    }

    public boolean getEggWatching() {
        return (Boolean)this.f_19804_.m_135370_(EGG_WATCH);
    }

    public void setEggWatching(boolean flag) {
        this.f_19804_.m_135381_(EGG_WATCH, (Object)flag);
    }

    public boolean getHiding() {
        return (Boolean)this.f_19804_.m_135370_(IS_HIDING);
    }

    public void setHiding(boolean flag) {
        this.f_19804_.m_135381_(IS_HIDING, (Object)flag);
    }

    public int getHelmet() {
        return (Integer)this.f_19804_.m_135370_(HELMET_TYPE);
    }

    public void setHelmet(int i) {
        this.f_19804_.m_135381_(HELMET_TYPE, (Object)i);
    }

    public DyeColor getFlagColor() {
        int i = (Integer)this.f_19804_.m_135370_(FLAG_COLOR);
        return i == -1 ? null : DyeColor.m_41053_((int)i);
    }

    public void setFlagColor(@Nullable DyeColor color) {
        this.f_19804_.m_135381_(FLAG_COLOR, (Object)(color == null ? -1 : color.m_41060_()));
    }

    public int getFlagColorRaw() {
        return (Integer)this.f_19804_.m_135370_(FLAG_COLOR);
    }

    public void setFlagColorRaw(int i) {
        this.f_19804_.m_135381_(FLAG_COLOR, (Object)i);
    }

    public boolean getIsChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setIsChested(boolean flag) {
        this.f_19804_.m_135381_(CHESTED, (Object)flag);
    }

    public boolean getIsFertile() {
        return (Boolean)this.f_19804_.m_135370_(FERTILE);
    }

    public void setFertile(boolean flag) {
        this.f_19804_.m_135381_(FERTILE, (Object)flag);
    }

    @Override
    public boolean isMovementCeased() {
        return this.getHiding() || this.m_20160_();
    }

    @Override
    public boolean isNotScared() {
        return this.getTypeMoC() == 2 && this.m_5448_() != null || this.getTypeMoC() > 2;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (this.getIsTamed() && this.getHelmet() != 0) {
            int j = 0;
            switch (this.getHelmet()) {
                case 1: {
                    j = 1;
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    j = 2;
                    break;
                }
                case 3: 
                case 7: {
                    j = 3;
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    j = 4;
                }
            }
            i -= (float)j;
            if (i <= 0.0f) {
                i = 1.0f;
            }
        }
        if (super.m_6469_(damagesource, i)) {
            Entity entity = damagesource.m_7639_();
            if (!(entity instanceof LivingEntity) || this.m_20160_() && entity == this.m_146895_() || entity instanceof Player && this.getIsTamed()) {
                return false;
            }
            if (entity != this && super.shouldAttackPlayers() && this.getTypeMoC() > 2) {
                this.m_6710_((LivingEntity)entity);
                this.flapWings();
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        this.dropMyStuff();
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (entityIn instanceof Player && !this.shouldAttackPlayers()) {
            return false;
        }
        this.openMouth();
        this.flapWings();
        return super.m_7327_(entityIn);
    }

    public float calculateMaxHealth() {
        switch (this.getTypeMoC()) {
            case 1: {
                return 10.0f;
            }
            case 3: 
            case 4: {
                return 25.0f;
            }
            case 5: 
            case 6: {
                return 35.0f;
            }
        }
        return 20.0f;
    }

    public boolean m_5829_() {
        return !this.m_20160_();
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            int j = this.f_19796_.m_188503_(100);
            if (j <= 20) {
                this.setTypeMoC(1);
            } else if (j <= 65) {
                this.setTypeMoC(2);
            } else if (j <= 95) {
                this.setTypeMoC(3);
            } else {
                this.setTypeMoC(4);
            }
        }
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.calculateMaxHealth());
        this.m_21153_(this.m_21233_());
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.transformCounter != 0 && this.transformType > 4) {
            String newText = "ostrich_male.png";
            if (this.transformType == 5) {
                newText = "ostrich_fire.png";
            }
            if (this.transformType == 6) {
                newText = "ostrich_dark.png";
            }
            if (this.transformType == 7) {
                newText = "ostrich_undead.png";
            }
            if (this.transformType == 8) {
                newText = "ostrich_light.png";
            }
            if (this.transformCounter % 5 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
            if (this.transformCounter > 50 && this.transformCounter % 3 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
            if (this.transformCounter > 75 && this.transformCounter % 4 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
        }
        switch (this.getTypeMoC()) {
            case 1: {
                return MoCreatures.proxy.getModelTexture("ostrich_baby.png");
            }
            case 2: {
                return MoCreatures.proxy.getModelTexture("ostrich_female.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("ostrich_white.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("ostrich_fire.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("ostrich_dark.png");
            }
            case 7: {
                return MoCreatures.proxy.getModelTexture("ostrich_undead.png");
            }
            case 8: {
                return MoCreatures.proxy.getModelTexture("ostrich_light.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("ostrich_male.png");
    }

    @Override
    public double getCustomSpeed() {
        double ostrichSpeed = 0.8;
        if (this.getTypeMoC() == 3) {
            ostrichSpeed = 1.1;
        } else if (this.getTypeMoC() == 4) {
            ostrichSpeed = 1.3;
        } else if (this.getTypeMoC() == 5) {
            ostrichSpeed = 1.4;
        }
        if (this.sprintCounter > 0 && this.sprintCounter < 200) {
            ostrichSpeed *= 1.5;
        }
        if (this.sprintCounter > 200) {
            ostrichSpeed *= 0.5;
        }
        return ostrichSpeed;
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getHiding()) {
            this.f_20883_ = this.f_20885_ = this.m_146908_();
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 20) {
            this.mouthCounter = 0;
        }
        if (this.wingCounter > 0 && ++this.wingCounter > 80) {
            this.wingCounter = 0;
        }
        if (this.jumpCounter > 0 && ++this.jumpCounter > 8) {
            this.jumpCounter = 0;
        }
        if (this.sprintCounter > 0 && ++this.sprintCounter > 300) {
            this.sprintCounter = 0;
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 40) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_TRANSFORM.get());
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.dropArmor();
                    this.setTypeMoC(this.transformType);
                    this.selectType();
                }
            }
        }
    }

    public void transform(int tType) {
        if (!this.m_9236_().f_46443_) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), tType));
        }
        this.transformType = tType;
        if (!this.m_20160_() && this.transformType != 0) {
            this.dropArmor();
            this.transformCounter = 1;
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType >= 5 && animationType < 9) {
            this.transformType = animationType;
            this.transformCounter = 1;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getIsTamed() && !this.m_9236_().f_46443_ && this.f_19796_.m_188503_(300) == 0 && this.m_21223_() <= this.m_21233_() && this.f_20919_ == 0) {
            this.m_21153_(this.m_21223_() + 1.0f);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getTypeMoC() == 8 && this.sprintCounter > 0 && this.sprintCounter < 150 && this.m_20160_() && this.f_19796_.m_188503_(15) == 0) {
                MoCTools.buckleMobs((Mob)this, 2.0, this.m_9236_());
            }
            if (this.getHiding() && ++this.hidingCounter > 500 && !this.getIsTamed()) {
                this.setHiding(false);
                this.hidingCounter = 0;
            }
            if (this.getTypeMoC() == 1 && this.f_19796_.m_188503_(200) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= 100) {
                    this.setAdult(true);
                    this.setTypeMoC(0);
                    this.selectType();
                }
            }
            if (this.getIsFertile() && this.getTypeMoC() == 2 && !this.getEggWatching() && --this.eggCounter <= 0 && this.f_19796_.m_188503_(5) == 0) {
                int ostrichEggType = 30;
                MoCEntityOstrich maleOstrich = this.getClosestMaleOstrich((Entity)this, 8.0);
                if (maleOstrich != null && this.f_19796_.m_188503_(100) < MoCreatures.proxy.ostrichEggDropChance) {
                    MoCEntityEgg entityegg = (MoCEntityEgg)((EntityType)MoCEntities.EGG.get()).m_20615_(this.m_9236_());
                    entityegg.setEggType(ostrichEggType);
                    entityegg.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.m_9236_().m_7967_((Entity)entityegg);
                    if (!this.getIsTamed()) {
                        this.setEggWatching(true);
                        maleOstrich.setEggWatching(true);
                        this.openMouth();
                    }
                    MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
                    this.eggCounter = this.f_19796_.m_188503_(2000) + 2000;
                    this.setFertile(false);
                }
            }
            if (this.getEggWatching()) {
                MoCEntityEgg myEgg = (MoCEntityEgg)this.getBoogey(8.0);
                if (myEgg != null && MoCTools.getSqDistanceTo((Entity)myEgg, this.m_20185_(), this.m_20186_(), this.m_20189_()) > 4.0) {
                    Path pathEntity = this.m_21573_().m_7864_(myEgg.m_20183_(), 0);
                    this.m_21573_().m_26536_(pathEntity, 2.0);
                }
                if (myEgg == null) {
                    this.setEggWatching(false);
                    Player eggStealer = this.m_9236_().m_45930_((Entity)this, 10.0);
                    if (eggStealer != null) {
                        this.m_9236_().m_46791_();
                        if (!this.getIsTamed() && this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                            this.m_6710_((LivingEntity)eggStealer);
                            this.flapWings();
                        }
                    }
                }
            }
        }
    }

    protected MoCEntityOstrich getClosestMaleOstrich(Entity entity, double d) {
        double d1 = -1.0;
        MoCEntityOstrich entityliving = null;
        List list = this.m_9236_().m_45976_(MoCEntityOstrich.class, entity.m_20191_().m_82400_(d));
        for (MoCEntityOstrich entity1 : list) {
            if (entity1.getTypeMoC() < 3) continue;
            double d2 = entity1.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityliving = entity1;
        }
        return entityliving;
    }

    @Override
    public boolean entitiesToInclude(Entity entity) {
        return entity instanceof MoCEntityEgg && ((MoCEntityEgg)entity).eggType == 30;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (this.getIsTamed() && stack.m_41619_() && !player.m_6144_() && this.getIsChested()) {
            if (!this.m_9236_().m_5776_()) {
                if (this.localchest == null) {
                    this.localchest = new MoCAnimalChest("OstrichChest", MoCAnimalChest.Size.tiny);
                }
                player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ChestMenu(MenuType.f_39957_, id, inventory, (Container)this.localchest, 1), (Component)Component.m_237115_((String)"container.ostrich_chest")));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (this.getIsTamed() && this.getTypeMoC() > 1 && !stack.m_41619_() && !this.getIsRideable() && (stack.m_41720_() == Items.f_42450_ || stack.m_41720_() instanceof SaddleItem)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            this.setRideable(true);
            return InteractionResult.SUCCESS;
        }
        if (!this.getIsFertile() && !stack.m_41619_() && this.getTypeMoC() == 2 && stack.m_41720_() == Items.f_42578_) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.openMouth();
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            this.setFertile(true);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && stack.m_150930_((Item)MoCItems.WHIP.get()) && this.getIsTamed() && !this.m_20160_()) {
            this.setHiding(!this.getHiding());
            this.setIsJumping(false);
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getTypeMoC() > 1 && stack.m_150930_((Item)MoCItems.ESSENCE_DARKNESS.get())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (this.getTypeMoC() == 6) {
                this.m_21153_(this.m_21233_());
            } else {
                this.transform(6);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_DRINKING.get());
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getTypeMoC() > 1 && stack.m_150930_((Item)MoCItems.ESSENCE_UNDEAD.get())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (this.getTypeMoC() == 7) {
                this.m_21153_(this.m_21233_());
            } else {
                this.transform(7);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_DRINKING.get());
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getTypeMoC() > 1 && stack.m_150930_((Item)MoCItems.ESSENCE_LIGHT.get())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (this.getTypeMoC() == 8) {
                this.m_21153_(this.m_21233_());
            } else {
                this.transform(8);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_DRINKING.get());
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getTypeMoC() > 1 && stack.m_150930_((Item)MoCItems.ESSENCE_FIRE.get())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (this.getTypeMoC() == 5) {
                this.m_21153_(this.m_21233_());
            } else {
                this.transform(5);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_DRINKING.get());
            return InteractionResult.SUCCESS;
        }
        if (this.getIsTamed() && this.getIsChested() && this.getTypeMoC() > 1 && !stack.m_41619_() && stack.m_204117_(ItemTags.f_13167_)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            this.dropFlag();
            this.setFlagColor((DyeColor)WOOL_BY_COLOR.inverse().get((Object)stack.m_41720_()));
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getTypeMoC() > 1 && this.getIsTamed() && !this.getIsChested() && stack.m_41720_() == Blocks.f_50087_.m_5456_()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && this.getIsChested()) {
            if (this.localchest == null) {
                this.localchest = new MoCAnimalChest("OstrichChest", MoCAnimalChest.Size.tiny);
            }
            if (!this.m_9236_().m_5776_()) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ChestMenu(MenuType.f_39957_, id, inventory, (Container)this.localchest, 1), (Component)Component.m_237115_((String)"container.ostrich_chest")));
            }
            return InteractionResult.SUCCESS;
        }
        if (this.getIsTamed() && this.getTypeMoC() > 1 && !stack.m_41619_() && stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40402_() == EquipmentSlot.HEAD) {
            ArmorItem itemArmor = (ArmorItem)stack.m_41720_();
            int helmetType = 0;
            if (stack.m_41720_() == Items.f_42407_) {
                helmetType = 1;
            } else if (stack.m_41720_() == Items.f_42468_) {
                helmetType = 2;
            } else if (stack.m_41720_() == Items.f_42476_) {
                helmetType = 3;
            } else if (stack.m_41720_() == Items.f_42472_) {
                helmetType = 4;
            } else if (stack.m_41720_() == MoCItems.HELMET_HIDE.get()) {
                helmetType = 5;
            } else if (stack.m_41720_() == MoCItems.HELMET_FUR.get()) {
                helmetType = 6;
            } else if (stack.m_41720_() == MoCItems.HELMET_CROC.get()) {
                helmetType = 7;
            } else if (stack.m_41720_() == MoCItems.HELMET_SCORP_D.get()) {
                helmetType = 9;
            } else if (stack.m_41720_() == MoCItems.HELMET_SCORP_F.get()) {
                helmetType = 10;
            } else if (stack.m_41720_() == MoCItems.HELMET_SCORP_C.get()) {
                helmetType = 11;
            } else if (stack.m_41720_() == MoCItems.HELMET_SCORP_N.get()) {
                helmetType = 12;
            }
            if (helmetType != 0) {
                player.m_21008_(hand, ItemStack.f_41583_);
                this.dropArmor();
                this.m_8061_(itemArmor.m_40402_(), stack);
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF.get());
                this.setHelmet(helmetType);
                return InteractionResult.SUCCESS;
            }
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.m_6144_() || this.m_20160_())) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.setHiding(false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void dropFlag() {
        if (!this.m_9236_().m_5776_() && this.getFlagColor() != null) {
            DyeColor color = this.getFlagColor();
            ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)WOOL_BY_COLOR.get((Object)color), 1));
            entityitem.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityitem);
            this.setFlagColor(null);
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void flapWings() {
        this.wingCounter = 1;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_OSTRICH_HURT.get();
    }

    protected SoundEvent m_7515_() {
        this.openMouth();
        if (this.getTypeMoC() == 1) {
            return (SoundEvent)MoCSoundEvents.ENTITY_OSTRICH_AMBIENT_BABY.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_OSTRICH_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_OSTRICH_DEATH.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.OSTRICH;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        boolean flag = this.f_19796_.m_188503_(100) < MoCreatures.proxy.rareItemDropChance;
        int i = this.f_19796_.m_188503_(3);
        if (looting > 0) {
            i += this.f_19796_.m_188503_(looting + 1);
        }
        if (flag && this.getTypeMoC() == 8) {
            this.m_19983_(new ItemStack((ItemLike)MoCItems.UNICORNHORN.get(), i));
        }
        if (this.getTypeMoC() == 5 && flag) {
            this.m_19983_(new ItemStack((ItemLike)MoCItems.HEARTFIRE.get(), i));
        }
        if (this.getTypeMoC() == 6 && flag) {
            this.m_19983_(new ItemStack((ItemLike)MoCItems.HEARTDARKNESS.get(), i));
        }
        if (this.getTypeMoC() == 7) {
            if (flag) {
                this.m_19983_(new ItemStack((ItemLike)MoCItems.HEARTUNDEAD.get(), i));
            }
            this.m_19983_(new ItemStack((ItemLike)Items.f_42583_, i));
        }
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Saddle", this.getIsRideable());
        nbttagcompound.m_128379_("EggWatch", this.getEggWatching());
        nbttagcompound.m_128379_("Hiding", this.getHiding());
        nbttagcompound.m_128405_("Helmet", this.getHelmet());
        nbttagcompound.m_128405_("FlagColor", this.getFlagColorRaw());
        nbttagcompound.m_128379_("Bagged", this.getIsChested());
        nbttagcompound.m_128379_("Fertile", this.getIsFertile());
        if (this.getIsChested() && this.localchest != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.localchest.m_6643_(); ++i) {
                this.localstack = this.localchest.m_8020_(i);
                if (this.localstack.m_41619_()) continue;
                CompoundTag nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localstack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items", (Tag)nbttaglist);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setRideable(nbttagcompound.m_128471_("Saddle"));
        this.setEggWatching(nbttagcompound.m_128471_("EggWatch"));
        this.setHiding(nbttagcompound.m_128471_("Hiding"));
        this.setHelmet(nbttagcompound.m_128451_("Helmet"));
        this.setFlagColorRaw(nbttagcompound.m_128451_("FlagColor"));
        this.setIsChested(nbttagcompound.m_128471_("Bagged"));
        this.setFertile(nbttagcompound.m_128471_("Fertile"));
        if (this.getIsChested()) {
            ListTag nbttaglist = nbttagcompound.m_128437_("Items", 10);
            this.localchest = new MoCAnimalChest("OstrichChest", MoCAnimalChest.Size.tiny);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag nbttagcompound1 = nbttaglist.m_128728_(i);
                int j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localchest.m_6643_()) continue;
                this.localchest.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
    }

    @Override
    public int nameYOffset() {
        if (this.getTypeMoC() > 1) {
            return -105;
        }
        return -5 - this.getMoCAge();
    }

    @Override
    public boolean isMyHealFood(ItemStack par1ItemStack) {
        return MoCTools.isItemEdible(par1ItemStack.m_41720_());
    }

    @Override
    public void dropMyStuff() {
        if (!this.m_9236_().m_5776_()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.m_9236_());
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localchest);
                MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)Blocks.f_50087_, 1));
                this.setIsChested(false);
            }
        }
    }

    @Override
    public void dropArmor() {
        if (!this.m_9236_().m_5776_()) {
            ItemStack itemStack = this.m_6844_(EquipmentSlot.HEAD);
            if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof ArmorItem) {
                ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack.m_41777_());
                entityitem.m_32010_(10);
                this.m_9236_().m_7967_((Entity)entityitem);
            }
            this.setHelmet(0);
        }
    }

    @Override
    public boolean isFlyer() {
        return this.m_20160_() && (this.getTypeMoC() == 5 || this.getTypeMoC() == 6);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (this.isFlyer()) {
            return false;
        }
        return super.m_142535_(distance, damageMultiplier, source);
    }

    @Override
    protected double myFallSpeed() {
        return 0.89;
    }

    @Override
    protected double flyerThrust() {
        return 0.8;
    }

    @Override
    protected float flyerFriction() {
        return 0.96f;
    }

    @Override
    protected boolean selfPropelledFlyer() {
        return this.getTypeMoC() == 6;
    }

    @Override
    public void makeEntityJump() {
        if (this.jumpCounter > 5) {
            this.jumpCounter = 1;
        }
        if (this.jumpCounter == 0) {
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_WINGFLAP.get());
            this.jumpPending = true;
            this.jumpCounter = 1;
        }
    }

    public MobType m_6336_() {
        if (this.getTypeMoC() == 7) {
            return MobType.f_21641_;
        }
        return super.m_6336_();
    }

    public int m_5792_() {
        return 1;
    }

    @Override
    public int getMoCMaxAge() {
        return 20;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.945f;
    }

    @Override
    public void setTypeMoC(int i) {
        this.isImmuneToFire = i == 5;
        super.setTypeMoC(i);
    }

    public boolean m_5825_() {
        return this.isImmuneToFire ? true : super.m_5825_();
    }

    private void updateItemReferences(ItemStack stack, EquipmentSlot slot) {
    }
}

