/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.neutral;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.inventory.MoCAnimalChest;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityWyvern
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> RIDEABLE = SynchedEntityData.m_135353_(MoCEntityWyvern.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(MoCEntityWyvern.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(MoCEntityWyvern.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GHOST = SynchedEntityData.m_135353_(MoCEntityWyvern.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(MoCEntityWyvern.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ARMOR_TYPE = SynchedEntityData.m_135353_(MoCEntityWyvern.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public MoCAnimalChest localchest;
    public ItemStack localstack;
    public int mouthCounter;
    public int wingFlapCounter;
    public int diveCounter;
    protected EntityAIWanderMoC2 wander;
    private int transformType;
    private int transformCounter;
    private int tCounter;
    private float fTransparency;
    private int xpReward = 20;

    public MoCEntityWyvern(EntityType<? extends MoCEntityWyvern> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setAdult(true);
        this.setTamed(false);
        this.m_274367_(1.0f);
        this.setMoCAge(80);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.wander = new EntityAIWanderMoC2((PathfinderMob)this, 1.0, 80);
        this.f_21345_.m_25352_(4, (Goal)this.wander);
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22284_, 14.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIDEABLE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SITTING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(FLYING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(GHOST, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ARMOR_TYPE, (Object)0);
    }

    public int m_213860_() {
        return this.xpReward;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (worldIn.m_6018_().m_46472_() == MoCreatures.proxy.wyvernDimension) {
            this.m_21530_();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean getCanSpawnHere(EntityType<MoCEntityAnimal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random randomIn) {
        BlockState iblockstate = world.m_8055_(pos.m_7495_());
        return iblockstate.m_60643_((BlockGetter)world, pos, type);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.m_9236_().m_46472_() != MoCreatures.proxy.wyvernDimension;
    }

    @Override
    public boolean getIsFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setIsFlying(boolean flag) {
        this.f_19804_.m_135381_(FLYING, (Object)flag);
    }

    @Override
    public int getArmorType() {
        return (Integer)this.f_19804_.m_135370_(ARMOR_TYPE);
    }

    @Override
    public void setArmorType(int i) {
        this.f_19804_.m_135381_(ARMOR_TYPE, (Object)i);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.f_19804_.m_135370_(RIDEABLE);
    }

    @Override
    public void setRideable(boolean flag) {
        this.f_19804_.m_135381_(RIDEABLE, (Object)flag);
    }

    public boolean getIsChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setIsChested(boolean flag) {
        this.f_19804_.m_135381_(CHESTED, (Object)flag);
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public void setSitting(boolean flag) {
        this.f_19804_.m_135381_(SITTING, (Object)flag);
    }

    @Override
    public boolean getIsGhost() {
        return (Boolean)this.f_19804_.m_135370_(GHOST);
    }

    public void setIsGhost(boolean flag) {
        this.f_19804_.m_135381_(GHOST, (Object)flag);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            if (this.f_19796_.m_188503_(5) == 0) {
                this.setTypeMoC(5);
            } else {
                int i = this.f_19796_.m_188503_(100);
                if (i <= 12) {
                    this.setTypeMoC(1);
                } else if (i <= 24) {
                    this.setTypeMoC(2);
                } else if (i <= 36) {
                    this.setTypeMoC(3);
                } else if (i <= 48) {
                    this.setTypeMoC(4);
                } else if (i <= 60) {
                    this.setTypeMoC(9);
                } else if (i <= 72) {
                    this.setTypeMoC(10);
                } else if (i <= 84) {
                    this.setTypeMoC(11);
                } else if (i <= 95) {
                    this.setTypeMoC(12);
                } else {
                    this.setTypeMoC(5);
                }
            }
        }
        if (this.m_21051_(Attributes.f_22276_) != null) {
            this.m_21051_(Attributes.f_22276_).m_22100_(this.calculateMaxHealth());
            this.m_21153_(this.m_21233_());
        }
        if (this.m_21051_(Attributes.f_22281_) != null) {
            this.m_21051_(Attributes.f_22281_).m_22100_(this.calculateAttackDmg());
        }
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    public double calculateMaxHealth() {
        if (this.getTypeMoC() == 13) {
            return 100.0;
        }
        return 80.0;
    }

    public double calculateAttackDmg() {
        if (this.getTypeMoC() == 5) {
            return 12.0;
        }
        return 10.0;
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.transformCounter != 0 && this.transformType > 5) {
            String newText = "wyvern_mother_dark.png";
            if (this.transformType == 6) {
                newText = "wyvern_mother_undead.png";
            }
            if (this.transformType == 7) {
                newText = "wyvern_mother_light.png";
            }
            if (this.transformType == 8) {
                newText = "wyvern_mother_dark.png";
            }
            if (this.transformCounter % 5 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
            if (this.transformCounter > 50 && this.transformCounter % 3 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
            if (this.transformCounter > 75 && this.transformCounter % 4 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
        }
        switch (this.getTypeMoC()) {
            case 1: {
                return MoCreatures.proxy.getModelTexture("wyvern_jungle.png");
            }
            case 2: {
                return MoCreatures.proxy.getModelTexture("wyvern_swamp.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("wyvern_sand.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("wyvern_mother.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("wyvern_mother_undead.png");
            }
            case 7: {
                return MoCreatures.proxy.getModelTexture("wyvern_mother_light.png");
            }
            case 8: {
                return MoCreatures.proxy.getModelTexture("wyvern_mother_dark.png");
            }
            case 9: {
                return MoCreatures.proxy.getModelTexture("wyvern_arctic.png");
            }
            case 10: {
                return MoCreatures.proxy.getModelTexture("wyvern_cave.png");
            }
            case 11: {
                return MoCreatures.proxy.getModelTexture("wyvern_mountain.png");
            }
            case 12: {
                return MoCreatures.proxy.getModelTexture("wyvern_sea.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("wyvern_sun.png");
    }

    public void transform(int tType) {
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), tType));
        }
        this.transformType = tType;
        this.transformCounter = 1;
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        if (this.getIsFlying() && !this.m_20159_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)this.flyerFriction()));
            this.f_19789_ = 0.0f;
        } else {
            super.m_7023_(travelVector);
        }
    }

    public float m_6113_() {
        if (this.getIsFlying()) {
            return 0.15f;
        }
        return super.m_6113_();
    }

    public void m_8107_() {
        if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
            this.wingFlapCounter = 0;
        }
        if (this.wingFlapCounter == 5 && !this.m_9236_().m_5776_()) {
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_WYVERN_WINGFLAP.get());
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 40) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_TRANSFORM.get());
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.setTypeMoC(this.transformType);
                    this.selectType();
                }
            }
        }
        if (!this.m_9236_().m_5776_()) {
            if (!this.isMovementCeased() && !this.getIsTamed() && this.f_19796_.m_188503_(300) == 0) {
                this.setIsFlying(!this.getIsFlying());
                if (this.getIsFlying() && this.m_20096_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.4, 0.0));
                }
            }
            if (this.isMovementCeased() && this.getIsFlying()) {
                this.setIsFlying(false);
            }
            if (!(this.m_5448_() == null || this.getIsTamed() && this.m_20197_().size() <= 0 || this.isMovementCeased() || this.f_19796_.m_188503_(20) != 0)) {
                this.setIsFlying(true);
                if (this.m_20096_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.4, 0.0));
                }
            }
            if (this.getIsFlying()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
                if (this.m_20184_().f_82480_ < -0.5) {
                    this.m_20334_(this.m_20184_().f_82479_, -0.5, this.m_20184_().f_82481_);
                }
                if (this.f_19862_) {
                    this.m_20256_(this.m_20184_().m_82520_(this.f_19796_.m_188583_() * 0.05, 0.0, this.f_19796_.m_188583_() * 0.05));
                }
                if (this.m_21573_().m_26571_() && this.m_5448_() == null) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
                    this.m_19920_(0.0f, new Vec3(0.0, 0.0, 0.0));
                    this.m_20242_(true);
                }
                if (!this.m_20184_().equals((Object)Vec3.f_82478_)) {
                    Vec3 motion = this.m_20184_();
                    float targetYaw = (float)(Math.atan2(motion.f_82481_, motion.f_82479_) * 57.29577951308232) - 90.0f;
                    this.m_146922_(this.updateRotation(this.m_146908_(), targetYaw, 4.0f));
                    this.f_20883_ = this.m_146908_();
                }
                if (this.f_19796_.m_188503_(20) == 0) {
                    this.wingFlap();
                }
                if (this.m_21573_().m_26571_() && this.m_5448_() == null && this.f_19796_.m_188503_(40) == 0) {
                    double liftAmount = 0.3 + this.f_19796_.m_188500_() * 0.3;
                    this.m_20256_(this.m_20184_().m_82520_(0.0, liftAmount, 0.0));
                }
                this.m_20242_(true);
            } else {
                this.m_20242_(false);
            }
            if (this.getIsFlying() && this.m_21573_().m_26571_() && !this.isMovementCeased() && this.m_5448_() == null && this.f_19796_.m_188503_(30) == 0) {
                this.wander.makeUpdate();
            }
            if (this.getIsGhost() && this.getMoCAge() > 0 && this.getMoCAge() < 10 && this.f_19796_.m_188503_(5) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() == 9) {
                    this.setMoCAge(140);
                    this.setAdult(true);
                }
            }
        } else {
            if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
                this.mouthCounter = 0;
            }
            if (this.diveCounter > 0 && ++this.diveCounter > 5) {
                this.diveCounter = 0;
            }
        }
        super.m_8107_();
    }

    @Override
    public boolean isOnAir() {
        return !this.m_20096_() && !this.m_20069_() && !this.m_20077_();
    }

    private float updateRotation(float current, float target, float maxChange) {
        float f = Mth.m_14177_((float)(target - current));
        if (f > maxChange) {
            f = maxChange;
        }
        if (f < -maxChange) {
            f = -maxChange;
        }
        return current + f;
    }

    public void wingFlap() {
        if (this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            if (!this.m_9236_().m_5776_()) {
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 3));
            }
        }
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getMoCAge() * 0.01f;
    }

    @Override
    public boolean isFlyingAlone() {
        return this.getIsFlying() && !this.m_20160_();
    }

    @Override
    public int maxFlyingHeight() {
        if (this.getIsTamed()) {
            return 5;
        }
        return 18;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (!stack.m_41619_() && item == MoCItems.WHIP.get() && this.getIsTamed() && !this.m_20160_()) {
            this.setSitting(!this.getIsSitting());
            this.setIsJumping(false);
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && !this.getIsRideable() && this.getMoCAge() > 90 && this.getIsTamed() && (item instanceof SaddleItem || item == MoCItems.HORSE_SADDLE.get())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setRideable(true);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getMoCAge() > 90 && item == Items.f_42651_) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON.get());
            }
            this.dropArmor();
            this.setArmorType(1);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getMoCAge() > 90 && item == Items.f_42652_) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON.get());
            }
            this.dropArmor();
            this.setArmorType(2);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getMoCAge() > 90 && item == Items.f_42653_) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON.get());
            }
            this.dropArmor();
            this.setArmorType(3);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.getMoCAge() > 90 && !this.getIsChested() && item == Blocks.f_50087_.m_5456_()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            return InteractionResult.SUCCESS;
        }
        if (this.getIsChested() && player.m_6144_()) {
            if (this.localchest == null) {
                this.localchest = new MoCAnimalChest("WyvernChest", MoCAnimalChest.Size.tiny);
            }
            if (!this.m_9236_().m_5776_()) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ChestMenu(MenuType.f_39957_, id, inventory, (Container)this.localchest, 1), (Component)Component.m_237115_((String)"container.wyvern_chest")));
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsGhost() && this.getIsTamed() && item == MoCItems.AMULET_GHOST.get()) {
            player.m_21008_(hand, ItemStack.f_41583_);
            if (!this.m_9236_().m_5776_()) {
                MoCPetData petData = MoCreatures.instance.mapData.getPetData(this.getOwnerId());
                if (petData != null) {
                    petData.setInAmulet(this.getOwnerPetId(), true);
                }
                this.dropMyStuff();
                MoCTools.dropAmulet(this, 3, player);
                this.m_146870_();
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && !this.getIsGhost() && item == MoCItems.ESSENCE_LIGHT.get() && this.getIsTamed() && this.getMoCAge() > 90 && this.getTypeMoC() < 5) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (!this.m_9236_().m_5776_()) {
                int i = this.getTypeMoC() + 49;
                MoCEntityEgg entityegg = (MoCEntityEgg)((EntityType)MoCEntities.EGG.get()).m_20615_(this.m_9236_());
                entityegg.setEggType(i);
                entityegg.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                this.m_9236_().m_7967_((Entity)entityegg);
                entityegg.m_20256_(entityegg.m_20184_().m_82520_((double)((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.3f), (double)(this.m_9236_().f_46441_.m_188501_() * 0.05f), (double)((this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.3f)));
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.transformCounter == 0 && !this.getIsGhost() && this.getTypeMoC() == 5 && item == MoCItems.ESSENCE_UNDEAD.get() && this.getIsTamed()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (!this.m_9236_().m_5776_()) {
                this.transform(6);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.transformCounter == 0 && !this.getIsGhost() && this.getTypeMoC() == 5 && item == MoCItems.ESSENCE_LIGHT.get() && this.getIsTamed()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (!this.m_9236_().m_5776_()) {
                this.transform(7);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.transformCounter == 0 && !this.getIsGhost() && this.getTypeMoC() == 5 && item == MoCItems.ESSENCE_DARKNESS.get() && this.getIsTamed()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (!this.m_9236_().m_5776_()) {
                this.transform(8);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(!this.getIsRideable() || this.getMoCAge() <= 90 || this.getIsChested() && player.m_6144_() || this.m_20160_())) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.setSitting(false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void dropArmor() {
        if (!this.m_9236_().m_5776_()) {
            ItemEntity entityitem;
            int i = this.getArmorType();
            if (i != 0) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF.get());
            }
            if (i == 1) {
                entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42651_, 1));
                entityitem.m_32010_(10);
                this.m_9236_().m_7967_((Entity)entityitem);
            }
            if (i == 2) {
                entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42652_, 1));
                entityitem.m_32010_(10);
                this.m_9236_().m_7967_((Entity)entityitem);
            }
            if (i == 3) {
                entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42653_, 1));
                entityitem.m_32010_(10);
                this.m_9236_().m_7967_((Entity)entityitem);
            }
            this.setArmorType(0);
        }
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_WYVERN_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_WYVERN_HURT.get();
    }

    protected SoundEvent m_7515_() {
        this.openMouth();
        return (SoundEvent)MoCSoundEvents.ENTITY_WYVERN_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.WYVERN;
    }

    public int m_8100_() {
        return 400;
    }

    @Override
    public boolean isMovementCeased() {
        return this.m_20160_() || this.getIsSitting();
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.85 * (double)this.getSizeFactor();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            double dist = (double)this.getSizeFactor() * 0.3;
            double newPosX = this.m_20185_() - dist * Math.cos(Mth.m_14177_((float)(this.m_146908_() - 90.0f)) / 57.29578f);
            double newPosZ = this.m_20189_() - dist * Math.sin(Mth.m_14177_((float)(this.m_146908_() - 90.0f)) / 57.29578f);
            moveFunction.m_20372_(passenger, newPosX, this.m_20186_() + this.m_6048_() + passenger.m_6049_(), newPosZ);
        }
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (entityIn instanceof Player && !this.shouldAttackPlayers()) {
            return false;
        }
        this.openMouth();
        if (entityIn instanceof Player && this.f_19796_.m_188503_(3) == 0) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
        }
        return super.m_7327_(entityIn);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Entity entity = damagesource.m_7639_();
        if (entity != null && this.m_20365_(entity)) {
            return false;
        }
        if (super.m_6469_(damagesource, i)) {
            if (entity != null && this.getIsTamed() && entity instanceof Player) {
                return false;
            }
            if (entity != this && super.shouldAttackPlayers()) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Saddle", this.getIsRideable());
        nbttagcompound.m_128379_("Chested", this.getIsChested());
        nbttagcompound.m_128405_("ArmorType", this.getArmorType());
        nbttagcompound.m_128379_("isSitting", this.getIsSitting());
        nbttagcompound.m_128379_("isGhost", this.getIsGhost());
        if (this.getIsChested() && this.localchest != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.localchest.m_6643_(); ++i) {
                this.localstack = this.localchest.m_8020_(i);
                if (this.localstack.m_41619_()) continue;
                CompoundTag nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localstack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items", (Tag)nbttaglist);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setRideable(nbttagcompound.m_128471_("Saddle"));
        this.setIsChested(nbttagcompound.m_128471_("Chested"));
        this.setArmorType(nbttagcompound.m_128451_("ArmorType"));
        this.setSitting(nbttagcompound.m_128471_("isSitting"));
        this.setIsGhost(nbttagcompound.m_128471_("isGhost"));
        if (this.getIsChested()) {
            ListTag nbttaglist = nbttagcompound.m_128437_("Items", 10);
            this.localchest = new MoCAnimalChest("WyvernChest", MoCAnimalChest.Size.tiny);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag nbttagcompound1 = nbttaglist.m_128728_(i);
                int j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localchest.m_6643_()) continue;
                this.localchest.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
    }

    @Override
    public int nameYOffset() {
        int yOff = this.getMoCAge() * -1;
        if (yOff < -120) {
            yOff = -120;
        }
        if (this.getIsSitting()) {
            yOff += 25;
        }
        return yOff;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() == MoCItems.RAT_RAW.get() || stack.m_41720_() == MoCItems.RAW_TURKEY.get());
    }

    private void openMouth() {
        if (!this.m_9236_().m_5776_()) {
            this.mouthCounter = 1;
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 1) {
            this.mouthCounter = 1;
        }
        if (animationType == 2) {
            this.diveCounter = 1;
        }
        if (animationType == 3) {
            this.wingFlapCounter = 1;
        }
        if (animationType > 5 && animationType < 9) {
            this.transformType = animationType;
            this.transformCounter = 1;
        }
    }

    @Override
    public void makeEntityDive() {
        if (!this.m_9236_().m_5776_()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 2));
        }
        super.makeEntityDive();
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        int chance = MoCreatures.proxy.wyvernEggDropChance;
        if (this.getTypeMoC() == 5) {
            chance = MoCreatures.proxy.motherWyvernEggDropChance;
        }
        if (this.f_19796_.m_188503_(100) < chance) {
            int wyvernEggType = this.getTypeMoC() + 49;
            ItemStack wyvernEgg = new ItemStack((ItemLike)MoCItems.MOC_EGG.get(), 1);
            wyvernEgg.m_41784_().m_128405_("EggType", wyvernEggType);
            this.m_19983_(wyvernEgg);
        }
    }

    public boolean m_5829_() {
        return !this.m_20160_();
    }

    @Override
    public void dropMyStuff() {
        if (!this.m_9236_().m_5776_()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.m_9236_());
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localchest);
                MoCTools.dropCustomItem((Entity)this, this.m_9236_(), new ItemStack((ItemLike)Blocks.f_50087_, 1));
                this.setIsChested(false);
            }
        }
    }

    @Override
    public float getAdjustedYOffset() {
        if (this.getIsSitting()) {
            return 0.4f;
        }
        return 0.0f;
    }

    @Override
    public double getCustomSpeed() {
        if (this.m_20160_()) {
            return 1.0;
        }
        return 0.8;
    }

    @Override
    public int getMoCMaxAge() {
        if (this.getTypeMoC() == 5) {
            return 180;
        }
        if (this.getTypeMoC() == 6 || this.getTypeMoC() == 7 || this.getTypeMoC() == 8) {
            return 160;
        }
        return 120;
    }

    public MobType m_6336_() {
        if (this.getTypeMoC() == 6 || this.getIsGhost()) {
            return MobType.f_21641_;
        }
        return super.m_6336_();
    }

    @Override
    public boolean isReadyToHunt() {
        return !this.isMovementCeased() && !this.m_20160_();
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return !(entity instanceof MoCEntityWyvern) && (double)entity.m_20206_() <= 1.0 && (double)entity.m_20205_() <= 1.0;
    }

    @Override
    protected double flyerThrust() {
        return 0.6;
    }

    @Override
    protected float flyerFriction() {
        if (this.getTypeMoC() == 5) {
            return 0.96f;
        }
        if (this.getTypeMoC() == 6 || this.getTypeMoC() == 7 || this.getTypeMoC() == 8 || this.getIsGhost()) {
            return 0.96f;
        }
        return 0.94f;
    }

    @Override
    public void makeEntityJump() {
        this.wingFlap();
        super.makeEntityJump();
    }

    @Override
    public boolean shouldAttackPlayers() {
        return !this.getIsTamed() && super.shouldAttackPlayers();
    }

    @Override
    public void m_6667_(DamageSource damagesource) {
        if (!this.m_9236_().m_5776_()) {
            if (this.getTypeMoC() == 6) {
                MoCTools.spawnMaggots(this.m_9236_(), (Entity)this);
            }
            if (!this.getIsGhost() && this.getIsTamed() && this.f_19796_.m_188503_(4) == 0) {
                MoCEntityWyvern entitywyvern = (MoCEntityWyvern)((EntityType)MoCEntities.WYVERN.get()).m_20615_(this.m_9236_());
                entitywyvern.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)entitywyvern);
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR.get());
                entitywyvern.setOwnerId(this.getOwnerId());
                entitywyvern.setTamed(true);
                Player player = this.m_9236_().m_45930_((Entity)this, 24.0);
                if (player != null) {
                    MoCTools.tameWithName(player, entitywyvern);
                }
                entitywyvern.setAdult(false);
                entitywyvern.setMoCAge(1);
                entitywyvern.setTypeMoC(this.getTypeMoC());
                entitywyvern.selectType();
                entitywyvern.setIsGhost(true);
            }
        }
        super.m_6667_(damagesource);
    }

    public float tFloat() {
        if (++this.tCounter > 30) {
            this.tCounter = 0;
            this.fTransparency = this.f_19796_.m_188501_() * 0.2f + 0.15f;
        }
        if (this.getMoCAge() < 10) {
            return 0.0f;
        }
        return this.fTransparency;
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return this.getIsTamed() && !this.getIsGhost();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.925f;
    }
}

