/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromEntityMoC;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MoCEntityBird
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> PRE_TAMED = SynchedEntityData.m_135353_(MoCEntityBird.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(MoCEntityBird.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float wingb;
    public float wingc;
    public float wingd;
    public float winge;
    public float wingh;
    public boolean textureSet;
    protected EntityAIWanderMoC2 wander;
    private boolean fleeing;
    private int jumpTimer;

    public MoCEntityBird(EntityType<? extends MoCEntityBird> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.f_19863_ = true;
        this.wingb = 0.0f;
        this.wingc = 0.0f;
        this.wingh = 1.0f;
        this.fleeing = false;
        this.textureSet = false;
        this.setTamed(false);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIFleeFromEntityMoC((Mob)this, entity -> !(entity instanceof MoCEntityBird) && (entity.m_20206_() > 0.4f || entity.m_20205_() > 0.4f), 6.0f, 1.0, 1.3));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFollowOwnerPlayer((Mob)this, 0.8, 2.0f, 10.0f));
        this.wander = new EntityAIWanderMoC2((PathfinderMob)this, 1.0, 80);
        this.f_21345_.m_25352_(4, (Goal)this.wander);
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(6) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 1: {
                return MoCreatures.proxy.getModelTexture("bird_white.png");
            }
            case 2: {
                return MoCreatures.proxy.getModelTexture("bird_black.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("bird_green.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("bird_yellow.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("bird_red.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("bird_blue.png");
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_), Mth.m_14107_((double)this.m_20189_()));
        try {
            String biomeName = ((ResourceKey)this.m_9236_().m_204166_(pos).m_203543_().orElseThrow()).m_135782_().m_135815_();
            if (biomeName.contains("mesa")) {
                this.setTypeMoC(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PRE_TAMED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(IS_FLYING, (Object)Boolean.FALSE);
    }

    public boolean getPreTamed() {
        return (Boolean)this.f_19804_.m_135370_(PRE_TAMED);
    }

    public void setPreTamed(boolean flag) {
        this.f_19804_.m_135381_(PRE_TAMED, (Object)flag);
    }

    @Override
    public boolean getIsFlying() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setIsFlying(boolean flag) {
        this.f_19804_.m_135381_(IS_FLYING, (Object)flag);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    private int[] FindTreeTop(int i, int j, int k) {
        int l = i - 5;
        int i1 = k - 5;
        int j1 = i + 5;
        int k1 = j + 7;
        int l1 = k + 5;
        for (int i2 = l; i2 < j1; ++i2) {
            for (int j2 = i1; j2 < l1; ++j2) {
                BlockPos pos = new BlockPos(i2, j, j2);
                BlockState blockstate = this.m_9236_().m_8055_(pos);
                if (blockstate.m_60795_() || !blockstate.toString().contains("wood")) continue;
                for (int l2 = j; l2 < k1; ++l2) {
                    BlockPos pos1 = new BlockPos(i2, l2, j2);
                    BlockState blockstate1 = this.m_9236_().m_8055_(pos1);
                    if (!blockstate1.m_60795_()) continue;
                    return new int[]{i2, l2 + 2, j2};
                }
            }
        }
        return new int[]{0, 0, 0};
    }

    private void FlyToNextEntity(Entity entity) {
        if (entity != null) {
            int i = Mth.m_14107_((double)entity.m_20185_());
            int j = Mth.m_14107_((double)entity.m_20186_());
            int k = Mth.m_14107_((double)entity.m_20189_());
            this.faceLocation(i, j, k, 30.0f);
            if (Mth.m_14107_((double)this.m_20186_()) < j) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.15, 0.0));
            }
            if (this.m_20185_() < entity.m_20185_()) {
                double d = entity.m_20185_() - this.m_20185_();
                if (d > 0.5) {
                    this.m_20256_(this.m_20184_().m_82520_(0.05, 0.0, 0.0));
                }
            } else {
                double d1 = this.m_20185_() - entity.m_20185_();
                if (d1 > 0.5) {
                    this.m_20256_(this.m_20184_().m_82492_(0.05, 0.0, 0.0));
                }
            }
            if (this.m_20189_() < entity.m_20189_()) {
                double d2 = entity.m_20189_() - this.m_20189_();
                if (d2 > 0.5) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0, 0.05));
                }
            } else {
                double d3 = this.m_20189_() - entity.m_20189_();
                if (d3 > 0.5) {
                    this.m_20256_(this.m_20184_().m_82492_(0.0, 0.0, 0.05));
                }
            }
        }
    }

    private boolean FlyToNextTree() {
        int[] ai = this.ReturnNearestWoodCoord((Entity)this, 20.0);
        int[] ai1 = this.FindTreeTop(ai[0], ai[1], ai[2]);
        if (ai1[1] != 0) {
            int i1;
            int l;
            int i = ai1[0];
            int j = ai1[1];
            int k = ai1[2];
            this.faceLocation(i, j, k, 30.0f);
            if (j - Mth.m_14107_((double)this.m_20186_()) > 2) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.15, 0.0));
            }
            if (this.m_20185_() < (double)i) {
                l = i - Mth.m_14107_((double)this.m_20185_());
                this.m_20256_(this.m_20184_().m_82520_(0.05, 0.0, 0.0));
            } else {
                l = Mth.m_14107_((double)this.m_20185_()) - i;
                this.m_20256_(this.m_20184_().m_82492_(0.05, 0.0, 0.0));
            }
            if (this.m_20189_() < (double)k) {
                i1 = k - Mth.m_14107_((double)this.m_20189_());
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0, 0.05));
            } else {
                i1 = Mth.m_14107_((double)this.m_20185_()) - k;
                this.m_20256_(this.m_20184_().m_82492_(0.0, 0.0, 0.05));
            }
            double d = l + i1;
            return d < 3.0;
        }
        return false;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12189_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12192_;
    }

    protected SoundEvent m_7515_() {
        if (this.getTypeMoC() == 1) {
            return (SoundEvent)MoCSoundEvents.ENTITY_BIRD_AMBIENT_WHITE.get();
        }
        if (this.getTypeMoC() == 2) {
            return (SoundEvent)MoCSoundEvents.ENTITY_BIRD_AMBIENT_BLACK.get();
        }
        if (this.getTypeMoC() == 3) {
            return (SoundEvent)MoCSoundEvents.ENTITY_BIRD_AMBIENT_GREEN.get();
        }
        if (this.getTypeMoC() == 4) {
            return (SoundEvent)MoCSoundEvents.ENTITY_BIRD_AMBIENT_BLUE.get();
        }
        if (this.getTypeMoC() == 5) {
            return (SoundEvent)MoCSoundEvents.ENTITY_BIRD_AMBIENT_YELLOW.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_BIRD_AMBIENT_RED.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12226_, 0.15f, 1.0f);
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.BIRD;
    }

    public double m_6048_() {
        if (this.m_20202_() instanceof Player) {
            return this.m_20202_().m_6047_() ? 0.2 : (double)0.45f;
        }
        return 0.0;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getPreTamed() && !this.getIsTamed() && stack.m_41720_() == Items.f_42404_) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                MoCTools.tameWithName(player, this);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.getIsTamed()) {
            return InteractionResult.FAIL;
        }
        if (this.m_20202_() == null) {
            if (this.m_20329_((Entity)player)) {
                this.m_146922_(player.m_146908_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        super.m_8107_();
        this.winge = this.wingb;
        this.wingd = this.wingc;
        this.wingc = (float)((double)this.wingc + (double)(this.m_20096_() ? -1 : 4) * 0.3);
        if (this.wingc < 0.0f) {
            this.wingc = 0.0f;
        }
        if (this.wingc > 1.0f) {
            this.wingc = 1.0f;
        }
        if (!this.m_20096_() && this.wingh < 1.0f) {
            this.wingh = 1.0f;
        }
        this.wingh = (float)((double)this.wingh * 0.9);
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.8, 1.0));
        }
        this.wingb += this.wingh * 2.0f;
        if (!this.m_9236_().f_46443_) {
            ItemEntity entityitem;
            if (this.isMovementCeased() && this.getIsFlying()) {
                this.setIsFlying(false);
            }
            if (this.getIsFlying() && this.m_21573_().m_26571_() && !this.isMovementCeased() && this.m_5448_() == null && this.f_19796_.m_188503_(30) == 0) {
                this.wander.makeUpdate();
            }
            if (!this.getIsFlying() && !this.getIsTamed() && this.f_19796_.m_188503_(10) == 0) {
                List list = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82400_(4.0), entity -> entity != this);
                for (Entity entity1 : list) {
                    if (!(entity1 instanceof LivingEntity) || entity1 instanceof MoCEntityBird || !(entity1.m_20205_() >= 0.4f) || !(entity1.m_20206_() >= 0.4f) || !this.m_142582_(entity1)) continue;
                    this.setIsFlying(true);
                    this.fleeing = true;
                    this.wander.makeUpdate();
                }
            }
            if (!this.isMovementCeased() && !this.getIsFlying() && this.f_19796_.m_188503_(this.getIsTamed() ? 1000 : 400) == 0) {
                this.setIsFlying(true);
                this.wander.makeUpdate();
            }
            if (this.getIsFlying() && this.f_19796_.m_188503_(200) == 0) {
                this.setIsFlying(false);
            }
            if (this.fleeing && this.f_19796_.m_188503_(50) == 0) {
                this.fleeing = false;
            }
            if (!this.fleeing && (entityitem = this.getClosestItem((Entity)this, 12.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_}))) != null) {
                this.FlyToNextEntity((Entity)entityitem);
                ItemEntity entityitem1 = this.getClosestItem((Entity)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_}));
                if (this.f_19796_.m_188503_(50) == 0 && entityitem1 != null) {
                    entityitem1.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.setPreTamed(true);
                }
            }
            if (this.f_19796_.m_188503_(10) == 0 && this.m_204029_(FluidTags.f_13131_)) {
                this.WingFlap();
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20202_() != null) {
            this.m_146922_(this.m_20202_().m_146908_());
        }
        if (this.m_20202_() != null && this.m_20202_() instanceof Player) {
            Player entityplayer = (Player)this.m_20202_();
            this.m_146922_(entityplayer.m_146908_());
            entityplayer.f_19789_ = 0.0f;
            if (entityplayer.m_20184_().f_82480_ < -0.1) {
                entityplayer.m_20256_(entityplayer.m_20184_().m_82542_(1.0, 0.6, 1.0));
            }
        }
        if (--this.jumpTimer <= 0 && this.m_20096_() && (this.m_20184_().f_82479_ > 0.05 || this.m_20184_().f_82481_ > 0.05 || this.m_20184_().f_82479_ < -0.05 || this.m_20184_().f_82481_ < -0.05)) {
            this.m_20334_(this.m_20184_().f_82479_, 0.25, this.m_20184_().f_82481_);
            float velX = Mth.m_14031_((float)(this.m_146908_() * (float)Math.PI / 180.0f));
            float velZ = Mth.m_14089_((float)(this.m_146908_() * (float)Math.PI / 180.0f));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.2f * velX), 0.0, (double)(0.2f * velZ)));
            this.jumpTimer = 15;
        }
    }

    public int[] ReturnNearestWoodCoord(Entity entity, Double double1) {
        AABB axisalignedbb = entity.m_20191_().m_82400_(double1.doubleValue());
        int i = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int j = Mth.m_14107_((double)(axisalignedbb.f_82291_ + 1.0));
        int k = Mth.m_14107_((double)axisalignedbb.f_82289_);
        int l = Mth.m_14107_((double)(axisalignedbb.f_82292_ + 1.0));
        int i1 = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int j1 = Mth.m_14107_((double)(axisalignedbb.f_82293_ + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.m_9236_().m_8055_(pos);
                    if (blockstate.m_60795_() || !blockstate.toString().contains("wood")) continue;
                    return new int[]{k1, l1, i2};
                }
            }
        }
        return new int[]{0, 0, 0};
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED) {
            super.m_142687_(reason);
            return;
        }
        if (this.m_9236_().f_46443_ || !this.getIsTamed() || !(this.m_21223_() > 0.0f)) {
            super.m_142687_(reason);
        }
    }

    private void WingFlap() {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
        if (this.f_19796_.m_188503_(30) == 0) {
            this.m_20256_(this.m_20184_().m_82520_(0.2, 0.0, 0.0));
        }
        if (this.f_19796_.m_188503_(30) == 0) {
            this.m_20256_(this.m_20184_().m_82492_(0.2, 0.0, 0.0));
        }
        if (this.f_19796_.m_188503_(30) == 0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.0, 0.2));
        }
        if (this.f_19796_.m_188503_(30) == 0) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.0, 0.2));
        }
    }

    @Override
    public int nameYOffset() {
        return -40;
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() == Items.f_42404_ || stack.m_41720_() == Items.f_42578_);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsTamed();
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    @Override
    public int maxFlyingHeight() {
        return this.getIsTamed() ? 3 : 7;
    }

    @Override
    public int minFlyingHeight() {
        return 2;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.8f;
    }
}

