/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class MoCEntityBunny
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> HAS_EATEN = SynchedEntityData.m_135353_(MoCEntityBunny.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int bunnyReproduceTickerA;
    private int bunnyReproduceTickerB;
    private int jumpTimer;

    public MoCEntityBunny(EntityType<? extends MoCEntityBunny> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setAdult(true);
        this.setTamed(false);
        this.setMoCAge(50 + this.f_19796_.m_188503_(15));
        if (this.f_19796_.m_188503_(4) == 0) {
            this.setAdult(false);
        }
        this.bunnyReproduceTickerA = this.f_19796_.m_188503_(64);
        this.bunnyReproduceTickerB = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EntityAIFollowOwnerPlayer((Mob)this, 0.8, 6.0f, 5.0f));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIPanicMoC((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFleeFromPlayer((PathfinderMob)this, 1.0, 4.0));
        this.f_21345_.m_25352_(4, (Goal)new EntityAIFollowAdult((Mob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EATEN, (Object)Boolean.FALSE);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (worldIn.m_6018_().m_46472_() == MoCreatures.proxy.wyvernDimension) {
            this.m_21530_();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.m_9236_().m_46472_() != MoCreatures.proxy.wyvernDimension;
    }

    @Override
    public boolean getHasEaten() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EATEN);
    }

    @Override
    public void setHasEaten(boolean flag) {
        this.f_19804_.m_135381_(HAS_EATEN, (Object)flag);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(5) + 1);
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20191_().f_82289_);
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos pos = new BlockPos(i, j, k);
        try {
            String biomeName = ((ResourceKey)this.m_9236_().m_204166_(pos).m_203543_().orElseThrow()).m_135782_().m_135815_();
            if (biomeName.contains("snow")) {
                this.setTypeMoC(3);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_beige.png") : MoCreatures.proxy.getModelTexture("bunny_beige_detailed.png");
            }
            case 3: {
                return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_white.png") : MoCreatures.proxy.getModelTexture("bunny_white_detailed.png");
            }
            case 4: {
                return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_black.png") : MoCreatures.proxy.getModelTexture("bunny_black_detailed.png");
            }
            case 5: {
                return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_spotted.png") : MoCreatures.proxy.getModelTexture("bunny_spotted_detailed.png");
            }
        }
        return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_golden.png") : MoCreatures.proxy.getModelTexture("bunny_golden_detailed.png");
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_RABBIT_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_RABBIT_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12297_;
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.BUNNY;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_42677_ && !this.getHasEaten()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setHasEaten(true);
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            return InteractionResult.SUCCESS;
        }
        if (this.m_20202_() == null) {
            if (this.m_20329_((Entity)player)) {
                this.m_146922_(player.m_146908_());
                if (!this.getIsTamed() && !this.m_9236_().m_5776_()) {
                    MoCTools.tameWithName(player, this);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20202_() != null) {
            this.m_146922_(this.m_20202_().m_146908_());
        }
        if (!this.m_9236_().m_5776_()) {
            if (--this.jumpTimer <= 0 && this.m_20096_() && (this.m_20184_().f_82479_ > 0.05 || this.m_20184_().f_82481_ > 0.05 || this.m_20184_().f_82479_ < -0.05 || this.m_20184_().f_82481_ < -0.05)) {
                this.m_20334_(this.m_20184_().f_82479_, 0.3, this.m_20184_().f_82481_);
                this.jumpTimer = 15;
            }
            if (this.getIsTamed() && this.getIsAdult() && this.getHasEaten() && this.m_20202_() == null) {
                if (this.bunnyReproduceTickerA < 1023) {
                    ++this.bunnyReproduceTickerA;
                } else if (this.bunnyReproduceTickerB < 127) {
                    ++this.bunnyReproduceTickerB;
                } else {
                    List list1 = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(4.0, 2.0, 4.0));
                    for (Entity entity1 : list1) {
                        MoCEntityBunny entitybunny1;
                        MoCEntityBunny entitybunny;
                        if (!(entity1 instanceof MoCEntityBunny) || entity1 == this || (entitybunny = (MoCEntityBunny)entity1).m_20202_() != null || entitybunny.bunnyReproduceTickerA < 1023 || !entitybunny.getIsAdult() || !entitybunny.getHasEaten() || (entitybunny1 = (MoCEntityBunny)((EntityType)MoCEntities.BUNNY.get()).m_20615_(this.m_9236_())) == null) continue;
                        entitybunny1.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        entitybunny1.setAdult(false);
                        int babytype = this.getTypeMoC();
                        if (this.f_19796_.m_188503_(2) == 0) {
                            babytype = entitybunny.getTypeMoC();
                        }
                        entitybunny1.setTypeMoC(babytype);
                        this.m_9236_().m_7967_((Entity)entitybunny1);
                        MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
                        this.proceed();
                        entitybunny.proceed();
                        break;
                    }
                }
            }
        }
    }

    public void proceed() {
        this.setHasEaten(false);
        this.bunnyReproduceTickerB = 0;
        this.bunnyReproduceTickerA = this.f_19796_.m_188503_(64);
    }

    @Override
    public int nameYOffset() {
        return -40;
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_41720_() == Items.f_42619_;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (this.m_6673_(damagesource)) {
            return false;
        }
        if (this.m_20202_() != null) {
            return false;
        }
        return super.m_6469_(damagesource, i);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsTamed();
    }

    public double m_6049_() {
        if (this.m_20202_() instanceof Player) {
            return this.m_20202_().m_6047_() ? 0.25 : 0.5;
        }
        return super.m_6049_();
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.2f;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.675f;
    }
}

