/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import com.google.common.collect.Sets;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.init.MoCLootTables;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class MoCEntityFilchLizard
extends MoCEntityAnimal {
    protected ItemStack[] stealItems;

    public MoCEntityFilchLizard(EntityType<? extends MoCEntityFilchLizard> type, Level worldIn) {
        super(type, worldIn);
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
        this.f_21364_ = 3;
    }

    protected void m_8099_() {
        this.stealItems = this.getStealItemsFromLootTable();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIGrabItemFromFloor((PathfinderMob)this, 1.2, Sets.newHashSet((Object[])this.stealItems), true));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIStealFromPlayer((PathfinderMob)this, 0.8, Sets.newHashSet((Object[])this.stealItems), true));
        this.f_21345_.m_25352_(4, (Goal)new AIAvoidWhenNasty((PathfinderMob)this, Player.class, 16.0f, 1.0, 1.33));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private ItemStack[] getStealItemsFromLootTable() {
        return new ItemStack[]{new ItemStack((ItemLike)Items.f_42417_), new ItemStack((ItemLike)Items.f_42416_), new ItemStack((ItemLike)Items.f_42534_), new ItemStack((ItemLike)Items.f_42415_), new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_42584_), new ItemStack((ItemLike)Items.f_42484_)};
    }

    private ItemStack getRandomSpawnItem() {
        ItemStack[] spawnItems = new ItemStack[]{new ItemStack((ItemLike)Items.f_42417_), new ItemStack((ItemLike)Items.f_42416_), new ItemStack((ItemLike)Items.f_42415_), new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_42584_)};
        return spawnItems[this.f_19796_.m_188503_(spawnItems.length)];
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("lizard_filch_sand.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("lizard_filch_sand_red.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("lizard_filch_sand_silver.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("lizard_filch.png");
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_), Mth.m_14107_((double)this.m_20189_()));
        String biomePath = ((ResourceKey)this.m_9236_().m_204166_(pos).m_203543_().orElseThrow()).m_135782_().m_135815_();
        if (biomePath.contains("desert") || biomePath.contains("sand")) {
            this.setTypeMoC(2);
        } else if (biomePath.contains("mesa") || biomePath.contains("badlands")) {
            this.setTypeMoC(3);
        } else if (this.m_9236_().m_46472_() == MoCreatures.proxy.wyvernDimension) {
            this.setTypeMoC(4);
        } else {
            this.setTypeMoC(1);
        }
        return true;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        if (!this.m_21205_().m_41619_()) {
            return super.m_6972_(poseIn).m_20390_(1.0f, 2.5f);
        }
        return super.m_6972_(poseIn);
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityAnimal.createAttributes().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (this.f_19796_.m_188503_(100 / MoCreatures.proxy.filchLizardSpawnItemChance) == 0) {
            while (this.m_21205_().m_41619_() && !this.m_9236_().f_46443_) {
                this.m_8061_(EquipmentSlot.MAINHAND, this.getRandomSpawnItem());
            }
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void dropItemStack(ItemStack itemIn, float offsetY) {
        this.m_5552_(itemIn, offsetY);
    }

    @Override
    public boolean m_6469_(DamageSource par1DamageSource, float par2) {
        ItemStack stack;
        if (par1DamageSource.m_7639_() != null) {
            this.m_6703_(par1DamageSource.m_7639_() instanceof LivingEntity ? (LivingEntity)par1DamageSource.m_7639_() : null);
        }
        if (!(stack = this.m_21205_()).m_41619_() && !this.m_9236_().f_46443_) {
            ItemStack newStack = new ItemStack((ItemLike)stack.m_41720_(), 1);
            this.dropItemStack(newStack, 1.0f);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        return super.m_6469_(par1DamageSource, par2);
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.FILCH_LIZARD;
    }

    @Nullable
    protected ResourceLocation getSpawnLootTable() {
        return MoCLootTables.FILCH_LIZARD_SPAWN;
    }

    @Nullable
    protected ResourceLocation getStealLootTable() {
        return MoCLootTables.FILCH_LIZARD_STEAL;
    }

    static class EntityAIGrabItemFromFloor
    extends Goal {
        private final PathfinderMob temptedEntity;
        private final double speed;
        private final Set<ItemStack> temptItem;
        private final boolean canGetScared;
        private double targetX;
        private double targetY;
        private double targetZ;
        private double pitch;
        private double yaw;
        private ItemEntity temptingItem;
        private boolean isRunning;
        private int stealDelay = 0;

        public EntityAIGrabItemFromFloor(PathfinderMob temptedEntityIn, double speedIn, Set<ItemStack> temptItemIn, boolean canGetScared) {
            this.temptedEntity = temptedEntityIn;
            this.speed = speedIn;
            this.temptItem = temptItemIn;
            this.canGetScared = canGetScared;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.temptedEntity.m_21188_() != null && this.canGetScared && this.stealDelay <= 0) {
                this.m_8041_();
                return false;
            }
            if (!(this.temptedEntity instanceof MoCEntityFilchLizard) || !((MoCEntityFilchLizard)this.temptedEntity).m_21205_().m_41619_()) {
                return false;
            }
            List list = this.temptedEntity.m_9236_().m_45976_(ItemEntity.class, this.temptedEntity.m_20191_().m_82377_(6.0, 4.0, 6.0));
            if (this.stealDelay > 0) {
                --this.stealDelay;
                if (this.stealDelay == 0) {
                    this.temptedEntity.m_6703_(null);
                }
                return false;
            }
            double d0 = Double.MAX_VALUE;
            ItemEntity selectedItem = null;
            for (ItemEntity itemEntity : list) {
                double d1;
                if (itemEntity == null || !this.isTempting(itemEntity.m_32055_()) || !((d1 = this.temptedEntity.m_20280_((Entity)itemEntity)) < d0)) continue;
                d0 = d1;
                selectedItem = itemEntity;
            }
            if (selectedItem == null) {
                return false;
            }
            this.temptingItem = selectedItem;
            return true;
        }

        protected boolean isTempting(ItemStack stack) {
            if (this.temptItem.isEmpty()) {
                return false;
            }
            for (ItemStack itemstack : this.temptItem) {
                if (itemstack == null || itemstack.m_41619_() || itemstack.m_41720_() != stack.m_41720_()) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.targetX = this.temptingItem.m_20185_();
            this.targetY = this.temptingItem.m_20186_();
            this.targetZ = this.temptingItem.m_20189_();
            this.isRunning = true;
        }

        public void m_8041_() {
            this.temptingItem = null;
            this.temptedEntity.m_21573_().m_26573_();
            this.isRunning = false;
            if (this.canGetScared) {
                this.stealDelay = 100;
            }
        }

        public void m_8037_() {
            this.temptedEntity.m_21563_().m_24960_((Entity)this.temptingItem, (float)(this.temptedEntity.m_8085_() + 20), (float)this.temptedEntity.m_8132_());
            if (this.temptedEntity.m_20280_((Entity)this.temptingItem) < 1.0) {
                this.temptedEntity.m_21573_().m_26573_();
                ItemStack loot = this.temptingItem.m_32055_().m_41777_();
                this.temptingItem.m_146870_();
                this.temptedEntity.m_8061_(EquipmentSlot.MAINHAND, loot);
            } else {
                this.temptedEntity.m_21573_().m_5624_((Entity)this.temptingItem, this.speed);
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    public class EntityAIStealFromPlayer
    extends Goal {
        private final PathfinderMob temptedEntity;
        private final double speed;
        private final Set<ItemStack> temptItem;
        private final boolean canGetScared;
        private double targetX;
        private double targetY;
        private double targetZ;
        private double pitch;
        private double yaw;
        private Player temptingPlayer;
        private boolean isRunning;
        private int stealDelay = 0;

        public EntityAIStealFromPlayer(PathfinderMob temptedEntityIn, double speedIn, Set<ItemStack> temptItemIn, boolean canGetScared) {
            this.temptedEntity = temptedEntityIn;
            this.speed = speedIn;
            this.temptItem = temptItemIn;
            this.canGetScared = canGetScared;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.temptedEntity.m_21188_() != null && this.canGetScared && this.stealDelay <= 0) {
                this.m_8041_();
                return false;
            }
            if (!(this.temptedEntity instanceof MoCEntityFilchLizard) || !((MoCEntityFilchLizard)this.temptedEntity).m_21205_().m_41619_()) {
                return false;
            }
            this.temptingPlayer = this.temptedEntity.m_9236_().m_45930_((Entity)this.temptedEntity, 10.0);
            if (this.stealDelay > 0) {
                --this.stealDelay;
                if (this.stealDelay == 0) {
                    this.temptedEntity.m_6703_(null);
                }
                return false;
            }
            if (this.temptingPlayer != null) {
                for (int i = 0; i < this.temptingPlayer.m_150109_().m_6643_(); ++i) {
                    ItemStack item = this.temptingPlayer.m_150109_().m_8020_(i);
                    if (item.m_41619_() || !this.isTempting(item)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isTempting(ItemStack stack) {
            if (this.temptItem.isEmpty()) {
                return false;
            }
            for (ItemStack itemstack : this.temptItem) {
                if (itemstack == null || itemstack.m_41619_() || itemstack.m_41720_() != stack.m_41720_()) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.targetX = this.temptingPlayer.m_20185_();
            this.targetY = this.temptingPlayer.m_20186_();
            this.targetZ = this.temptingPlayer.m_20189_();
            this.isRunning = true;
        }

        public void m_8041_() {
            this.temptingPlayer = null;
            this.temptedEntity.m_21573_().m_26573_();
            this.isRunning = false;
            if (this.canGetScared) {
                this.stealDelay = 100;
            }
        }

        public void m_8037_() {
            this.temptedEntity.m_21563_().m_24960_((Entity)this.temptingPlayer, (float)(this.temptedEntity.m_8085_() + 20), (float)this.temptedEntity.m_8132_());
            if (this.temptingPlayer.m_7500_()) {
                return;
            }
            if (this.temptedEntity.m_20280_((Entity)this.temptingPlayer) < 3.25) {
                this.temptedEntity.m_21573_().m_26573_();
                for (int i = 0; i < this.temptingPlayer.m_150109_().m_6643_(); ++i) {
                    ItemStack item = this.temptingPlayer.m_150109_().m_8020_(i);
                    if (item.m_41619_()) continue;
                    for (ItemStack itemstack : this.temptItem) {
                        if (itemstack == null || itemstack.m_41619_() || itemstack.m_41720_() != item.m_41720_()) continue;
                        MoCTools.playCustomSound((Entity)this.temptedEntity, SoundEvents.f_12019_);
                        ItemStack loot = item.m_41777_();
                        this.temptedEntity.m_8061_(EquipmentSlot.MAINHAND, loot);
                        item.m_41774_(1);
                        return;
                    }
                }
            } else {
                this.temptedEntity.m_21573_().m_5624_((Entity)this.temptingPlayer, this.speed);
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    static class AIAvoidWhenNasty
    extends AvoidEntityGoal<Player> {
        public AIAvoidWhenNasty(PathfinderMob theEntityIn, Class<Player> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super(theEntityIn, classToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
        }

        public boolean m_8036_() {
            return !((MoCEntityFilchLizard)this.f_25015_).m_21205_().m_41619_() && super.m_8036_();
        }
    }
}

