/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.inventory.MoCAnimalChest;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import drzhark.mocreatures.network.message.MoCMessageVanish;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityHorse
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> RIDEABLE = SynchedEntityData.m_135353_(MoCEntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(MoCEntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(MoCEntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BRED = SynchedEntityData.m_135353_(MoCEntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ARMOR_TYPE = SynchedEntityData.m_135353_(MoCEntityHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int shuffleCounter;
    public int wingFlapCounter;
    public MoCAnimalChest localChest;
    public boolean eatenPumpkin = false;
    public ItemStack localStack;
    public int mouthCounter;
    public int standCounter;
    public int tailCounter;
    public int vanishCounter;
    public int sprintCounter;
    public int transformType;
    public int transformCounter;
    protected EntityAIWanderMoC2 wander;
    private int gestationTime = 0;
    private int countEating;
    private int textCounter;
    private int fCounter;
    private float transFloat = 0.2f;
    private boolean hasReproduced;
    private int nightmareInt = 0;
    private boolean isImmuneToFire = false;

    public MoCEntityHorse(EntityType<? extends MoCEntityHorse> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setMoCAge(50);
        this.setIsChested(false);
        this.m_274367_(1.0f);
        if (!this.m_9236_().f_46443_) {
            this.setAdult(this.f_19796_.m_188503_(5) != 0);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFollowAdult((Mob)this, 1.0));
        this.wander = new EntityAIWanderMoC2((PathfinderMob)this, 1.0, 80);
        this.f_21345_.m_25352_(4, (Goal)this.wander);
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIDEABLE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SITTING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(BRED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ARMOR_TYPE, (Object)0);
    }

    @Override
    public int getArmorType() {
        return (Integer)this.f_19804_.m_135370_(ARMOR_TYPE);
    }

    @Override
    public void setArmorType(int i) {
        this.f_19804_.m_135381_(ARMOR_TYPE, (Object)i);
    }

    public boolean getIsChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setIsChested(boolean flag) {
        this.f_19804_.m_135381_(CHESTED, (Object)flag);
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public boolean getHasBred() {
        return (Boolean)this.f_19804_.m_135370_(BRED);
    }

    public void setBred(boolean flag) {
        this.f_19804_.m_135381_(BRED, (Object)flag);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.f_19804_.m_135370_(RIDEABLE);
    }

    @Override
    public void setRideable(boolean flag) {
        this.f_19804_.m_135381_(RIDEABLE, (Object)flag);
    }

    public void setSitting(boolean flag) {
        this.f_19804_.m_135381_(SITTING, (Object)flag);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Entity entity = damagesource.m_7639_();
        if (this.m_20160_() && entity == this.m_20202_()) {
            return false;
        }
        if (entity instanceof Wolf) {
            Mob entitycreature = (Mob)entity;
            entitycreature.m_6710_(null);
            return false;
        }
        if ((i -= (float)(this.getArmorType() + 2)) < 0.0f) {
            i = 0.0f;
        }
        return super.m_6469_(damagesource, i);
    }

    public boolean m_5829_() {
        return !this.m_20160_();
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_), Mth.m_14107_((double)this.m_20189_()));
        ResourceKey<Biome> currentbiome = MoCTools.biomeKind(this.m_9236_(), pos);
        try {
            if (currentbiome.m_135782_().m_135815_().contains("savanna")) {
                this.setTypeMoC(60);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public float colorFX(int sColor, int typeInt) {
        switch (typeInt) {
            case 23: 
            case 24: 
            case 25: {
                if (sColor == 1) {
                    return 0.234375f;
                }
                if (sColor == 2) {
                    return 0.69921875f;
                }
                return 0.4375f;
            }
            case 40: {
                if (sColor == 1) {
                    return 0.54296875f;
                }
                if (sColor == 2) {
                    return 0.0f;
                }
                return 0.0f;
            }
            case 48: {
                if (sColor == 1) {
                    return 0.69921875f;
                }
                if (sColor == 2) {
                    return 0.625f;
                }
                return 0.0859375f;
            }
            case 49: {
                if (sColor == 1) {
                    return 0.57421875f;
                }
                if (sColor == 2) {
                    return 0.3515625f;
                }
                return 0.76171875f;
            }
            case 51: {
                if (sColor == 1) {
                    return 0.1171875f;
                }
                if (sColor == 2) {
                    return 0.5625f;
                }
                return 0.99609375f;
            }
            case 52: {
                if (sColor == 1) {
                    return 0.99609375f;
                }
                if (sColor == 2) {
                    return 0.41015625f;
                }
                return 0.703125f;
            }
            case 53: {
                if (sColor == 1) {
                    return 0.734375f;
                }
                if (sColor == 2) {
                    return 0.9296875f;
                }
                return 0.40625f;
            }
            case 54: {
                if (sColor == 1) {
                    return 0.4296875f;
                }
                if (sColor == 2) {
                    return 0.48046875f;
                }
                return 0.54296875f;
            }
            case 55: {
                if (sColor == 1) {
                    return 0.7578125f;
                }
                if (sColor == 2) {
                    return 0.11328125f;
                }
                return 0.1328125f;
            }
            case 56: {
                if (sColor == 1) {
                    return 0.24609375f;
                }
                if (sColor == 2) {
                    return 0.17578125f;
                }
                return 0.99609375f;
            }
            case 57: {
                if (sColor == 1) {
                    return 0.26953125f;
                }
                if (sColor == 2) {
                    return 0.5703125f;
                }
                return 0.56640625f;
            }
            case 58: {
                if (sColor == 1) {
                    return 0.3515625f;
                }
                if (sColor == 2) {
                    return 0.53125f;
                }
                return 0.16796875f;
            }
            case 59: {
                if (sColor == 1) {
                    return 0.8515625f;
                }
                if (sColor == 2) {
                    return 0.15625f;
                }
                return 0.0f;
            }
        }
        if (sColor == 1) {
            return 0.99609375f;
        }
        if (sColor == 2) {
            return 0.921875f;
        }
        return 0.54296875f;
    }

    public void dissapearHorse() {
        this.m_146870_();
    }

    private void drinkingHorse() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_DRINKING.get());
    }

    @Override
    public void dropArmor() {
        ItemStack armorStack;
        if (this.m_9236_().f_46443_) {
            return;
        }
        int armorType = this.getArmorType();
        if (armorType != 0) {
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF.get());
        }
        switch (armorType) {
            case 1: {
                armorStack = new ItemStack((ItemLike)Items.f_42651_, 1);
                break;
            }
            case 2: {
                armorStack = new ItemStack((ItemLike)Items.f_42652_, 1);
                break;
            }
            case 3: {
                armorStack = new ItemStack((ItemLike)Items.f_42653_, 1);
                break;
            }
            case 4: {
                armorStack = new ItemStack((ItemLike)MoCItems.HORSEARMORCRYSTAL.get(), 1);
                break;
            }
            default: {
                return;
            }
        }
        ItemEntity entityItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), armorStack);
        entityItem.m_32010_(10);
        this.m_9236_().m_7967_((Entity)entityItem);
        this.setArmorType(0);
    }

    public void dropBags() {
        if (!this.isBagger() || !this.getIsChested() || this.m_9236_().f_46443_) {
            return;
        }
        ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Blocks.f_50087_, 1));
        double f3 = 0.05;
        entityitem.m_20334_(this.m_9236_().f_46441_.m_188583_() * f3, this.m_9236_().f_46441_.m_188583_() * f3 + 0.2, this.m_9236_().f_46441_.m_188583_() * f3);
        this.m_9236_().m_7967_((Entity)entityitem);
        this.setIsChested(false);
    }

    private void eatingHorse() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
    }

    public MoCAnimalChest.Size getInventorySize() {
        if (this.getTypeMoC() == 40) {
            return MoCAnimalChest.Size.small;
        }
        if (this.getTypeMoC() > 64) {
            return MoCAnimalChest.Size.medium;
        }
        return MoCAnimalChest.Size.tiny;
    }

    @Override
    public double getCustomJump() {
        double horseJump = 0.35;
        if (this.getTypeMoC() < 6) {
            horseJump = 0.35;
        } else if (this.getTypeMoC() > 5 && this.getTypeMoC() < 11) {
            horseJump = 0.4;
        } else if (this.getTypeMoC() > 10 && this.getTypeMoC() < 16) {
            horseJump = 0.45;
        } else if (this.getTypeMoC() > 15 && this.getTypeMoC() < 21) {
            horseJump = 0.5;
        } else if (this.getTypeMoC() > 20 && this.getTypeMoC() < 26) {
            horseJump = 0.45;
        } else if (this.getTypeMoC() > 25 && this.getTypeMoC() < 30) {
            horseJump = 0.5;
        } else if (this.getTypeMoC() >= 30 && this.getTypeMoC() < 40) {
            horseJump = 0.55;
        } else if (this.getTypeMoC() >= 40 && this.getTypeMoC() < 60) {
            horseJump = 0.6;
        } else if (this.getTypeMoC() >= 60) {
            horseJump = 0.4;
        }
        return horseJump;
    }

    @Override
    public double getCustomSpeed() {
        double horseSpeed = 0.8;
        if (this.getTypeMoC() < 6) {
            horseSpeed = 0.9;
        } else if (this.getTypeMoC() > 5 && this.getTypeMoC() < 11) {
            horseSpeed = 1.0;
        } else if (this.getTypeMoC() > 10 && this.getTypeMoC() < 16) {
            horseSpeed = 1.1;
        } else if (this.getTypeMoC() > 15 && this.getTypeMoC() < 21) {
            horseSpeed = 1.2;
        } else if (this.getTypeMoC() > 20 && this.getTypeMoC() < 26) {
            horseSpeed = 0.8;
        } else if (this.getTypeMoC() > 25 && this.getTypeMoC() < 30) {
            horseSpeed = 1.0;
        } else if (this.getTypeMoC() > 30 && this.getTypeMoC() < 40) {
            horseSpeed = 1.2;
        } else if (this.getTypeMoC() >= 40 && this.getTypeMoC() < 60) {
            horseSpeed = 1.3;
        } else if (this.getTypeMoC() == 60 || this.getTypeMoC() == 61) {
            horseSpeed = 1.1;
        } else if (this.getTypeMoC() == 65) {
            horseSpeed = 0.7;
        } else if (this.getTypeMoC() > 65) {
            horseSpeed = 0.9;
        }
        if (this.sprintCounter > 0 && this.sprintCounter < 150) {
            horseSpeed *= 1.5;
        }
        if (this.sprintCounter > 150) {
            horseSpeed *= 0.5;
        }
        return horseSpeed;
    }

    protected SoundEvent m_5592_() {
        this.openMouth();
        if (this.isUndead()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_DEATH_UNDEAD.get();
        }
        if (this.getIsGhost()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_DEATH_GHOST.get();
        }
        if (this.getTypeMoC() == 60 || this.getTypeMoC() == 61) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_ZEBRA.get();
        }
        if (this.getTypeMoC() > 64 && this.getTypeMoC() < 68) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_DEATH_DONKEY.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (!blockIn.m_60819_().m_76178_()) {
            SoundType soundtype = blockIn.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
            if (this.m_9236_().m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50125_)) {
                soundtype = Blocks.f_50125_.getSoundType(blockIn, (LevelReader)this.m_9236_(), pos, (Entity)this);
            }
            if (soundtype == SoundType.f_56736_) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    @Override
    public boolean renderName() {
        if (this.getIsGhost() && this.getMoCAge() < 10) {
            return false;
        }
        return super.renderName();
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        boolean flag = this.f_19796_.m_188503_(100) < MoCreatures.proxy.rareItemDropChance;
        Item drop = Items.f_42454_;
        if (flag && (this.getTypeMoC() == 36 || this.getTypeMoC() > 49 && this.getTypeMoC() < 60)) {
            drop = (Item)MoCItems.UNICORNHORN.get();
        }
        if (this.getTypeMoC() == 39 || this.getTypeMoC() == 40) {
            drop = Items.f_42402_;
        }
        if (this.getTypeMoC() == 38 && flag && this.m_9236_().m_6042_().f_63857_()) {
            drop = (Item)MoCItems.HEARTFIRE.get();
        }
        if (this.getTypeMoC() == 32 && flag) {
            drop = (Item)MoCItems.HEARTDARKNESS.get();
        }
        if (this.getTypeMoC() == 26) {
            drop = Items.f_42500_;
        }
        if (this.getTypeMoC() == 23 || this.getTypeMoC() == 24 || this.getTypeMoC() == 25) {
            drop = flag ? (Item)MoCItems.HEARTUNDEAD.get() : Items.f_42583_;
        }
        if (this.getTypeMoC() == 21 || this.getTypeMoC() == 22) {
            drop = Items.f_42586_;
        }
        int i = this.f_19796_.m_188503_(3);
        if (looting > 0) {
            i += this.f_19796_.m_188503_(looting + 1);
        }
        this.m_19983_(new ItemStack((ItemLike)drop, i));
    }

    public boolean getHasReproduced() {
        return this.hasReproduced;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.openMouth();
        if (this.isFlyer() && !this.m_20160_()) {
            this.wingFlap();
        } else if (this.f_19796_.m_188503_(3) == 0) {
            this.stand();
        }
        if (this.isUndead()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_UNDEAD.get();
        }
        if (this.getIsGhost()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_GHOST.get();
        }
        if (this.getTypeMoC() == 60 || this.getTypeMoC() == 61) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_ZEBRA.get();
        }
        if (this.getTypeMoC() > 64 && this.getTypeMoC() < 68) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_DONKEY.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT.get();
    }

    protected SoundEvent m_7515_() {
        this.openMouth();
        if (this.f_19796_.m_188503_(10) == 0 && !this.isMovementCeased()) {
            this.stand();
        }
        if (this.isUndead()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_AMBIENT_UNDEAD.get();
        }
        if (this.getIsGhost()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_AMBIENT_GHOST.get();
        }
        if (this.getTypeMoC() == 60 || this.getTypeMoC() == 61) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_AMBIENT_ZEBRA.get();
        }
        if (this.getTypeMoC() > 64 && this.getTypeMoC() < 68) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_DONKEY.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_AMBIENT.get();
    }

    @Override
    protected SoundEvent getAngrySound() {
        this.openMouth();
        this.stand();
        if (this.isUndead()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_ANGRY_UNDEAD.get();
        }
        if (this.getIsGhost()) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_ANGRY_GHOST.get();
        }
        if (this.getTypeMoC() == 60 || this.getTypeMoC() == 61) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_ZEBRA.get();
        }
        if (this.getTypeMoC() > 64 && this.getTypeMoC() < 68) {
            return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_HURT_DONKEY.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_HORSE_MAD.get();
    }

    public int m_8100_() {
        return 400;
    }

    public float calculateMaxHealth() {
        int maximumHealth = 30;
        if (this.getTypeMoC() < 6) {
            maximumHealth = 25;
        } else if (this.getTypeMoC() > 5 && this.getTypeMoC() < 11) {
            maximumHealth = 30;
        } else if (this.getTypeMoC() > 10 && this.getTypeMoC() < 16) {
            maximumHealth = 35;
        } else if (this.getTypeMoC() > 15 && this.getTypeMoC() < 21) {
            maximumHealth = 40;
        } else if (this.getTypeMoC() > 20 && this.getTypeMoC() < 26) {
            maximumHealth = 35;
        } else if (this.getTypeMoC() > 25 && this.getTypeMoC() < 30) {
            maximumHealth = 35;
        } else if (this.getTypeMoC() >= 30 && this.getTypeMoC() < 40) {
            maximumHealth = 50;
        } else if (this.getTypeMoC() == 40) {
            maximumHealth = 50;
        } else if (this.getTypeMoC() > 40 && this.getTypeMoC() < 60) {
            maximumHealth = 40;
        } else if (this.getTypeMoC() >= 60) {
            maximumHealth = 30;
        }
        return maximumHealth;
    }

    @Override
    public int getMaxTemper() {
        if (this.getTypeMoC() == 60) {
            return 200;
        }
        return 100;
    }

    public int getNightmareInt() {
        return this.nightmareInt;
    }

    public void setNightmareInt(int i) {
        this.nightmareInt = i;
    }

    protected float m_6121_() {
        return 0.8f;
    }

    @Override
    public ResourceLocation getTexture() {
        String tempTexture = switch (this.getTypeMoC()) {
            case 1 -> "horsewhite.png";
            case 2 -> "horsecreamy.png";
            case 3 -> "horsebrown.png";
            case 4 -> "horsedarkbrown.png";
            case 5 -> "horseblack.png";
            case 6 -> "horsebrightcreamy.png";
            case 7 -> "horsespeckled.png";
            case 8 -> "horsepalebrown.png";
            case 9 -> "horsegrey.png";
            case 11 -> "horsepinto.png";
            case 12 -> "horsebrightpinto.png";
            case 13 -> "horsepalespeckles.png";
            case 16 -> "horsespotted.png";
            case 17 -> "horsecow.png";
            case 21 -> "horseghost.png";
            case 22 -> "horseghostb.png";
            case 23 -> "horseundead.png";
            case 24 -> "horseundeadunicorn.png";
            case 25 -> "horseundeadpegasus.png";
            case 26 -> "horseskeleton.png";
            case 27 -> "horseunicornskeleton.png";
            case 28 -> "horsepegasusskeleton.png";
            case 32 -> "horsebat.png";
            case 36 -> "horseunicorn.png";
            case 38 -> "horsenightmare.png";
            case 39 -> "horsepegasus.png";
            case 40 -> "horsedarkpegasus.png";
            case 48 -> "horsefairyyellow.png";
            case 49 -> "horsefairypurple.png";
            case 50 -> "horsefairywhite.png";
            case 51 -> "horsefairyblue.png";
            case 52 -> "horsefairypink.png";
            case 53 -> "horsefairylightgreen.png";
            case 54 -> "horsefairyblack.png";
            case 55 -> "horsefairyred.png";
            case 56 -> "horsefairydarkblue.png";
            case 57 -> "horsefairycyan.png";
            case 58 -> "horsefairygreen.png";
            case 59 -> "horsefairyorange.png";
            case 60 -> "horsezebra.png";
            case 61 -> "horsezorse.png";
            case 65 -> "horsedonkey.png";
            case 66 -> "horsemule.png";
            case 67 -> "horsezonky.png";
            default -> "horsebug.png";
        };
        if ((this.isArmored() || this.isMagicHorse()) && this.getArmorType() > 0) {
            String armorTex = "";
            if (this.getArmorType() == 1) {
                armorTex = "metal.png";
            }
            if (this.getArmorType() == 2) {
                armorTex = "gold.png";
            }
            if (this.getArmorType() == 3) {
                armorTex = "diamond.png";
            }
            if (this.getArmorType() == 4) {
                armorTex = "crystaline.png";
            }
            return MoCreatures.proxy.getModelTexture(tempTexture.replace(".png", armorTex));
        }
        if (this.isUndead() && this.getTypeMoC() < 26) {
            String baseTex = "horseundead";
            int max = 79;
            if (this.getTypeMoC() == 25) {
                baseTex = "horseundeadpegasus";
            }
            if (this.getTypeMoC() == 24) {
                baseTex = "horseundeadunicorn";
                max = 69;
            }
            String iteratorTex = "1";
            if (MoCreatures.proxy.getAnimateTextures()) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    ++this.textCounter;
                }
                if (this.textCounter < 10) {
                    this.textCounter = 10;
                }
                if (this.textCounter > max) {
                    this.textCounter = 10;
                }
                iteratorTex = String.valueOf(this.textCounter);
                iteratorTex = iteratorTex.substring(0, 1);
            }
            String decayTex = String.valueOf(this.getMoCAge() / 100);
            decayTex = decayTex.substring(0, 1);
            return MoCreatures.proxy.getModelTexture(baseTex + decayTex + iteratorTex + ".png");
        }
        if (!MoCreatures.proxy.getAnimateTextures()) {
            return MoCreatures.proxy.getModelTexture(tempTexture);
        }
        if (this.isNightmare()) {
            this.f_19796_.m_188503_(1);
            ++this.textCounter;
            if (this.textCounter < 10) {
                this.textCounter = 10;
            }
            if (this.textCounter > 59) {
                this.textCounter = 10;
            }
            String NTA = "horsenightmare";
            String NTB = String.valueOf(this.textCounter);
            NTB = NTB.substring(0, 1);
            String NTC = ".png";
            return MoCreatures.proxy.getModelTexture(NTA + NTB + NTC);
        }
        if (this.transformCounter != 0 && this.transformType != 0) {
            String newText = switch (this.transformType) {
                case 24 -> "horseundeadunicorn.png";
                case 25 -> "horseundeadpegasus.png";
                case 32 -> "horsebat.png";
                case 36 -> "horseunicorn.png";
                case 38 -> "horsenightmare1.png";
                case 39 -> "horsepegasus.png";
                case 40 -> "horseblackpegasus.png";
                case 48 -> "horsefairyyellow.png";
                case 49 -> "horsefairypurple.png";
                case 50 -> "horsefairywhite.png";
                case 51 -> "horsefairyblue.png";
                case 52 -> "horsefairypink.png";
                case 53 -> "horsefairylightgreen.png";
                case 54 -> "horsefairyblack.png";
                case 55 -> "horsefairyred.png";
                case 56 -> "horsefairydarkblue.png";
                case 57 -> "horsefairycyan.png";
                case 58 -> "horsefairygreen.png";
                case 59 -> "horsefairyorange.png";
                default -> "horseundead.png";
            };
            if (this.transformCounter > 75 && this.transformCounter % 4 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
        }
        return MoCreatures.proxy.getModelTexture(tempTexture);
    }

    public byte getVanishC() {
        return (byte)this.vanishCounter;
    }

    public void setVanishC(byte i) {
        this.vanishCounter = i;
    }

    private int horseGenetics(int typeA, int typeB) {
        boolean flag = MoCreatures.proxy.easyHorseBreeding;
        if (typeA == typeB) {
            return typeA;
        }
        if (typeA == 60 && typeB < 21 || typeB == 60 && typeA < 21) {
            return 61;
        }
        if (typeA == 65 && typeB < 21 || typeB == 65 && typeA < 21) {
            return 66;
        }
        if (typeA == 60 && typeB == 65 || typeB == 60 && typeA == 65) {
            return 67;
        }
        if (typeA > 20 && typeB < 21 || typeB > 20 && typeA < 21) {
            return Math.min(typeA, typeB);
        }
        if (typeA == 36 && typeB == 39 || typeB == 36 && typeA == 39) {
            return 50;
        }
        if (typeA == 36 && typeB == 40 || typeB == 36 && typeA == 40) {
            return 54;
        }
        if (typeA > 20) {
            return this.f_19796_.m_188503_(5) + 1;
        }
        if (!flag) {
            int chanceInt = this.f_19796_.m_188503_(4) + 1;
            if (chanceInt == 1) {
                return typeA;
            }
            if (chanceInt == 2) {
                return typeB;
            }
        }
        if (typeA == 1 && typeB == 2 || typeA == 2 && typeB == 1) {
            return 6;
        }
        if (typeA == 1 && typeB == 3 || typeA == 3 && typeB == 1) {
            return 2;
        }
        if (typeA == 1 && typeB == 4 || typeA == 4 && typeB == 1) {
            return 7;
        }
        if (typeA == 1 && typeB == 5 || typeA == 5 && typeB == 1) {
            return 9;
        }
        if (typeA == 1 && typeB == 7 || typeA == 7 && typeB == 1) {
            return 12;
        }
        if (typeA == 1 && typeB == 8 || typeA == 8 && typeB == 1) {
            return 7;
        }
        if (typeA == 1 && typeB == 9 || typeA == 9 && typeB == 1) {
            return 13;
        }
        if (typeA == 1 && typeB == 11 || typeA == 11 && typeB == 1) {
            return 12;
        }
        if (typeA == 1 && typeB == 12 || typeA == 12 && typeB == 1) {
            return 13;
        }
        if (typeA == 1 && typeB == 17 || typeA == 17 && typeB == 1) {
            return 16;
        }
        if (typeA == 2 && typeB == 4 || typeA == 4 && typeB == 2) {
            return 3;
        }
        if (typeA == 2 && typeB == 5 || typeA == 5 && typeB == 2) {
            return 4;
        }
        if (typeA == 2 && typeB == 7 || typeA == 7 && typeB == 2) {
            return 8;
        }
        if (typeA == 2 && typeB == 8 || typeA == 8 && typeB == 2) {
            return 3;
        }
        if (typeA == 2 && typeB == 12 || typeA == 12 && typeB == 2) {
            return 6;
        }
        if (typeA == 2 && typeB == 16 || typeA == 16 && typeB == 2) {
            return 13;
        }
        if (typeA == 2 && typeB == 17 || typeA == 17 && typeB == 2) {
            return 12;
        }
        if (typeA == 3 && typeB == 4 || typeA == 4 && typeB == 3) {
            return 8;
        }
        if (typeA == 3 && typeB == 5 || typeA == 5 && typeB == 3) {
            return 8;
        }
        if (typeA == 3 && typeB == 6 || typeA == 6 && typeB == 3) {
            return 2;
        }
        if (typeA == 3 && typeB == 7 || typeA == 7 && typeB == 3) {
            return 11;
        }
        if (typeA == 3 && typeB == 9 || typeA == 9 && typeB == 3) {
            return 8;
        }
        if (typeA == 3 && typeB == 12 || typeA == 12 && typeB == 3) {
            return 11;
        }
        if (typeA == 3 && typeB == 16 || typeA == 16 && typeB == 3) {
            return 11;
        }
        if (typeA == 3 && typeB == 17 || typeA == 17 && typeB == 3) {
            return 11;
        }
        if (typeA == 4 && typeB == 6 || typeA == 6 && typeB == 4) {
            return 3;
        }
        if (typeA == 4 && typeB == 7 || typeA == 7 && typeB == 4) {
            return 8;
        }
        if (typeA == 4 && typeB == 9 || typeA == 9 && typeB == 4) {
            return 7;
        }
        if (typeA == 4 && typeB == 11 || typeA == 11 && typeB == 4) {
            return 7;
        }
        if (typeA == 4 && typeB == 12 || typeA == 12 && typeB == 4) {
            return 7;
        }
        if (typeA == 4 && typeB == 13 || typeA == 13 && typeB == 4) {
            return 7;
        }
        if (typeA == 4 && typeB == 16 || typeA == 16 && typeB == 4) {
            return 13;
        }
        if (typeA == 4 && typeB == 17 || typeA == 17 && typeB == 4) {
            return 5;
        }
        if (typeA == 5 && typeB == 6 || typeA == 6 && typeB == 5) {
            return 4;
        }
        if (typeA == 5 && typeB == 7 || typeA == 7 && typeB == 5) {
            return 4;
        }
        if (typeA == 5 && typeB == 8 || typeA == 8 && typeB == 5) {
            return 4;
        }
        if (typeA == 5 && typeB == 11 || typeA == 11 && typeB == 5) {
            return 17;
        }
        if (typeA == 5 && typeB == 12 || typeA == 12 && typeB == 5) {
            return 13;
        }
        if (typeA == 5 && typeB == 13 || typeA == 13 && typeB == 5) {
            return 16;
        }
        if (typeA == 5 && typeB == 16 || typeA == 16 && typeB == 5) {
            return 17;
        }
        if (typeA == 6 && typeB == 8 || typeA == 8 && typeB == 6) {
            return 2;
        }
        if (typeA == 6 && typeB == 17 || typeA == 17 && typeB == 6) {
            return 7;
        }
        if (typeA == 7 && typeB == 16 || typeA == 16 && typeB == 7) {
            return 13;
        }
        if (typeA == 8 && typeB == 11 || typeA == 11 && typeB == 8) {
            return 7;
        }
        if (typeA == 8 && typeB == 12 || typeA == 12 && typeB == 8) {
            return 7;
        }
        if (typeA == 8 && typeB == 13 || typeA == 13 && typeB == 8) {
            return 7;
        }
        if (typeA == 8 && typeB == 16 || typeA == 16 && typeB == 8) {
            return 7;
        }
        if (typeA == 8 && typeB == 17 || typeA == 17 && typeB == 8) {
            return 7;
        }
        if (typeA == 9 && typeB == 16 || typeA == 16 && typeB == 9) {
            return 13;
        }
        if (typeA == 11 && typeB == 16 || typeA == 16 && typeB == 11) {
            return 13;
        }
        if (typeA == 11 && typeB == 17 || typeA == 17 && typeB == 11) {
            return 7;
        }
        if (typeA == 12 && typeB == 16 || typeA == 16 && typeB == 12) {
            return 13;
        }
        if (typeA == 13 && typeB == 17 || typeA == 17 && typeB == 13) {
            return 9;
        }
        return typeA;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (this.getTypeMoC() == 60 && !this.getIsTamed() && this.isZebraRunning()) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!(stack.m_41619_() || this.getIsRideable() || !(stack.m_41720_() instanceof SaddleItem) && stack.m_41720_() != MoCItems.HORSE_SADDLE.get())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setRideable(true);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == Items.f_42651_ && this.isArmored()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON.get());
            }
            this.dropArmor();
            this.setArmorType(1);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == Items.f_42652_ && this.isArmored()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON.get());
            }
            this.dropArmor();
            this.setArmorType(2);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == Items.f_42653_ && this.isArmored()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON.get());
            }
            this.dropArmor();
            this.setArmorType(3);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == MoCItems.HORSEARMORCRYSTAL.get() && this.isMagicHorse()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON.get());
            }
            this.dropArmor();
            this.setArmorType(4);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == MoCItems.ESSENCE_UNDEAD.get()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (this.isUndead() || this.getIsGhost()) {
                this.m_21153_(this.m_21233_());
            }
            if (this.getTypeMoC() == 39 || this.getTypeMoC() == 32 || this.getTypeMoC() == 40) {
                this.transform(25);
            } else if (this.getTypeMoC() == 36 || this.getTypeMoC() > 47 && this.getTypeMoC() < 60) {
                this.transform(24);
            } else if (this.getTypeMoC() < 21 || this.getTypeMoC() == 60 || this.getTypeMoC() == 61) {
                this.transform(23);
            }
            this.drinkingHorse();
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == MoCItems.ESSENCE_FIRE.get()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (this.isNightmare()) {
                if (this.getIsAdult() && this.m_21223_() == this.m_21233_()) {
                    this.eatenPumpkin = true;
                }
                this.m_21153_(this.m_21233_());
            }
            if (this.getTypeMoC() == 61) {
                this.transform(38);
            }
            this.drinkingHorse();
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == MoCItems.ESSENCE_DARKNESS.get()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (this.getTypeMoC() == 32) {
                if (this.getIsAdult() && this.m_21223_() == this.m_21233_()) {
                    this.eatenPumpkin = true;
                }
                this.m_21153_(this.m_21233_());
            }
            if (this.getTypeMoC() == 61) {
                this.transform(32);
            }
            if (this.getTypeMoC() == 39) {
                this.transform(40);
            }
            this.drinkingHorse();
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == MoCItems.ESSENCE_LIGHT.get()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            }
            if (this.isMagicHorse()) {
                if (this.getIsAdult() && this.m_21223_() == this.m_21233_()) {
                    this.eatenPumpkin = true;
                }
                this.m_21153_(this.m_21233_());
            }
            if (this.isNightmare()) {
                this.transform(36);
            }
            if (this.getTypeMoC() == 32 && this.m_20186_() > 128.0) {
                this.transform(39);
            }
            if (this.isUndead() && this.getIsAdult() && !this.m_9236_().f_46443_) {
                this.setMoCAge(10);
                if (this.getTypeMoC() >= 26) {
                    this.setTypeMoC(this.getTypeMoC() - 3);
                }
            }
            this.drinkingHorse();
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.isAmuletHorse() && this.getIsTamed()) {
            if ((this.getTypeMoC() == 26 || this.getTypeMoC() == 27 || this.getTypeMoC() == 28) && stack.m_41720_() == MoCItems.AMULET_BONE.get()) {
                player.m_21008_(hand, ItemStack.f_41583_);
                this.vanishHorse();
                return InteractionResult.SUCCESS;
            }
            if (this.getTypeMoC() > 47 && this.getTypeMoC() < 60 && stack.m_41720_() == MoCItems.AMULET_FAIRY.get()) {
                player.m_21008_(hand, ItemStack.f_41583_);
                this.vanishHorse();
                return InteractionResult.SUCCESS;
            }
            if ((this.getTypeMoC() == 39 || this.getTypeMoC() == 40) && stack.m_41720_() == MoCItems.AMULET_PEGASUS.get()) {
                player.m_21008_(hand, ItemStack.f_41583_);
                this.vanishHorse();
                return InteractionResult.SUCCESS;
            }
            if ((this.getTypeMoC() == 21 || this.getTypeMoC() == 22) && stack.m_41720_() == MoCItems.AMULET_GHOST.get()) {
                player.m_21008_(hand, ItemStack.f_41583_);
                this.vanishHorse();
                return InteractionResult.SUCCESS;
            }
        }
        if (!stack.m_41619_() && stack.m_41720_() instanceof DyeItem && this.getTypeMoC() == 50) {
            int colorInt = ((DyeItem)stack.m_41720_()).m_41089_().m_41060_();
            switch (colorInt) {
                case 1: {
                    this.transform(59);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.transform(51);
                    break;
                }
                case 4: {
                    this.transform(48);
                    break;
                }
                case 5: {
                    this.transform(53);
                    break;
                }
                case 6: {
                    this.transform(52);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    this.transform(57);
                    break;
                }
                case 10: {
                    this.transform(49);
                    break;
                }
                case 11: {
                    this.transform(56);
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    this.transform(58);
                    break;
                }
                case 14: {
                    this.transform(55);
                    break;
                }
                case 15: {
                    this.transform(54);
                }
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.eatingHorse();
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getTypeMoC() == 60 && stack.m_41720_() instanceof RecordItem && MoCreatures.proxy.easterEggs) {
            player.m_21008_(hand, ItemStack.f_41583_);
            if (!this.m_9236_().f_46443_) {
                ItemEntity entityitem1 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)MoCItems.RECORD_SHUFFLE.get(), 1));
                entityitem1.m_32010_(20);
                this.m_9236_().m_7967_((Entity)entityitem1);
            }
            this.eatingHorse();
            return InteractionResult.SUCCESS;
        }
        if (!(stack.m_41619_() || stack.m_41720_() != Items.f_42405_ || this.isMagicHorse() || this.isUndead())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                this.setTemper(this.getTemper() + 25);
                if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 5);
                }
            }
            if (this.m_21223_() + 5.0f > this.m_21233_()) {
                this.m_21153_(this.m_21233_());
            }
            this.eatingHorse();
            if (!this.getIsAdult() && this.getMoCAge() < this.getMoCMaxAge()) {
                this.setMoCAge(this.getMoCAge() + 1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(stack.m_41619_() || stack.m_41720_() != MoCItems.SUGAR_LUMP.get() || this.isMagicHorse() || this.isUndead())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                this.setTemper(this.getTemper() + 25);
                if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 5);
                }
            }
            if (this.m_21223_() + 10.0f > this.m_21233_()) {
                this.m_21153_(this.m_21233_());
            }
            this.eatingHorse();
            if (!this.getIsAdult() && this.getMoCAge() < this.getMoCMaxAge()) {
                this.setMoCAge(this.getMoCAge() + 2);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(stack.m_41619_() || stack.m_41720_() != Items.f_42406_ || this.isMagicHorse() || this.isUndead())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                this.setTemper(this.getTemper() + 100);
                if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 5);
                }
            }
            if (this.m_21223_() + 20.0f > this.m_21233_()) {
                this.m_21153_(this.m_21233_());
            }
            this.eatingHorse();
            if (!this.getIsAdult() && this.getMoCAge() < this.getMoCMaxAge()) {
                this.setMoCAge(this.getMoCAge() + 3);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(stack.m_41619_() || stack.m_41720_() != Items.f_42410_ && stack.m_41720_() != Items.f_42436_ || this.isMagicHorse() || this.isUndead())) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                MoCTools.tameWithName(player, this);
            }
            this.m_21153_(this.m_21233_());
            this.eatingHorse();
            if (!this.getIsAdult() && this.getMoCAge() < this.getMoCMaxAge() && !this.m_9236_().f_46443_) {
                this.setMoCAge(this.getMoCAge() + 1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == Item.m_41439_((Block)Blocks.f_50087_) && this.isBagger()) {
            if (this.getIsChested()) {
                return InteractionResult.FAIL;
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_41720_() == MoCItems.HAYSTACK.get()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setSitting(true);
            this.eatingHorse();
            if (!this.isMagicHorse() && !this.isUndead()) {
                this.m_21153_(this.m_21233_());
            }
            return InteractionResult.SUCCESS;
        }
        if (this.getIsChested() && player.m_6144_()) {
            if (this.localChest == null) {
                this.localChest = new MoCAnimalChest("HorseChest", this.getInventorySize());
            }
            if (!this.m_9236_().f_46443_) {
                MoCAnimalChest.Size chestSize = this.localChest.getSize();
                player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> {
                    switch (chestSize) {
                        case tiny: {
                            return new ChestMenu(MenuType.f_39957_, id, inventory, (Container)this.localChest, 1);
                        }
                        case small: {
                            return new ChestMenu(MenuType.f_39958_, id, inventory, (Container)this.localChest, 2);
                        }
                        case medium: {
                            return new ChestMenu(MenuType.f_39959_, id, inventory, (Container)this.localChest, 3);
                        }
                        case large: {
                            return new ChestMenu(MenuType.f_39960_, id, inventory, (Container)this.localChest, 4);
                        }
                        case huge: {
                            return new ChestMenu(MenuType.f_39961_, id, inventory, (Container)this.localChest, 5);
                        }
                        case gigantic: {
                            return new ChestMenu(MenuType.f_39962_, id, inventory, (Container)this.localChest, 6);
                        }
                    }
                    return new ChestMenu(MenuType.f_39959_, id, inventory, (Container)this.localChest, 3);
                }, (Component)Component.m_237115_((String)"container.horse_chest")));
            }
            return InteractionResult.SUCCESS;
        }
        if (!(stack.m_41619_() || stack.m_41720_() != Item.m_41439_((Block)Blocks.f_50143_) && stack.m_41720_() != Items.f_42400_ && stack.m_41720_() != Items.f_42502_ && stack.m_41720_() != Items.f_42677_)) {
            if (!this.getIsAdult() || this.isMagicHorse() || this.isUndead()) {
                return InteractionResult.FAIL;
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (stack.m_41720_() == Items.f_42400_) {
                if (stack.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42399_));
                } else {
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42399_));
                }
            } else if (stack.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            this.eatenPumpkin = true;
            this.m_21153_(this.m_21233_());
            this.eatingHorse();
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && stack.m_41720_() == MoCItems.WHIP.get() && this.getIsTamed() && !this.m_20160_()) {
            this.setSitting(!this.getIsSitting());
            this.setIsJumping(false);
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (this.getIsRideable() && this.getIsAdult() && !this.m_20160_()) {
            if (!this.m_9236_().f_46443_ && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                this.setSitting(false);
                this.gestationTime = 0;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean isAmuletHorse() {
        return this.getTypeMoC() == 21 || this.getTypeMoC() == 22 || this.getTypeMoC() == 26 || this.getTypeMoC() == 27 || this.getTypeMoC() == 28 || this.getTypeMoC() == 39 || this.getTypeMoC() == 40 || this.getTypeMoC() > 47 && this.getTypeMoC() < 60;
    }

    public boolean isArmored() {
        return this.getTypeMoC() < 21;
    }

    public boolean isBagger() {
        return this.getTypeMoC() == 66 || this.getTypeMoC() == 65 || this.getTypeMoC() == 67 || this.getTypeMoC() == 39 || this.getTypeMoC() == 40 || this.getTypeMoC() == 25 || this.getTypeMoC() == 28 || this.getTypeMoC() > 44 && this.getTypeMoC() < 60;
    }

    public boolean isFloater() {
        return this.getTypeMoC() == 36 || this.getTypeMoC() == 27 || this.getTypeMoC() == 24 || this.getTypeMoC() == 22;
    }

    @Override
    public boolean isFlyer() {
        return this.getTypeMoC() == 39 || this.getTypeMoC() == 40 || this.getTypeMoC() > 44 && this.getTypeMoC() < 60 || this.getTypeMoC() == 32 || this.getTypeMoC() == 21 || this.getTypeMoC() == 25 || this.getTypeMoC() == 28;
    }

    @Override
    public boolean getIsGhost() {
        return this.getTypeMoC() == 21 || this.getTypeMoC() == 22;
    }

    public boolean isMagicHorse() {
        return this.getTypeMoC() == 39 || this.getTypeMoC() == 36 || this.getTypeMoC() == 32 || this.getTypeMoC() == 40 || this.getTypeMoC() > 44 && this.getTypeMoC() < 60 || this.getTypeMoC() == 21 || this.getTypeMoC() == 22;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting() || this.m_20160_() || this.standCounter != 0 || this.shuffleCounter != 0 || this.getVanishC() != 0;
    }

    public boolean isNightmare() {
        return this.getTypeMoC() == 38;
    }

    public boolean isPureBreed() {
        return this.getTypeMoC() > 10 && this.getTypeMoC() < 21;
    }

    public boolean isUndead() {
        return this.getTypeMoC() > 22 && this.getTypeMoC() < 29;
    }

    public boolean isUnicorned() {
        return this.getTypeMoC() == 36 || this.getTypeMoC() >= 45 && this.getTypeMoC() < 60 || this.getTypeMoC() == 27 || this.getTypeMoC() == 24;
    }

    public boolean isZebraRunning() {
        boolean flag = false;
        Player ep1 = this.m_9236_().m_45930_((Entity)this, 8.0);
        if (ep1 != null) {
            MoCEntityHorse playerHorse;
            flag = true;
            if (ep1.m_20202_() instanceof MoCEntityHorse && ((playerHorse = (MoCEntityHorse)ep1.m_20202_()).getTypeMoC() == 16 || playerHorse.getTypeMoC() == 17 || playerHorse.getTypeMoC() == 60 || playerHorse.getTypeMoC() == 61)) {
                flag = false;
            }
        }
        if (flag) {
            MoCTools.runLikeHell((Mob)this, (Entity)ep1);
        }
        return flag;
    }

    public void LavaFX() {
        MoCreatures.proxy.LavaFX((Entity)this);
    }

    public void MaterializeFX() {
        MoCreatures.proxy.MaterializeFX(this);
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult()) {
            return -80;
        }
        return -5 - this.getMoCAge();
    }

    private boolean nearMusicBox() {
        if (this.m_9236_().f_46443_ || !MoCreatures.proxy.easterEggs) {
            return false;
        }
        boolean flag = false;
        JukeboxBlockEntity jukebox = MoCTools.nearJukeBoxRecord((Entity)this, 6.0);
        if (jukebox != null) {
            ItemStack recordStack = jukebox.m_272036_();
            Item shuffleRecord = (Item)MoCItems.RECORD_SHUFFLE.get();
            if (recordStack.m_41720_() == shuffleRecord) {
                flag = true;
                if (this.shuffleCounter > 1000) {
                    this.shuffleCounter = 0;
                    MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 102));
                    flag = false;
                }
            }
        }
        return flag;
    }

    public void nightmareEffect() {
        if (!MoCTools.mobGriefing(this.m_9236_())) {
            this.setNightmareInt(this.getNightmareInt() - 1);
            return;
        }
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20191_().f_82289_);
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos pos = new BlockPos(i, j, k);
        BlockState blockstate = this.m_9236_().m_8055_(pos.m_7918_(-1, 0, -1));
        BlockEvent.BreakEvent event = null;
        if (!this.m_9236_().f_46443_) {
            try {
                event = new BlockEvent.BreakEvent(this.m_9236_(), pos, blockstate, (Player)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.m_9236_())));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (event != null && !event.isCanceled()) {
            this.m_9236_().m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
            Player player = (Player)this.m_20202_();
            if (player != null && player.m_6060_()) {
                player.m_20095_();
            }
            this.setNightmareInt(this.getNightmareInt() - 1);
        }
    }

    @Override
    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
        if (!this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188503_(10) == 0 && this.getTypeMoC() == 23 || this.getTypeMoC() == 24 || this.getTypeMoC() == 25) {
                MoCTools.spawnMaggots(this.m_9236_(), (Entity)this);
            }
            if (this.getIsTamed() && (this.isMagicHorse() || this.isPureBreed()) && !this.getIsGhost() && this.f_19796_.m_188503_(4) == 0) {
                MoCEntityHorse entityhorse1 = (MoCEntityHorse)((EntityType)MoCEntities.WILDHORSE.get()).m_20615_(this.m_9236_());
                entityhorse1.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)entityhorse1);
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR.get());
                entityhorse1.setOwnerId(this.getOwnerId());
                entityhorse1.setTamed(true);
                Player player = this.m_9236_().m_45930_((Entity)this, 24.0);
                if (player != null) {
                    MoCTools.tameWithName(player, entityhorse1);
                }
                entityhorse1.setAdult(false);
                entityhorse1.setMoCAge(1);
                int l = 22;
                if (this.isFlyer()) {
                    l = 21;
                }
                entityhorse1.setTypeMoC(l);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.shuffleCounter > 0) {
            ++this.shuffleCounter;
            if (this.m_9236_().m_5776_() && this.shuffleCounter % 20 == 0) {
                double var2 = this.f_19796_.m_188583_() * 0.5;
                double var4 = this.f_19796_.m_188583_() * -0.1;
                double var6 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), var2, var4, var6);
            }
            if (!this.m_9236_().m_5776_() && !this.nearMusicBox()) {
                this.shuffleCounter = 0;
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 102));
            }
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.getVanishC() > 0) {
            this.setVanishC((byte)(this.getVanishC() + 1));
            if (this.getVanishC() < 15 && this.m_9236_().m_5776_()) {
                this.VanishFX();
            }
            if (this.getVanishC() > 100) {
                this.setVanishC((byte)101);
                MoCTools.dropHorseAmulet(this);
                this.dissapearHorse();
            }
            if (this.getVanishC() == 1) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_VANISH.get());
            }
            if (this.getVanishC() == 70) {
                this.stand();
            }
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter < 150 && this.sprintCounter % 2 == 0 && this.m_9236_().m_5776_()) {
                this.StarFX();
            }
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 40) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_TRANSFORM.get());
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.dropArmor();
                    this.setTypeMoC(this.transformType);
                }
            }
        }
        if (this.getIsGhost() && this.getMoCAge() < 10 && this.f_19796_.m_188503_(7) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
        }
        if (this.getIsGhost() && this.getMoCAge() == 9) {
            this.setMoCAge(100);
            this.setAdult(true);
        }
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0 && (this.isFlyer() || this.isFloater())) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_19796_.m_188503_(200) == 0) {
            this.moveTail();
        }
        if (this.getTypeMoC() == 38 && this.f_19796_.m_188503_(50) == 0 && this.m_9236_().m_5776_()) {
            this.LavaFX();
        }
        if (this.getTypeMoC() == 36 && this.isOnAir() && this.m_9236_().m_5776_()) {
            this.StarFX();
        }
        if (!this.m_9236_().m_5776_() && this.isFlyer() && this.isOnAir()) {
            float myFlyingSpeed = MoCTools.getMyMovementSpeed((Entity)this);
            int wingFlapFreq = (int)(25.0f - myFlyingSpeed * 10.0f);
            if (!this.m_20160_() || wingFlapFreq < 5) {
                wingFlapFreq = 5;
            }
            if (this.f_19796_.m_188503_(wingFlapFreq) == 0) {
                this.wingFlap();
            }
        }
        if (this.isFlyer()) {
            if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
                this.wingFlapCounter = 0;
            }
            if (this.wingFlapCounter != 0 && this.wingFlapCounter % 5 == 0 && this.m_9236_().m_5776_()) {
                this.StarFX();
            }
            if (this.wingFlapCounter == 5 && !this.m_9236_().m_5776_()) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_WINGFLAP.get());
            }
        }
        if (this.isUndead() && this.getTypeMoC() < 26 && this.getIsAdult() && this.f_19796_.m_188503_(20) == 0) {
            if (!this.m_9236_().m_5776_()) {
                if (this.f_19796_.m_188503_(16) == 0) {
                    this.setMoCAge(this.getMoCAge() + 1);
                }
                if (this.getMoCAge() >= 399) {
                    this.setTypeMoC(this.getTypeMoC() + 3);
                }
            } else {
                this.UndeadFX();
            }
        }
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            if (this.getTypeMoC() == 60 && this.getIsTamed() && this.f_19796_.m_188503_(50) == 0 && this.nearMusicBox() && this.shuffleCounter == 0) {
                this.shuffleCounter = 1;
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 101));
            }
            if (this.f_19796_.m_188503_(300) == 0 && this.f_20919_ == 0) {
                this.m_21153_(this.m_21223_() + 1.0f);
                if (this.m_21223_() > this.m_21233_()) {
                    this.m_21153_(this.m_21233_());
                }
            }
            if (!this.getIsSitting() && !this.getIsTamed() && this.f_19796_.m_188503_(300) == 0) {
                this.setSitting(true);
            }
            if (this.getIsSitting() && ++this.countEating > 50 && !this.getIsTamed()) {
                this.countEating = 0;
                this.setSitting(false);
            }
            if (this.getTypeMoC() == 38 && this.m_20160_() && this.getNightmareInt() > 0 && this.f_19796_.m_188503_(2) == 0) {
                this.nightmareEffect();
            }
            if (this.sprintCounter > 0 && this.sprintCounter < 150 && this.isUnicorned() && this.m_20160_()) {
                MoCTools.buckleMobs((Mob)this, 2.0, this.m_9236_());
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_HORSE_MAD.get());
            }
            if (this.isFlyer() && !this.getIsTamed() && this.f_19796_.m_188503_(100) == 0 && !this.isMovementCeased() && !this.getIsSitting()) {
                this.wingFlap();
            }
            if (!this.readyForParenting(this)) {
                return;
            }
            int i = 0;
            List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(8.0, 3.0, 8.0), entity -> entity != this && (entity instanceof MoCEntityHorse || entity instanceof AbstractHorse));
            i = list.size();
            if (i > 1) {
                return;
            }
            List list1 = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(4.0, 2.0, 4.0), entity -> entity != this && (entity instanceof MoCEntityHorse || entity instanceof AbstractHorse));
            for (Entity horsemate : list1) {
                int l;
                int horsemateType;
                boolean flag = horsemate instanceof AbstractHorse;
                if (!(horsemate instanceof MoCEntityHorse) && !flag || horsemate == this) continue;
                if (!flag && !this.readyForParenting((MoCEntityHorse)horsemate)) {
                    return;
                }
                ++this.gestationTime;
                if (this.gestationTime % 3 == 0) {
                    MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageHeart(this.m_19879_()));
                }
                if (this.gestationTime <= 300) continue;
                MoCEntityHorse baby = (MoCEntityHorse)((EntityType)MoCEntities.WILDHORSE.get()).m_20615_(this.m_9236_());
                baby.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)baby);
                MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
                this.eatenPumpkin = false;
                this.gestationTime = 0;
                if (flag) {
                    horsemateType = this.translateVanillaHorseType((AbstractHorse)horsemate);
                    if (horsemateType == -1) {
                        return;
                    }
                } else {
                    horsemateType = ((MoCEntityHorse)horsemate).getTypeMoC();
                    ((MoCEntityHorse)horsemate).eatenPumpkin = false;
                    ((MoCEntityHorse)horsemate).gestationTime = 0;
                }
                if ((l = this.horseGenetics(this.getTypeMoC(), horsemateType)) == 50 || l == 54) {
                    MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR.get());
                    if (!flag) {
                        ((MoCEntityHorse)horsemate).dissapearHorse();
                    }
                    this.dissapearHorse();
                }
                baby.setOwnerId(this.getOwnerId());
                baby.setTamed(true);
                baby.setAdult(false);
                UUID ownerId = this.getOwnerId();
                ServerPlayer entityplayer = null;
                if (ownerId != null && this.m_9236_() instanceof ServerLevel) {
                    entityplayer = ((ServerLevel)this.m_9236_()).m_7654_().m_6846_().m_11259_(this.getOwnerId());
                }
                if (entityplayer != null) {
                    MoCTools.tameWithName(entityplayer, baby);
                }
                baby.setTypeMoC(l);
                break;
            }
        }
    }

    private int translateVanillaHorseType(AbstractHorse horse) {
        if (horse instanceof Donkey) {
            return 65;
        }
        if (horse instanceof Horse) {
            int markingsId = 0;
            try {
                Horse horseEntity = (Horse)horse;
                markingsId = horseEntity.m_28554_().ordinal();
            }
            catch (Exception e) {
                return 3;
            }
            switch (markingsId) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 9;
                }
                case 6: {
                    return 4;
                }
            }
            return 3;
        }
        return -1;
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    public boolean readyForParenting(MoCEntityHorse entityhorse) {
        int i = entityhorse.getTypeMoC();
        return !entityhorse.m_20160_() && !entityhorse.m_20159_() && entityhorse.getIsTamed() && entityhorse.eatenPumpkin && entityhorse.getIsAdult() && !entityhorse.isUndead() && !entityhorse.getIsGhost() && i != 61 && i < 66;
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getTypeMoC() == 0) {
            int j;
            if (this.f_19796_.m_188503_(5) == 0) {
                this.setAdult(false);
            }
            if ((j = this.f_19796_.m_188503_(100)) <= 33) {
                this.setTypeMoC(6);
            } else if (j <= 66) {
                this.setTypeMoC(7);
            } else if (j <= 99) {
                this.setTypeMoC(8);
            } else {
                this.setTypeMoC(60);
            }
        }
    }

    public void setReproduced(boolean var1) {
        this.hasReproduced = var1;
    }

    private void stand() {
        if (!this.m_20160_() && !this.isOnAir()) {
            this.standCounter = 1;
        }
    }

    public void StarFX() {
        MoCreatures.proxy.StarFX(this);
    }

    public float tFloat() {
        if (++this.fCounter > 60) {
            this.fCounter = 0;
            this.transFloat = this.f_19796_.m_188501_() * 0.3f + 0.3f;
        }
        if (this.getIsGhost() && this.getMoCAge() < 10) {
            this.transFloat = 0.0f;
        }
        return this.transFloat;
    }

    public void transform(int tType) {
        if (!this.m_9236_().f_46443_) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), tType));
        }
        this.transformType = tType;
        if (!this.m_20160_() && this.transformType != 0) {
            this.dropArmor();
            this.transformCounter = 1;
        }
    }

    public void UndeadFX() {
        MoCreatures.proxy.UndeadFX((Entity)this);
    }

    public void VanishFX() {
        MoCreatures.proxy.VanishFX(this);
    }

    public void vanishHorse() {
        this.m_21573_().m_26573_();
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        if (this.isBagger()) {
            MoCTools.dropInventory((Entity)this, this.localChest);
            this.dropBags();
        }
        if (!this.m_9236_().f_46443_) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageVanish(this.m_19879_()));
            this.setVanishC((byte)1);
        }
        MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_VANISH.get());
    }

    @Override
    public void dropMyStuff() {
        this.dropArmor();
        MoCTools.dropSaddle(this, this.m_9236_());
        if (this.isBagger()) {
            MoCTools.dropInventory((Entity)this, this.localChest);
            this.dropBags();
        }
    }

    public void wingFlap() {
        if (this.isFlyer() && this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            if (!this.m_9236_().f_46443_) {
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 3));
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Saddle", this.getIsRideable());
        nbttagcompound.m_128379_("EatingHaystack", this.getIsSitting());
        nbttagcompound.m_128379_("ChestedHorse", this.getIsChested());
        nbttagcompound.m_128379_("HasReproduced", this.getHasReproduced());
        nbttagcompound.m_128379_("Bred", this.getHasBred());
        nbttagcompound.m_128405_("ArmorType", this.getArmorType());
        if (this.getIsChested() && this.localChest != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.localChest.m_6643_(); ++i) {
                this.localStack = this.localChest.m_8020_(i);
                if (this.localStack.m_41619_()) continue;
                CompoundTag nbttagcompound1 = new CompoundTag();
                nbttagcompound1.m_128344_("Slot", (byte)i);
                this.localStack.m_41739_(nbttagcompound1);
                nbttaglist.add((Object)nbttagcompound1);
            }
            nbttagcompound.m_128365_("Items", (Tag)nbttaglist);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setRideable(nbttagcompound.m_128471_("Saddle"));
        this.setSitting(nbttagcompound.m_128471_("EatingHaystack"));
        this.setBred(nbttagcompound.m_128471_("Bred"));
        this.setIsChested(nbttagcompound.m_128471_("ChestedHorse"));
        this.setReproduced(nbttagcompound.m_128471_("HasReproduced"));
        this.setArmorType(nbttagcompound.m_128451_("ArmorType"));
        if (this.getIsChested()) {
            ListTag nbttaglist = nbttagcompound.m_128437_("Items", 10);
            this.localChest = new MoCAnimalChest("HorseChest", this.getInventorySize());
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag nbttagcompound1 = nbttaglist.m_128728_(i);
                int j = nbttagcompound1.m_128445_("Slot") & 0xFF;
                if (j >= this.localChest.m_6643_()) continue;
                this.localChest.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound1));
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType >= 23 && animationType < 60) {
            this.transformType = animationType;
            this.transformCounter = 1;
        }
        if (animationType == 3) {
            this.wingFlapCounter = 1;
        }
        if (animationType == 101) {
            this.shuffleCounter = 1;
        }
        if (animationType == 102) {
            this.shuffleCounter = 0;
        }
    }

    public MobType m_6336_() {
        if (this.isUndead()) {
            return MobType.f_21641_;
        }
        return super.m_6336_();
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return this.getIsTamed() && !this.isAmuletHorse();
    }

    @Override
    public void setTypeMoC(int i) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.calculateMaxHealth());
        this.m_21153_(this.m_21233_());
        this.isImmuneToFire = i == 38 || i == 40;
        super.setTypeMoC(i);
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        double dist = (double)this.getSizeFactor() * 0.25;
        double newPosX = this.m_20185_() + dist * Math.sin(this.f_20883_ / 57.29578f);
        double newPosZ = this.m_20189_() - dist * Math.cos(this.f_20883_ / 57.29578f);
        moveFunction.m_20372_(passenger, newPosX, this.m_20186_() + this.m_6048_() + passenger.m_6049_(), newPosZ);
    }

    @Override
    public void makeEntityJump() {
        this.wingFlap();
        super.makeEntityJump();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.9f;
    }

    public boolean m_5825_() {
        return this.isImmuneToFire || super.m_5825_();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        if (this.isFlyer() || this.isFloater()) {
            return false;
        }
        float i = (float)(Math.ceil(distance - 3.0f) / 2.0);
        if (!this.m_9236_().f_46443_ && i > 0.0f) {
            if (this.getTypeMoC() >= 10) {
                i /= 2.0f;
            }
            if (i > 1.0f) {
                this.m_6469_(damageSource, i);
            }
            if (this.m_20160_() && i > 1.0f) {
                for (Entity entity : this.m_20197_()) {
                    entity.m_6469_(damageSource, i);
                }
            }
            BlockPos pos = this.m_20183_().m_7495_();
            BlockState iblockstate = this.m_9236_().m_8055_(pos);
            Block block = iblockstate.m_60734_();
            if (!iblockstate.m_60795_() && !this.m_20067_()) {
                SoundType soundtype = block.getSoundType(iblockstate, (LevelReader)this.m_9236_(), pos, (Entity)this);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundtype.m_56776_(), this.m_5720_(), soundtype.m_56773_() * 0.5f, soundtype.m_56774_() * 0.75f);
            }
            return true;
        }
        return false;
    }
}

