/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class MoCEntityMole
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Integer> MOLE_STATE = SynchedEntityData.m_135353_(MoCEntityMole.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MoCEntityMole(EntityType<? extends MoCEntityMole> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture("mole.png");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOLE_STATE, (Object)0);
    }

    public boolean isOnDirt() {
        Block block = this.m_9236_().m_8055_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5)), Mth.m_14107_((double)this.m_20189_()))).m_60734_();
        return this.isDiggableBlock(block);
    }

    private boolean isDiggableBlock(Block block) {
        BlockState state = block.m_49966_();
        return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_) || block == Blocks.f_49994_;
    }

    private void digForward() {
        double coordY = this.m_20186_();
        double coordZ = this.m_20189_();
        double coordX = this.m_20185_();
        boolean x = true;
        double newPosY = coordY - Math.cos((this.m_146909_() - 90.0f) / 57.29578f) * (double)x;
        double newPosX = coordX + Math.cos(MoCTools.realAngle(this.m_146908_() - 90.0f) / 57.29578f) * (Math.sin((this.m_146909_() - 90.0f) / 57.29578f) * (double)x);
        double newPosZ = coordZ + Math.sin(MoCTools.realAngle(this.m_146908_() - 90.0f) / 57.29578f) * (Math.sin((this.m_146909_() - 90.0f) / 57.29578f) * (double)x);
        Block block = this.m_9236_().m_8055_(new BlockPos(Mth.m_14107_((double)newPosX), Mth.m_14107_((double)newPosY), Mth.m_14107_((double)newPosZ))).m_60734_();
        if (this.isDiggableBlock(block)) {
            this.m_6034_(newPosX, newPosY, newPosZ);
        }
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(MOLE_STATE);
    }

    public void setState(int i) {
        this.f_19804_.m_135381_(MOLE_STATE, (Object)i);
    }

    @Override
    public float pitchRotationOffset() {
        int i = this.getState();
        switch (i) {
            case 1: {
                return -45.0f;
            }
            case 3: {
                return 60.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        int i = this.getState();
        switch (i) {
            case 1: {
                return 0.3f;
            }
            case 2: {
                return 1.0f;
            }
            case 3: {
                return 0.1f;
            }
        }
        return 0.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            LivingEntity entityliving;
            if (this.f_19796_.m_188503_(10) == 0 && this.getState() == 1) {
                this.setState(2);
            }
            if (this.getState() != 2 && this.getState() != 1 && this.isOnDirt() && (entityliving = this.getBoogey(4.0)) != null && this.m_142582_((Entity)entityliving)) {
                this.setState(1);
                this.m_21573_().m_26573_();
            }
            if (this.f_19796_.m_188503_(20) == 0 && this.getState() == 2 && this.getBoogey(4.0) == null) {
                this.setState(3);
                this.m_21573_().m_26573_();
            }
            if (this.getState() != 0 && !this.isOnDirt()) {
                this.setState(0);
            }
            if (this.f_19796_.m_188503_(30) == 0 && this.getState() == 3) {
                this.setState(2);
            }
            this.m_6858_(this.getState() == 1 || this.getState() == 2);
        }
    }

    @Override
    public boolean isMovementCeased() {
        return this.getState() == 1 || this.getState() == 3;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        if (this.getState() != 2) {
            return super.m_6469_(damagesource, i);
        }
        return false;
    }

    public boolean m_5829_() {
        return this.getState() != 2;
    }

    public boolean m_6094_() {
        return this.getState() != 2;
    }

    protected void m_7324_(Entity entity) {
        if (this.getState() != 2) {
            super.m_7324_(entity);
        }
    }

    @Override
    public boolean m_5830_() {
        if (this.getState() == 2) {
            return false;
        }
        return super.m_5830_();
    }

    @Override
    public void m_6667_(DamageSource damagesource) {
        super.m_6667_(damagesource);
    }

    public boolean m_6673_(DamageSource source) {
        if (this.getState() == 2) {
            return true;
        }
        return super.m_6673_(source);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_RABBIT_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_RABBIT_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.MOLE;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.65f;
    }
}

