/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MoCEntityMouse
extends MoCEntityAnimal {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(MoCEntityMouse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MoCEntityMouse(EntityType<? extends MoCEntityMouse> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EntityAIFleeFromPlayer((PathfinderMob)this, 1.2, 4.0));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityAnimal.createAttributes().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)Boolean.FALSE);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(3) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("mouse_brown.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("mouse_white.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("mouse_beige.png");
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20191_().f_82289_), Mth.m_14107_((double)this.m_20189_()));
        try {
            String biomeName = ((ResourceKey)this.m_9236_().m_204166_(pos).m_203543_().orElseThrow()).m_135782_().m_135815_();
            if (biomeName.contains("mesa")) {
                this.setTypeMoC(2);
            }
            if (biomeName.contains("snow")) {
                this.setTypeMoC(3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean getIsPicked() {
        return this.m_20202_() != null;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_MOUSE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_MOUSE_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_MOUSE_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.MOUSE;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public double m_6049_() {
        if (this.m_20202_() instanceof Player && this.m_20202_() == MoCreatures.proxy.getPlayer() && this.m_9236_().m_5776_()) {
            return super.m_6049_() - (double)0.7f;
        }
        if (this.m_20202_() instanceof Player && this.m_9236_().m_5776_()) {
            return super.m_6049_() - (double)0.1f;
        }
        return super.m_6049_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_20202_() == null) {
            if (this.m_20329_((Entity)player)) {
                this.m_146922_(player.m_146908_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.setBesideClimbableBlock(this.f_19862_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20202_() != null) {
            this.m_146922_(this.m_20202_().m_146908_());
        }
    }

    public boolean upsideDown() {
        return this.getIsPicked();
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_271165_, SoundEvents.f_271165_);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.575f;
    }
}

