/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityTurkey
extends MoCEntityTameableAnimal {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42577_, Items.f_42733_});
    private int gestationTime = 0;

    public MoCEntityTurkey(EntityType<? extends MoCEntityTurkey> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setAdult(true);
        this.selectType();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(2) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.getTypeMoC() == 1 && this.getIsAdult()) {
            return MoCreatures.proxy.getModelTexture("turkey_male.png");
        }
        return MoCreatures.proxy.getModelTexture("turkey_female.png");
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_TURKEY_HURT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_TURKEY_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_TURKEY_AMBIENT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.TURKEY;
    }

    @Override
    public boolean compatibleMate(Entity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        return this.isMale() != ((MoCEntityTurkey)otherAnimal).isMale();
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        return "Turkey";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        return this.f_19796_.m_188503_(2) + 1;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult;
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_41619_()) {
            if (this.m_6898_(itemstack) && this.getIsAdult() && !this.getHasEaten()) {
                this.m_142075_(player, hand, itemstack);
                this.setHasEaten(true);
                return InteractionResult.SUCCESS;
            }
            if (!this.getIsAdult() && this.m_6898_(itemstack)) {
                this.m_142075_(player, hand, itemstack);
                this.setMoCAge(this.getMoCAge() + 10);
                if (this.getMoCAge() >= this.getMoCMaxAge()) {
                    this.setAdult(true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if ((tameResult = this.processTameInteract(player, hand)) != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!this.getIsTamed() && !stack.m_41619_() && stack.m_41720_() == Items.f_42578_) {
            if (!this.m_9236_().f_46443_) {
                MoCTools.tameWithName(player, this);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.8, 1.0));
        }
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() == Items.f_42577_;
    }

    @Override
    public int getMoCMaxAge() {
        return 35;
    }

    @Override
    public int nameYOffset() {
        return -50;
    }

    public int m_8100_() {
        return 400;
    }

    public int m_5792_() {
        return 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
            }
        } else {
            super.m_7822_(id);
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.945f;
    }

    @Override
    public boolean isMale() {
        return this.getTypeMoC() == 1;
    }

    @Override
    public float getSizeFactor() {
        if (!this.getIsAdult()) {
            return 0.5f + (float)this.getMoCAge() * 0.01f;
        }
        return 1.0f;
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128405_("GestationTime", this.gestationTime);
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.gestationTime = nbttagcompound.m_128451_("GestationTime");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.readytoBreed()) {
            this.doTurkeyBreeding();
        }
    }

    private void doTurkeyBreeding() {
        int nearbyTurkeys = 0;
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(8.0, 3.0, 8.0), entity -> entity != this && entity instanceof MoCEntityTurkey);
        nearbyTurkeys = list.size();
        if (nearbyTurkeys > 1) {
            return;
        }
        List nearbyMates = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(4.0, 2.0, 4.0), entity -> entity != this && entity instanceof MoCEntityTurkey);
        for (Entity potentialMate : nearbyMates) {
            if (!(potentialMate instanceof MoCEntityTurkey) || potentialMate == this) continue;
            MoCEntityTurkey mate = (MoCEntityTurkey)potentialMate;
            if (!this.readytoBreed() || !mate.readytoBreed() || !this.compatibleMate((Entity)mate)) continue;
            ++this.gestationTime;
            if (this.gestationTime % 3 == 0) {
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageHeart(this.m_19879_()));
            }
            if (this.gestationTime <= 50) continue;
            MoCEntityTurkey baby = (MoCEntityTurkey)((EntityType)MoCEntities.TURKEY.get()).m_20615_(this.m_9236_());
            if (baby != null) {
                ServerPlayer entityplayer;
                baby.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)baby);
                MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
                baby.setAdult(false);
                baby.setMoCAge(1);
                baby.setTamed(true);
                baby.setOwnerId(this.getOwnerId());
                baby.setTypeMoC(this.getOffspringTypeInt(mate));
                UUID ownerId = this.getOwnerId();
                if (ownerId != null && this.m_9236_() instanceof ServerLevel && (entityplayer = ((ServerLevel)this.m_9236_()).m_7654_().m_6846_().m_11259_(ownerId)) != null) {
                    MoCTools.tameWithName((Player)entityplayer, baby);
                }
            }
            this.setHasEaten(false);
            this.gestationTime = 0;
            mate.setHasEaten(false);
            mate.gestationTime = 0;
            break;
        }
    }
}

