/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MoCEntityTurtle
extends MoCEntityTameableAnimal {
    private static final EntityDataAccessor<Boolean> IS_UPSIDE_DOWN = SynchedEntityData.m_135353_(MoCEntityTurtle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_HIDING = SynchedEntityData.m_135353_(MoCEntityTurtle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isSwinging;
    private boolean twistright;
    private int flopcounter;

    public MoCEntityTurtle(EntityType<? extends MoCEntityTurtle> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAnimal>)type, world);
        this.setAdult(true);
        this.setMoCAge(90);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new EntityAIFollowOwnerPlayer((Mob)this, 0.8, 2.0f, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 0.8, 50));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return MoCEntityTameableAnimal.createAttributes().m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_UPSIDE_DOWN, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(IS_HIDING, (Object)Boolean.FALSE);
    }

    @Override
    public ResourceLocation getTexture() {
        String tempText = "turtle.png";
        if (MoCreatures.proxy.easterEggs) {
            if (this.getPetName().equals("Donatello") || this.getPetName().equals("donatello")) {
                tempText = "turtle_donatello.png";
            }
            if (this.getPetName().equals("Leonardo") || this.getPetName().equals("leonardo")) {
                tempText = "turtle_leonardo.png";
            }
            if (this.getPetName().equals("raphael") || this.getPetName().equals("Raphael")) {
                tempText = "turtle_raphael.png";
            }
            if (this.getPetName().equals("Michelangelo") || this.getPetName().equals("michelangelo")) {
                tempText = "turtle_michelangelo.png";
            }
        }
        return MoCreatures.proxy.getModelTexture(tempText);
    }

    public boolean getIsHiding() {
        return (Boolean)this.f_19804_.m_135370_(IS_HIDING);
    }

    public void setIsHiding(boolean flag) {
        this.f_19804_.m_135381_(IS_HIDING, (Object)flag);
    }

    public boolean getIsUpsideDown() {
        return (Boolean)this.f_19804_.m_135370_(IS_UPSIDE_DOWN);
    }

    public void setIsUpsideDown(boolean flag) {
        this.flopcounter = 0;
        this.f_20921_ = 0.0f;
        this.f_19804_.m_135381_(IS_UPSIDE_DOWN, (Object)flag);
    }

    public double m_6048_() {
        if (this.m_20202_() instanceof Player) {
            if (this.m_20202_().m_6047_()) {
                return -0.25 + (300.0 - (double)this.getMoCAge()) / 500.0;
            }
            return (300.0 - (double)this.getMoCAge()) / 500.0;
        }
        return super.m_6048_();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (this.getIsTamed()) {
            if (this.getIsUpsideDown()) {
                this.flipflop(false);
                return InteractionResult.SUCCESS;
            }
            if (this.m_20202_() == null && this.m_20329_((Entity)player)) {
                this.m_146922_(player.m_146908_());
            }
            return InteractionResult.SUCCESS;
        }
        this.flipflop(!this.getIsUpsideDown());
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_6135_() {
        if (this.m_204029_(FluidTags.f_13131_)) {
            this.m_20334_(this.m_20184_().f_82479_, 0.3, this.m_20184_().f_82481_);
            if (this.m_20142_()) {
                float f = this.m_146908_() * 0.01745329f;
                this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)f) * -0.2f), 0.0, (double)(Mth.m_14089_((float)f) * 0.2f)));
            }
            this.f_19812_ = true;
        }
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_9236_().f_46443_ || this.getIsUpsideDown() || this.getIsTamed())) {
            LivingEntity entityliving = this.getBoogey(4.0);
            if (entityliving != null && this.m_142582_((Entity)entityliving)) {
                if (!this.getIsHiding() && !this.m_20069_()) {
                    MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_TURTLE_ANGRY.get());
                    this.setIsHiding(true);
                }
                this.m_21573_().m_26573_();
            } else {
                ItemEntity entityitem;
                this.setIsHiding(false);
                if (!this.m_21573_().m_26572_() && this.f_19796_.m_188503_(50) == 0 && (entityitem = this.getClosestItem((Entity)this, 10.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42028_, Items.f_41909_}))) != null) {
                    float f = entityitem.m_20270_((Entity)this);
                    if (f > 2.0f) {
                        this.setPathToEntity((Entity)entityitem, f);
                    }
                    if (f < 2.0f && this.f_20919_ == 0) {
                        entityitem.m_142687_(Entity.RemovalReason.DISCARDED);
                        MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_TURTLE_EATING.get());
                        Player entityplayer = this.m_9236_().m_45930_((Entity)this, 24.0);
                        if (entityplayer != null) {
                            MoCTools.tameWithName(entityplayer, this);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean m_6040_() {
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Entity entity = damagesource.m_7639_();
        if (this.m_20202_() != null) {
            return false;
        }
        if (entity == null) {
            return super.m_6469_(damagesource, i);
        }
        if (this.getIsHiding()) {
            if (this.f_19796_.m_188503_(10) == 0) {
                this.flipflop(true);
            }
            return false;
        }
        boolean flag = super.m_6469_(damagesource, i);
        if (this.f_19796_.m_188503_(3) == 0) {
            this.flipflop(true);
        }
        return flag;
    }

    public void flipflop(boolean flip) {
        this.setIsUpsideDown(flip);
        this.setIsHiding(false);
        this.m_21573_().m_26573_();
    }

    @Override
    public boolean entitiesToIgnore(Entity entity) {
        return entity instanceof MoCEntityTurtle || entity.m_20206_() <= this.m_20206_() && entity.m_20205_() <= this.m_20205_() || super.entitiesToIgnore(entity);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20202_() != null && this.m_20202_() instanceof Player) {
            Player entityplayer = (Player)this.m_20202_();
            this.m_146922_(entityplayer.m_146908_());
        }
        if (this.getIsSwinging()) {
            this.f_20921_ += 0.2f;
            if (this.f_20921_ > 8.0f) {
                this.setSwinging(false);
            }
        } else {
            this.f_20921_ = 0.0f;
        }
        if (this.getIsUpsideDown()) {
            ++this.flopcounter;
            this.m_21573_().m_26573_();
            if (this.flopcounter > 50 && this.f_19796_.m_188503_(30) == 0) {
                this.setIsUpsideDown(false);
            }
        }
    }

    public boolean getIsSwinging() {
        return this.isSwinging;
    }

    public void setSwinging(boolean flag) {
        this.isSwinging = flag;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsUpsideDown() || this.getIsHiding();
    }

    public int getFlipDirection() {
        if (this.twistright) {
            return 1;
        }
        this.twistright = !this.twistright;
        return -1;
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("UpsideDown", this.getIsUpsideDown());
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setIsUpsideDown(nbttagcompound.m_128471_("UpsideDown"));
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_TURTLE_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_TURTLE_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_TURTLE_DEATH.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.TURTLE;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        if (!this.m_9236_().f_46443_ && !this.m_6162_() && this.f_19796_.m_188503_(10) == 0) {
            ItemStack helmet = new ItemStack((ItemLike)Items.f_42354_);
            this.m_19983_(helmet);
        }
        if (this.isTMNT() && !this.m_9236_().f_46443_) {
            ItemStack weapon;
            if (this.getPetName().equalsIgnoreCase("Donatello")) {
                weapon = new ItemStack((ItemLike)MoCItems.BO.get());
                weapon.m_41714_((Component)Component.m_237115_((String)"mocreatures.ninjaturtle.bo"));
                this.m_19983_(weapon);
            }
            if (this.getPetName().equalsIgnoreCase("Leonardo")) {
                weapon = new ItemStack((ItemLike)MoCItems.KATANA.get());
                weapon.m_41714_((Component)Component.m_237115_((String)"mocreatures.ninjaturtle.katana"));
                this.m_19983_(weapon);
            }
            if (this.getPetName().equalsIgnoreCase("Raphael")) {
                weapon = new ItemStack((ItemLike)MoCItems.SAI.get());
                weapon.m_41714_((Component)Component.m_237115_((String)"mocreatures.ninjaturtle.sai"));
                this.m_19983_(weapon);
            }
            if (this.getPetName().equalsIgnoreCase("Michelangelo")) {
                weapon = new ItemStack((ItemLike)MoCItems.NUNCHAKU.get());
                weapon.m_41714_((Component)Component.m_237115_((String)"mocreatures.ninjaturtle.nunchaku"));
                this.m_19983_(weapon);
            }
        }
    }

    public boolean isTMNT() {
        if (!this.getIsTamed() || !MoCreatures.proxy.easterEggs) {
            return false;
        }
        return this.getPetName().equalsIgnoreCase("Donatello") || this.getPetName().equalsIgnoreCase("Leonardo") || this.getPetName().equalsIgnoreCase("Raphael") || this.getPetName().equalsIgnoreCase("Michelangelo");
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() == Items.f_41909_ || stack.m_41720_() == Items.f_42028_);
    }

    public int m_5792_() {
        return 2;
    }

    @Override
    public int nameYOffset() {
        return -10 - this.getMoCAge() / 5;
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    public boolean isAmphibian() {
        return true;
    }

    public float m_6113_() {
        if (this.m_20069_() && !this.isMovementCeased()) {
            return 0.25f;
        }
        return 0.12f;
    }

    @Override
    protected double minDivingDepth() {
        return ((double)this.getMoCAge() + 8.0) / 340.0;
    }

    @Override
    protected double maxDivingDepth() {
        return (double)this.getMoCAge() / 100.0;
    }

    @Override
    public int getMoCMaxAge() {
        return 120;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.525f;
    }
}

