/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.tameable;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class MoCEntityTameableAquatic
extends MoCEntityAquatic
implements IMoCTameable {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(MoCEntityTameableAquatic.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> PET_ID = SynchedEntityData.m_135353_(MoCEntityTameableAquatic.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(MoCEntityTameableAquatic.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean hasEaten;
    private int gestationtime;

    public MoCEntityTameableAquatic(EntityType<? extends MoCEntityTameableAquatic> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(PET_ID, (Object)-1);
        this.f_19804_.m_135372_(TAMED, (Object)false);
    }

    @Override
    public int getOwnerPetId() {
        return (Integer)this.f_19804_.m_135370_(PET_ID);
    }

    @Override
    public void setOwnerPetId(int i) {
        this.f_19804_.m_135381_(PET_ID, (Object)i);
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    @Override
    public void setOwnerId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(uniqueId));
    }

    @Override
    public void setTamed(boolean flag) {
        this.f_19804_.m_135381_(TAMED, (Object)flag);
    }

    @Override
    public boolean getIsTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return this.getIsTamed();
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Entity entity = damagesource.m_7639_();
        if (this.m_20160_() && entity == this.m_20202_() || this.m_20202_() != null && entity == this.m_20202_()) {
            return false;
        }
        if (this.usesNewAI()) {
            return super.m_6469_(damagesource, i);
        }
        if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && entity instanceof Player) {
            Player player = (Player)entity;
            if (!entity.m_20148_().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP(player)) {
                return false;
            }
        }
        return super.m_6469_(damagesource, i);
    }

    private boolean checkOwnership(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.getIsTamed() || MoCTools.isThisPlayerAnOP(player)) {
            return true;
        }
        if (this.getIsGhost() && !stack.m_41619_() && stack.m_150930_((Item)MoCItems.PET_AMULET.get())) {
            if (!this.m_9236_().m_5776_()) {
                MutableComponent message = Component.m_237115_((String)"msg.mocreatures.foreignpet");
                message.m_7383_().m_131140_(ChatFormatting.RED);
                player.m_213846_((Component)message);
            }
            return false;
        }
        if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !player.m_20148_().equals(this.getOwnerId())) {
            MutableComponent message = Component.m_237115_((String)"msg.mocreatures.foreignpet");
            message.m_7383_().m_131140_(ChatFormatting.RED);
            player.m_213846_((Component)message);
            return false;
        }
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        return super.m_6071_(player, hand);
    }

    public InteractionResult processTameInteract(Player player, InteractionHand hand) {
        if (!this.checkOwnership(player, hand)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_150930_((Item)MoCItems.SCROLLOFOWNER.get()) && MoCreatures.proxy.enableResetOwnership && MoCTools.isThisPlayerAnOP(player)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.getOwnerPetId() != -1) {
                    MoCreatures.instance.mapData.removeOwnerPet(this, this.getOwnerPetId());
                }
                this.setOwnerId(null);
            }
            return InteractionResult.SUCCESS;
        }
        if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !player.m_20148_().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP(player)) {
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().m_5776_() && !stack.m_41619_() && this.getIsTamed() && (stack.m_150930_((Item)MoCItems.MEDALLION.get()) || stack.m_150930_(Items.f_42517_) || stack.m_150930_(Items.f_42656_))) {
            return MoCTools.tameWithName(player, this);
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_150930_((Item)MoCItems.SCROLLFREEDOM.get())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.getOwnerPetId() != -1) {
                    MoCreatures.instance.mapData.removeOwnerPet(this, this.getOwnerPetId());
                }
                this.setOwnerId(null);
                this.setPetName("");
                this.dropMyStuff();
                this.setTamed(false);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && stack.m_150930_((Item)MoCItems.SCROLLOFSALE.get())) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.getOwnerPetId() != -1) {
                    MoCreatures.instance.mapData.removeOwnerPet(this, this.getOwnerPetId());
                }
                this.setOwnerId(null);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.getIsTamed() && this.isMyHealFood(stack)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            if (!this.m_9236_().m_5776_()) {
                this.m_21153_(this.m_21233_());
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && stack.m_150930_((Item)MoCItems.FISH_NET.get()) && this.canBeTrappedInNet()) {
            MoCPetData petData;
            if (!this.m_9236_().m_5776_() && (petData = MoCreatures.instance.mapData.getPetData(this.getOwnerId())) != null) {
                petData.setInAmulet(this.getOwnerPetId(), true);
            }
            player.m_21008_(hand, ItemStack.f_41583_);
            if (!this.m_9236_().m_5776_()) {
                MoCTools.dropAmulet(this, 1, player);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED) {
            super.m_142687_(reason);
            return;
        }
        if (!this.m_9236_().m_5776_() && this.getIsTamed() && this.m_21223_() > 0.0f && !this.isRiderDisconnecting()) {
            return;
        }
        super.m_142687_(reason);
    }

    @Override
    public void playTameEffect(boolean par1) {
        SimpleParticleType particleType = ParticleTypes.f_123750_;
        if (!par1) {
            particleType = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleType, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128379_("Tamed", this.getIsTamed());
        if (this.getOwnerId() != null) {
            nbttagcompound.m_128359_("OwnerUUID", this.getOwnerId().toString());
        }
        if (this.getOwnerPetId() != -1) {
            nbttagcompound.m_128405_("PetId", this.getOwnerPetId());
        }
        if (this.getIsTamed() && MoCreatures.instance.mapData != null) {
            MoCreatures.instance.mapData.updateOwnerPet(this);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setTamed(nbttagcompound.m_128471_("Tamed"));
        String s = "";
        if (nbttagcompound.m_128425_("OwnerUUID", 8)) {
            s = nbttagcompound.m_128461_("OwnerUUID");
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
        if (nbttagcompound.m_128441_("PetId")) {
            this.setOwnerPetId(nbttagcompound.m_128451_("PetId"));
        }
        if (this.getIsTamed() && nbttagcompound.m_128441_("PetId")) {
            MoCPetData petData = MoCreatures.instance.mapData.getPetData(this.getOwnerId());
            if (petData != null) {
                ListTag tag = petData.getOwnerRootNBT().m_128437_("TamedList", 10);
                for (int i = 0; i < tag.size(); ++i) {
                    CompoundTag nbt = tag.m_128728_(i);
                    if (nbt.m_128451_("PetId") != nbttagcompound.m_128451_("PetId")) continue;
                    nbt.m_128379_("InAmulet", false);
                    if (!nbt.m_128441_("Cloned")) continue;
                    nbt.m_128473_("Cloned");
                    this.setTamed(false);
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else {
                this.setOwnerPetId(-1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte par1) {
        if (par1 == 2) {
            this.f_267362_.m_267771_(1.5f);
            Objects.requireNonNull(this);
            this.f_19802_ = 20;
            this.f_20917_ = 10;
            this.f_20916_ = 10;
            this.m_5496_(this.m_7975_(this.m_269291_().m_269264_()), this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_6469_(this.m_269291_().m_269264_(), 0.0f);
        } else if (par1 == 3) {
            this.m_5496_(this.m_5592_(), this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_21153_(0.0f);
            this.m_6667_(this.m_269291_().m_269264_());
        } else {
            super.m_7822_(par1);
        }
    }

    @Override
    public float getPetHealth() {
        return this.m_21223_();
    }

    @Override
    public boolean isRiderDisconnecting() {
        return this.riderIsDisconnecting;
    }

    @Override
    public void setRiderDisconnecting(boolean flag) {
        this.riderIsDisconnecting = flag;
    }

    @Override
    public void spawnHeart() {
        double var2 = this.f_19796_.m_188583_() * 0.02;
        double var4 = this.f_19796_.m_188583_() * 0.02;
        double var6 = this.f_19796_.m_188583_() * 0.02;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), var2, var4, var6);
    }

    @Override
    public boolean readytoBreed() {
        return !this.m_20160_() && this.m_20202_() == null && this.getIsTamed() && this.getHasEaten() && this.getIsAdult();
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        return "";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        return 0;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof IMoCTameable;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.readytoBreed() && this.f_19796_.m_188503_(100) == 0) {
            this.doBreeding();
        }
    }

    public boolean m_5830_() {
        if (this.getIsTamed()) {
            return false;
        }
        return super.m_5830_();
    }

    protected void doBreeding() {
        int i = 0;
        List list = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(8.0, 3.0, 8.0), entity -> entity != this);
        for (Entity entity2 : list) {
            if (!this.compatibleMate(entity2)) continue;
            ++i;
        }
        if (i > 1) {
            list.clear();
            return;
        }
        List list1 = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0), entity -> entity != this);
        for (Entity mate : list1) {
            if (!this.compatibleMate(mate) || mate == this) continue;
            if (!this.readytoBreed()) {
                list.clear();
                list1.clear();
                return;
            }
            if (!((IMoCTameable)mate).readytoBreed()) {
                return;
            }
            this.setGestationTime(this.getGestationTime() + 1);
            if (!this.m_9236_().m_5776_()) {
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageHeart(this.m_19879_()));
            }
            if (this.getGestationTime() <= 50) continue;
            try {
                String offspringName = this.getOffspringClazz((IMoCTameable)mate);
                Mob offspring = (Mob)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("mocreatures:" + offspringName.toLowerCase()))).m_20615_(this.m_9236_());
                if (offspring instanceof IMoCTameable) {
                    IMoCTameable baby = (IMoCTameable)offspring;
                    offspring.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                    this.m_9236_().m_7967_((Entity)offspring);
                    baby.setAdult(false);
                    baby.setMoCAge(35);
                    baby.setTamed(true);
                    baby.setOwnerId(this.getOwnerId());
                    baby.setTypeMoC(this.getOffspringTypeInt((IMoCTameable)mate));
                    UUID ownerId = this.getOwnerId();
                    Player entityplayer = null;
                    if (ownerId != null) {
                        entityplayer = this.m_9236_().m_46003_(this.getOwnerId());
                    }
                    if (entityplayer != null) {
                        MoCTools.tameWithName(entityplayer, baby);
                    }
                }
                MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setHasEaten(false);
            this.setGestationTime(0);
            ((IMoCTameable)mate).setHasEaten(false);
            ((IMoCTameable)mate).setGestationTime(0);
            break;
        }
        list.clear();
        list1.clear();
    }

    @Override
    public boolean getHasEaten() {
        return this.hasEaten;
    }

    @Override
    public void setHasEaten(boolean flag) {
        this.hasEaten = flag;
    }

    @Override
    public int getGestationTime() {
        return this.gestationtime;
    }

    @Override
    public void setGestationTime(int time) {
        this.gestationtime = time;
    }
}

