/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.tameable;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class MoCPetData {
    private final UUID ownerUniqueId;
    private final BitSet idMap = new BitSet(1024);
    private final ArrayList<Integer> usedPetIds = new ArrayList();
    private CompoundTag ownerData = new CompoundTag();
    private ListTag tamedList = new ListTag();

    public MoCPetData(IMoCTameable pet) {
        this.ownerData.m_128365_("TamedList", (Tag)this.tamedList);
        Level level = ((Entity)pet).m_9236_();
        this.ownerUniqueId = MoCreatures.isServer(level) ? pet.getOwnerId() : Minecraft.m_91087_().f_91074_.m_20148_();
        MoCreatures.LOGGER.debug("Created new MoCPetData for owner {}", (Object)this.ownerUniqueId);
    }

    public MoCPetData(CompoundTag nbt, UUID owner) {
        this.ownerData = nbt;
        this.tamedList = nbt.m_128437_("TamedList", 10);
        this.ownerUniqueId = owner;
        this.loadPetDataMap(nbt.m_128469_("PetIdData"));
        MoCreatures.LOGGER.debug("Loaded MoCPetData for owner {} with {} pets", (Object)this.ownerUniqueId, (Object)this.tamedList.size());
    }

    public int addPet(IMoCTameable pet) {
        Entity entity = (Entity)pet;
        ChunkPos chunkCoord = entity.m_146902_();
        BlockPos coords = new BlockPos(chunkCoord.f_45578_, chunkCoord.m_45615_().m_123342_(), chunkCoord.f_45579_);
        CompoundTag petNBT = MoCTools.getEntityData(entity);
        if (this.tamedList != null) {
            int id = this.getNextFreePetId();
            petNBT.m_128405_("PetId", id);
            CompoundTag petData = petNBT.m_6426_();
            petData.m_128405_("ChunkX", coords.m_123341_());
            petData.m_128405_("ChunkY", coords.m_123342_());
            petData.m_128405_("ChunkZ", coords.m_123343_());
            petData.m_128359_("Dimension", entity.m_9236_().m_46472_().m_135782_().toString());
            this.tamedList.add((Object)petData);
            this.ownerData.m_128365_("PetIdData", (Tag)this.savePetDataMap());
            MoCreatures.LOGGER.debug("Added pet ID {} for owner {}", (Object)id, (Object)this.ownerUniqueId);
            return id;
        }
        MoCreatures.LOGGER.error("Cannot add pet - tamedList is null for owner {}", (Object)this.ownerUniqueId);
        return -1;
    }

    public boolean removePet(int id) {
        for (int i = this.tamedList.size() - 1; i >= 0; --i) {
            CompoundTag nbt = this.tamedList.m_128728_(i);
            if (!nbt.m_128441_("PetId") || nbt.m_128451_("PetId") != id) continue;
            if (i < 0 || i >= this.tamedList.size()) {
                MoCreatures.LOGGER.error("Invalid tamedList index: {} for PetId: {}", (Object)i, (Object)id);
                return false;
            }
            this.tamedList.remove(i);
            this.usedPetIds.remove((Object)id);
            this.idMap.clear(id);
            if (this.usedPetIds.isEmpty()) {
                this.idMap.clear();
            }
            this.ownerData.m_128365_("PetIdData", (Tag)this.savePetDataMap());
            MoCreatures.LOGGER.debug("Removed pet ID {} for owner {}", (Object)id, (Object)this.ownerUniqueId);
            return true;
        }
        MoCreatures.LOGGER.error("Failed to remove petId {} - not found in tamedList for owner {}", (Object)id, (Object)this.ownerUniqueId);
        return false;
    }

    public CompoundTag getPetData(int id) {
        if (this.tamedList != null) {
            for (int i = 0; i < this.tamedList.size(); ++i) {
                CompoundTag nbt = this.tamedList.m_128728_(i);
                if (!nbt.m_128441_("PetId") || nbt.m_128451_("PetId") != id) continue;
                return nbt;
            }
        }
        return null;
    }

    public CompoundTag getOwnerRootNBT() {
        return this.ownerData;
    }

    public ListTag getTamedList() {
        return this.tamedList;
    }

    public String getOwner() {
        return this.ownerData != null ? this.ownerData.m_128461_("Owner") : null;
    }

    public boolean getInAmulet(int petId) {
        CompoundTag petData = this.getPetData(petId);
        return petData != null && petData.m_128471_("InAmulet");
    }

    public void setInAmulet(int petId, boolean flag) {
        CompoundTag petData = this.getPetData(petId);
        if (petData != null) {
            petData.m_128379_("InAmulet", flag);
        }
    }

    public int getNextFreePetId() {
        int next = 0;
        while (this.usedPetIds.contains(next = this.idMap.nextClearBit(next))) {
            this.idMap.set(next);
        }
        this.usedPetIds.add(next);
        return next;
    }

    public CompoundTag savePetDataMap() {
        int[] data = new int[(this.idMap.length() + 32 - 1) / 32];
        CompoundTag dataMap = new CompoundTag();
        for (int i = 0; i < data.length; ++i) {
            int val = 0;
            for (int j = 0; j < 32; ++j) {
                val |= this.idMap.get(i * 32 + j) ? 1 << j : 0;
            }
            data[i] = val;
        }
        dataMap.m_128385_("PetIdArray", data);
        return dataMap;
    }

    public void loadPetDataMap(CompoundTag compoundTag) {
        if (compoundTag == null) {
            this.idMap.clear();
            MoCreatures.LOGGER.debug("Reset pet ID map for owner {} (null compound tag)", (Object)this.ownerUniqueId);
        } else {
            int[] intArray = compoundTag.m_128465_("PetIdArray");
            for (int i = 0; i < intArray.length; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.idMap.set(i * 32 + j, (intArray[i] & 1 << j) != 0);
                }
            }
            int next = 0;
            int idsAdded = 0;
            while ((next = this.idMap.nextSetBit(next)) != -1) {
                if (!this.usedPetIds.contains(next)) {
                    this.usedPetIds.add(next);
                    ++idsAdded;
                }
                ++next;
            }
            MoCreatures.LOGGER.debug("Loaded pet ID map for owner {} with {} IDs", (Object)this.ownerUniqueId, (Object)idsAdded);
        }
    }

    public UUID getOwnerUniqueId() {
        return this.ownerUniqueId;
    }
}

