/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.tameable;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MoCPetMapData
extends SavedData {
    private final Object2ObjectOpenHashMap<UUID, MoCPetData> petMap = new Object2ObjectOpenHashMap();
    private final String name;
    private final AtomicInteger changeCounter = new AtomicInteger(0);
    private static final int FORCE_SAVE_THRESHOLD = 10;

    public MoCPetMapData(String name) {
        this.name = name;
        this.m_77762_();
    }

    public static MoCPetMapData load(CompoundTag tag) {
        MoCPetMapData data = new MoCPetMapData("mocreatures");
        for (String key : tag.m_128431_()) {
            try {
                UUID ownerUUID = UUID.fromString(key);
                CompoundTag nbt = tag.m_128469_(key);
                if (data.petMap.containsKey((Object)ownerUUID)) continue;
                data.petMap.put((Object)ownerUUID, (Object)new MoCPetData(nbt, ownerUUID));
                MoCreatures.LOGGER.debug("Loaded pet data for owner: {}", (Object)ownerUUID);
            }
            catch (Exception e) {
                MoCreatures.LOGGER.error("Error loading pet data for key {}: {}", (Object)key, (Object)e.getMessage());
            }
        }
        MoCreatures.LOGGER.info("Loaded MoCPetMapData with {} pet owners", (Object)data.petMap.size());
        return data;
    }

    public MoCPetData getPetData(UUID ownerUniqueId) {
        return (MoCPetData)this.petMap.get((Object)ownerUniqueId);
    }

    public Object2ObjectOpenHashMap<UUID, MoCPetData> getPetMap() {
        return this.petMap;
    }

    public void removeOwnerPet(IMoCTameable pet, int petId) {
        UUID owner = pet.getOwnerId();
        MoCPetData data = (MoCPetData)this.petMap.get((Object)owner);
        if (data != null) {
            boolean success = data.removePet(petId);
            if (success) {
                this.m_77762_();
                pet.setOwnerPetId(-1);
                MoCreatures.LOGGER.debug("Successfully removed pet ID {} for owner {}", (Object)petId, (Object)owner);
                this.incrementChangeCounter();
                if (data.getTamedList().isEmpty()) {
                    this.petMap.remove((Object)owner);
                    MoCreatures.LOGGER.debug("Removed last pet for owner {}, removing owner entry", (Object)owner);
                }
            } else {
                MoCreatures.LOGGER.error("Could not remove petId {} for owner {}", (Object)petId, (Object)owner);
            }
        } else {
            MoCreatures.LOGGER.error("No pet data found for owner {} when trying to remove pet ID {}", (Object)owner, (Object)petId);
        }
    }

    public void updateOwnerPet(IMoCTameable pet) {
        if (pet.getOwnerPetId() == -1 || this.petMap.get((Object)pet.getOwnerId()) == null) {
            int id;
            UUID owner;
            UUID uUID = owner = MoCreatures.isServer(((Entity)pet).m_9236_()) ? pet.getOwnerId() : Minecraft.m_91087_().f_91074_.m_20148_();
            if (this.petMap.containsKey((Object)owner)) {
                MoCPetData petData = (MoCPetData)this.petMap.get((Object)owner);
                id = petData.addPet(pet);
                MoCreatures.LOGGER.debug("Added new pet with ID {} for existing owner {}", (Object)id, (Object)owner);
            } else {
                MoCPetData petData = new MoCPetData(pet);
                id = petData.addPet(pet);
                this.petMap.put((Object)owner, (Object)petData);
                MoCreatures.LOGGER.debug("Created new pet data for owner {} with first pet ID {}", (Object)owner, (Object)id);
            }
            pet.setOwnerPetId(id);
        } else {
            UUID owner = pet.getOwnerId();
            MoCPetData petData = this.getPetData(owner);
            CompoundTag rootNBT = petData.getOwnerRootNBT();
            ListTag tag = rootNBT.m_128437_("TamedList", 10);
            int id = pet.getOwnerPetId();
            for (int i = 0; i < tag.size(); ++i) {
                CompoundTag nbt = tag.m_128728_(i);
                if (nbt.m_128451_("PetId") != id) continue;
                nbt.m_128365_("Pos", (Tag)this.newDoubleNBTList(((Entity)pet).m_20185_(), ((Entity)pet).m_20186_(), ((Entity)pet).m_20189_()));
                nbt.m_128405_("ChunkX", ((Entity)pet).m_146902_().f_45578_);
                nbt.m_128405_("ChunkY", ((Entity)pet).m_146902_().m_45615_().m_123342_());
                nbt.m_128405_("ChunkZ", ((Entity)pet).m_146902_().f_45579_);
                nbt.m_128359_("Dimension", ((Entity)pet).m_9236_().m_46472_().m_135782_().toString());
                nbt.m_128405_("PetId", pet.getOwnerPetId());
                MoCreatures.LOGGER.debug("Updated position data for pet ID {} owned by {}", (Object)id, (Object)owner);
                break;
            }
        }
        this.m_77762_();
        this.incrementChangeCounter();
    }

    private void incrementChangeCounter() {
        if (this.changeCounter.incrementAndGet() >= 10) {
            MoCreatures.LOGGER.debug("Reached {} changes, forcing save", (Object)this.changeCounter.get());
            this.m_77762_();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && server.m_129783_() != null) {
                server.m_129783_().m_8895_().m_78151_();
                MoCreatures.LOGGER.debug("Forced save of pet data after {} changes", (Object)10);
            }
            this.changeCounter.set(0);
        }
    }

    protected ListTag newDoubleNBTList(double ... values) {
        ListTag list = new ListTag();
        for (double val : values) {
            list.add((Object)DoubleTag.m_128500_((double)val));
        }
        return list;
    }

    public boolean isExistingPet(UUID owner, IMoCTameable pet) {
        MoCPetData petData = MoCreatures.instance.mapData.getPetData(owner);
        if (petData != null) {
            ListTag tag = petData.getTamedList();
            for (int i = 0; i < tag.size(); ++i) {
                CompoundTag nbt = tag.m_128728_(i);
                if (nbt.m_128451_("PetId") != pet.getOwnerPetId()) continue;
                return true;
            }
        }
        return false;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        int count = 0;
        for (Map.Entry entry : this.petMap.entrySet()) {
            try {
                if (entry.getKey() == null) continue;
                tag.m_128365_(((UUID)entry.getKey()).toString(), (Tag)((MoCPetData)entry.getValue()).getOwnerRootNBT());
                ++count;
            }
            catch (Exception e) {
                MoCreatures.LOGGER.error("Error saving pet data for owner {}: {}", entry.getKey(), (Object)e.getMessage());
            }
        }
        MoCreatures.LOGGER.info("Saved MoCPetMapData with {} pet owners", (Object)count);
        return tag;
    }

    public void forceDirty() {
        this.m_77762_();
    }
}

