/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.event;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityData;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetMapData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MoCEventHooks {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof Level && ((Level)event.getLevel()).m_46472_() == Level.f_46428_) {
            MoCreatures.proxy.worldInitDone = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.getLevel();
        if (!serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        if (!MoCreatures.proxy.worldInitDone) {
            MoCPetMapData data;
            MoCreatures.instance.mapData = data = (MoCPetMapData)serverLevel.m_8895_().m_164861_(MoCPetMapData::load, () -> new MoCPetMapData("mocreatures"), "mocreatures");
            MoCreatures.proxy.worldInitDone = true;
        }
    }

    @SubscribeEvent
    public void onLivingSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        Class<?> entityClass = entity.getClass();
        MoCEntityData data = (MoCEntityData)MoCreatures.entityMap.get(entityClass);
        if (data == null) {
            return;
        }
        Level level = entity.m_9236_();
        List<ResourceKey<Level>> dimensionIDs = Arrays.asList(data.getDimensions());
        if (MoCTools.isInWyvernLair((Entity)entity)) {
            if (!MoCTools.canSpawnInWyvernLair((Entity)entity)) {
                event.setSpawnCancelled(true);
                return;
            }
            event.setResult(Event.Result.ALLOW);
            return;
        }
        if (!dimensionIDs.contains(level.m_46472_())) {
            event.setSpawnCancelled(true);
        } else if (data.getFrequency() <= 0) {
            event.setSpawnCancelled(true);
        } else if (dimensionIDs.contains(MoCreatures.proxy.wyvernDimension) && level.m_46472_().equals(MoCreatures.proxy.wyvernDimension)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.getEntity().m_9236_().m_5776_() && IMoCTameable.class.isAssignableFrom(event.getEntity().getClass())) {
            IMoCTameable mocEntity = (IMoCTameable)event.getEntity();
            if (mocEntity.getIsTamed() && mocEntity.getPetHealth() > 0.0f && !mocEntity.isRiderDisconnecting()) {
                return;
            }
            if (mocEntity.getOwnerPetId() != -1) {
                MoCreatures.instance.mapData.removeOwnerPet(mocEntity, mocEntity.getOwnerPetId());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player.m_20202_() instanceof IMoCTameable) {
            IMoCTameable mocEntity = (IMoCTameable)player.m_20202_();
            mocEntity.setRiderDisconnecting(true);
        }
    }

    private BlockPos getSafeSpawnPos(LivingEntity entity, BlockPos near) {
        int radius = 6;
        int maxTries = 24;
        for (int i = 0; i < maxTries; ++i) {
            int x = near.m_123341_() + entity.m_9236_().m_213780_().m_188503_(radius * 2) - radius;
            int z = near.m_123343_() + entity.m_9236_().m_213780_().m_188503_(radius * 2) - radius;
            int y = entity.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z) + 16;
            BlockPos testing = new BlockPos(x, y, z);
            while (entity.m_9236_().m_46859_(testing) && testing.m_123342_() > 0) {
                testing = testing.m_7495_();
            }
            BlockState blockstate = entity.m_9236_().m_8055_(testing);
            if (!blockstate.m_60643_((BlockGetter)entity.m_9236_(), testing, EntityType.f_20510_)) continue;
            return testing.m_7494_();
        }
        return null;
    }
}

