/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.event;

import drzhark.mocreatures.MoCTools;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="mocreatures")
public class MoCEventHooksTerrain {
    public static final Object2ObjectOpenHashMap<ResourceLocation, List<MobSpawnSettings.SpawnerData>> creatureSpawnMap = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<ResourceLocation, List<MobSpawnSettings.SpawnerData>> waterCreatureSpawnMap = new Object2ObjectOpenHashMap();

    public static void buildWorldGenSpawnLists() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            ResourceLocation biomeKey = ForgeRegistries.BIOMES.getKey((Object)biome);
            if (biomeKey == null) continue;
            ArrayList creatureList = new ArrayList(biome.m_47518_().m_151798_(MobCategory.CREATURE).m_146338_());
            ArrayList waterList = new ArrayList(biome.m_47518_().m_151798_(MobCategory.WATER_CREATURE).m_146338_());
            creatureSpawnMap.put((Object)biomeKey, creatureList);
            waterCreatureSpawnMap.put((Object)biomeKey, waterList);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        LevelChunk chunk;
        BlockPos pos;
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        Biome biome = (Biome)level.m_204166_(pos = new BlockPos((chunk = (LevelChunk)event.getChunk()).m_7697_().m_45604_() + 8, 0, chunk.m_7697_().m_45605_() + 8)).m_203334_();
        ResourceLocation biomeKey = ForgeRegistries.BIOMES.getKey((Object)biome);
        if (biomeKey == null) {
            return;
        }
        RandomSource random = level.m_213780_();
        List creatureList = (List)creatureSpawnMap.get((Object)biomeKey);
        List waterList = (List)waterCreatureSpawnMap.get((Object)biomeKey);
        if (creatureList != null) {
            MoCTools.performCustomWorldGenSpawning(level, biome, pos.m_123341_(), pos.m_123343_(), 16, 16, random, creatureList, SpawnPlacements.Type.ON_GROUND);
        }
        if (waterList != null) {
            MoCTools.performCustomWorldGenSpawning(level, biome, pos.m_123341_(), pos.m_123343_(), 16, 16, random, waterList, SpawnPlacements.Type.IN_WATER);
        }
    }
}

