/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.event;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.init.MoCEntities;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mocreatures")
public class MoCWyvernDimensionHandler {
    private static final Supplier<List<EntityType<?>>> ALLOWED_ENTITIES_SUPPLIER = () -> Arrays.asList((EntityType)MoCEntities.WYVERN.get(), (EntityType)MoCEntities.BUNNY.get(), (EntityType)MoCEntities.SNAKE.get(), (EntityType)MoCEntities.FILCH_LIZARD.get(), (EntityType)MoCEntities.DRAGONFLY.get(), (EntityType)MoCEntities.FIREFLY.get(), (EntityType)MoCEntities.GRASSHOPPER.get());

    private static List<EntityType<?>> getAllowedEntities() {
        return ALLOWED_ENTITIES_SUPPLIER.get();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCheckSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        if (entity.m_9236_() != null && entity.m_9236_().m_46472_().m_135782_().toString().equals("mocreatures:wyvernlairworld")) {
            if (MoCreatures.proxy.debug) {
                MoCreatures.LOGGER.info("MoCWyvernDimensionHandler: Checking spawn for {} in Wyvern dimension", (Object)entity.m_6095_().m_20675_());
            }
            if (MoCWyvernDimensionHandler.getAllowedEntities().contains(entity.m_6095_())) {
                if (MoCreatures.proxy.debug) {
                    MoCreatures.LOGGER.info("MoCWyvernDimensionHandler: Allowing {} to spawn in Wyvern dimension", (Object)entity.m_6095_().m_20675_());
                }
                event.setResult(Event.Result.ALLOW);
                return;
            }
            if (entity instanceof Player) {
                event.setResult(Event.Result.DEFAULT);
                return;
            }
            if (MoCreatures.proxy.debug) {
                MoCreatures.LOGGER.info("MoCWyvernDimensionHandler: Non-allowed entity {} attempted to spawn, letting JSON modifiers handle it", (Object)entity.m_6095_().m_20675_());
            }
            event.setResult(Event.Result.DEFAULT);
        }
    }
}

