/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.init;

import drzhark.mocreatures.block.MoCBlockDirt;
import drzhark.mocreatures.block.MoCBlockFirestone;
import drzhark.mocreatures.block.MoCBlockGlass;
import drzhark.mocreatures.block.MoCBlockGrass;
import drzhark.mocreatures.block.MoCBlockLeaf;
import drzhark.mocreatures.block.MoCBlockLog;
import drzhark.mocreatures.block.MoCBlockMetal;
import drzhark.mocreatures.block.MoCBlockNest;
import drzhark.mocreatures.block.MoCBlockOre;
import drzhark.mocreatures.block.MoCBlockPlanks;
import drzhark.mocreatures.block.MoCBlockRock;
import drzhark.mocreatures.block.MoCBlockSand;
import drzhark.mocreatures.block.MoCBlockSapling;
import drzhark.mocreatures.block.MoCBlockTallGrass;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="mocreatures", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoCBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"mocreatures");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mocreatures");
    public static final RegistryObject<Block> ancientSilverBlock = MoCBlocks.register("ancient_silver_block", () -> new MoCBlockMetal(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 10.0f).m_284180_(MapColor.f_283906_)));
    public static final RegistryObject<Block> cobbledWyvstone = MoCBlocks.register("cobbled_wyvstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 10.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> cobbledDeepWyvstone = MoCBlocks.register("cobbled_deep_wyvstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60913_(3.5f, 10.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> wyvstone = MoCBlocks.register("wyvstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 10.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> deepWyvstone = MoCBlocks.register("deep_wyvstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 10.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> mossyCobbledWyvstone = MoCBlocks.register("mossy_cobbled_wyvstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 10.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> mossyCobbledDeepWyvstone = MoCBlocks.register("mossy_cobbled_deep_wyvstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 10.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> gleamingGlass = MoCBlocks.register("gleaming_glass", () -> new MoCBlockGlass(BlockBehaviour.Properties.m_284310_().m_60978_(0.4f).m_284180_(MapColor.f_283779_).m_60955_()));
    public static final RegistryObject<Block> silverSand = MoCBlocks.register("silver_sand", () -> new MoCBlockSand(BlockBehaviour.Properties.m_284310_().m_60978_(0.6f).m_284180_(MapColor.f_283869_)));
    public static final RegistryObject<Block> silverSandstone = MoCBlocks.register("silver_sandstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60978_(1.2f).m_284180_(MapColor.f_283869_)));
    public static final RegistryObject<Block> carvedSilverSandstone = MoCBlocks.register("carved_silver_sandstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60978_(1.2f).m_284180_(MapColor.f_283869_)));
    public static final RegistryObject<Block> smoothSilverSandstone = MoCBlocks.register("smooth_silver_sandstone", () -> new MoCBlockRock(BlockBehaviour.Properties.m_284310_().m_60978_(1.2f).m_284180_(MapColor.f_283869_)));
    public static final RegistryObject<Block> ancientOre = MoCBlocks.register("ancient_ore", () -> new MoCBlockOre(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 5.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> firestone = MoCBlocks.register("firestone", () -> new MoCBlockFirestone(BlockBehaviour.Properties.m_284310_().m_60978_(3.0f).m_60953_(state -> 7).m_284180_(MapColor.f_283750_)));
    public static final RegistryObject<Block> wyvernDiamondOre = MoCBlocks.register("wyvern_diamond_ore", () -> new MoCBlockOre(BlockBehaviour.Properties.m_284310_().m_60913_(4.5f, 5.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> wyvernEmeraldOre = MoCBlocks.register("wyvern_emerald_ore", () -> new MoCBlockOre(BlockBehaviour.Properties.m_284310_().m_60913_(4.5f, 5.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> wyvernGoldOre = MoCBlocks.register("wyvern_gold_ore", () -> new MoCBlockOre(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 5.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> wyvernIronOre = MoCBlocks.register("wyvern_iron_ore", () -> new MoCBlockOre(BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 5.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> wyvernLapisOre = MoCBlocks.register("wyvern_lapis_ore", () -> new MoCBlockOre(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 5.0f).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Block> wyvgrass = MoCBlocks.register("wyvgrass", () -> new MoCBlockGrass(BlockBehaviour.Properties.m_284310_().m_60978_(0.7f).m_284180_(MapColor.f_283772_)));
    public static final RegistryObject<Block> wyvdirt = MoCBlocks.register("wyvdirt", () -> new MoCBlockDirt(BlockBehaviour.Properties.m_284310_().m_60978_(0.6f).m_284180_(MapColor.f_283762_)));
    public static final RegistryObject<Block> wyvwoodLeaves = MoCBlocks.register("wyvwood_leaves", () -> new MoCBlockLeaf(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_284180_(MapColor.f_283869_).m_60955_()));
    public static final RegistryObject<Block> wyvwoodSapling = MoCBlocks.register("wyvwood_sapling", () -> new MoCBlockSapling(BlockBehaviour.Properties.m_284310_().m_60910_().m_60977_().m_60978_(0.0f).m_284180_(MapColor.f_283915_)));
    public static final RegistryObject<Block> wyvwoodLog = MoCBlocks.register("wyvwood_log", () -> new MoCBlockLog(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_284180_(MapColor.f_283772_)));
    public static final RegistryObject<Block> tallWyvgrass = MoCBlocks.register("tall_wyvgrass", () -> new MoCBlockTallGrass(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.0f).m_284180_(MapColor.f_283869_)));
    public static final RegistryObject<Block> wyvwoodPlanks = MoCBlocks.register("wyvwood_planks", () -> new MoCBlockPlanks(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 5.0f).m_284180_(MapColor.f_283743_)));
    public static final RegistryObject<Block> wyvernNestBlock = MoCBlocks.register("wyvern_nest_block", () -> new MoCBlockNest(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_284180_(MapColor.f_283832_)));

    private static RegistryObject<Block> register(String name, Supplier<Block> blockSupplier) {
        RegistryObject block = BLOCKS.register(name, blockSupplier);
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="mocreatures", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientEvents {
        @SubscribeEvent
        public static void registerRenderLayers(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)wyvwoodLeaves.get()), (RenderType)RenderType.m_110457_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)wyvwoodSapling.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)tallWyvgrass.get()), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)gleamingGlass.get()), (RenderType)RenderType.m_110466_());
            });
        }
    }
}

