/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.dimension.worldgen.MoCDirectTeleporter;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.registry.MoCPOI;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.util.ITeleporter;

public class ItemStaffPortal
extends MoCItem {
    private int portalPosX;
    private int portalPosY;
    private int portalPosZ;
    private ResourceKey<Level> portalDimension;
    public static final ResourceKey<Level> WYVERN_DIM = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mocreatures", (String)"wyvernlairworld"));

    public ItemStaffPortal(Item.Properties properties) {
        super(properties.m_41487_(1).m_41503_(3));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean hasUnbreaking;
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(context.m_43724_());
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.FAIL;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)context.m_43725_();
        if (player.m_20202_() != null || !player.m_20197_().isEmpty()) {
            return InteractionResult.FAIL;
        }
        boolean hasMending = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)stack) > 0;
        boolean bl = hasUnbreaking = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack) > 0;
        if (hasMending || hasUnbreaking) {
            String enchantments = hasMending && hasUnbreaking ? "mending, unbreaking" : (hasMending ? "mending" : "unbreaking");
            player.m_213846_((Component)Component.m_237113_((String)(MoCreatures.MOC_LOGO + " \u00a7cDetected illegal enchantment(s) '\u00a7a" + enchantments + "\u00a7c' on Staff Portal!\nThe item has been removed from your inventory.")));
            player.m_150109_().m_36057_(stack);
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = stack.m_41784_();
        if (!level.m_46472_().equals(WYVERN_DIM)) {
            this.portalDimension = level.m_46472_();
            this.portalPosX = (int)player.m_20185_();
            this.portalPosY = (int)player.m_20186_();
            this.portalPosZ = (int)player.m_20189_();
            this.writeToNBT(tag);
            ServerLevel wyvernWorld = serverPlayer.f_8924_.m_129880_(WYVERN_DIM);
            if (wyvernWorld != null) {
                BlockPos targetPos = this.findDestinationPortal(wyvernWorld);
                wyvernWorld.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(targetPos), 1, (Object)targetPos);
                serverPlayer.changeDimension(wyvernWorld, (ITeleporter)new MoCDirectTeleporter(targetPos, true));
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
        } else {
            this.readFromNBT(tag);
            ResourceKey<Level> returnDim = this.portalDimension != null ? this.portalDimension : Level.f_46428_;
            ServerLevel returnWorld = serverPlayer.f_8924_.m_129880_(returnDim);
            if (returnWorld != null) {
                BlockPos returnPos = new BlockPos(this.portalPosX, this.portalPosY + 1, this.portalPosZ);
                returnWorld.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(returnPos), 1, (Object)returnPos);
                serverPlayer.changeDimension(returnWorld, (ITeleporter)new MoCDirectTeleporter(returnPos, false));
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            } else {
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    private BlockPos findDestinationPortal(ServerLevel world) {
        PoiManager poiManager = world.m_8904_();
        Optional<BlockPos> existingPortal = this.findExistingPortal(poiManager, world);
        if (existingPortal.isPresent()) {
            return existingPortal.get();
        }
        BlockPos spawnPos = world.m_220360_();
        BlockPos portalPos = this.findSuitableIslandLocation(world, spawnPos);
        return portalPos;
    }

    private Optional<BlockPos> findExistingPortal(PoiManager poiManager, ServerLevel world) {
        Predicate<Holder> poiPredicate = holder -> holder.m_203565_(MoCPOI.WYVERN_PORTAL_KEY);
        BlockPos centerPos = world.m_220360_();
        try {
            Stream records = poiManager.m_27181_(poiPredicate, centerPos, 500, PoiManager.Occupancy.ANY);
            return records.findFirst().map(record -> record.m_27257_());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private BlockPos findSuitableIslandLocation(ServerLevel world, BlockPos startPos) {
        int maxSearchRadius = 128;
        for (int searchRadius = 16; searchRadius <= maxSearchRadius; searchRadius += 16) {
            for (int x = startPos.m_123341_() - searchRadius; x <= startPos.m_123341_() + searchRadius; x += 8) {
                for (int z = startPos.m_123343_() - searchRadius; z <= startPos.m_123343_() + searchRadius; z += 8) {
                    BlockPos candidatePos;
                    if (Math.abs(x - startPos.m_123341_()) != searchRadius && Math.abs(z - startPos.m_123343_()) != searchRadius || (candidatePos = this.findSafePortalPosition(world, new BlockPos(x, 0, z))) == null) continue;
                    return candidatePos;
                }
            }
        }
        return this.createSafePlatform(world, startPos);
    }

    private BlockPos findSafePortalPosition(ServerLevel world, BlockPos basePos) {
        int worldHeight = world.m_151558_();
        int minHeight = world.m_141937_() + 10;
        for (int y = Math.min(worldHeight - 10, 100); y >= minHeight; --y) {
            BlockPos testPos = new BlockPos(basePos.m_123341_(), y, basePos.m_123343_());
            if (!this.isValidPortalSite(world, testPos)) continue;
            return testPos;
        }
        return null;
    }

    private boolean isValidPortalSite(ServerLevel world, BlockPos pos) {
        for (int dy = 0; dy < 4; ++dy) {
            BlockPos checkPos = pos.m_6630_(dy);
            if (world.m_8055_(checkPos).m_60795_() || world.m_8055_(checkPos).m_247087_()) continue;
            return false;
        }
        BlockPos groundPos = pos.m_7495_();
        if (world.m_8055_(groundPos).m_60795_()) {
            boolean foundSolid = false;
            for (int dy = 1; dy <= 5; ++dy) {
                BlockPos checkPos = pos.m_6625_(dy);
                if (world.m_8055_(checkPos).m_60795_()) continue;
                foundSolid = true;
                break;
            }
            if (!foundSolid) {
                return false;
            }
        }
        int solidCount = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos checkPos = pos.m_7495_().m_7918_(dx, 0, dz);
                if (world.m_8055_(checkPos).m_60795_()) continue;
                ++solidCount;
            }
        }
        return solidCount >= 3;
    }

    private BlockPos createSafePlatform(ServerLevel world, BlockPos basePos) {
        int terrainHeight = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, basePos.m_123341_(), basePos.m_123343_());
        int platformHeight = Math.max(terrainHeight + 5, 70);
        BlockPos platformCenter = new BlockPos(basePos.m_123341_(), platformHeight, basePos.m_123343_());
        return platformCenter;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.portalPosX = nbt.m_128451_("portalPosX");
        this.portalPosY = nbt.m_128451_("portalPosY");
        this.portalPosZ = nbt.m_128451_("portalPosZ");
        String dimKey = nbt.m_128461_("portalDimension");
        this.portalDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimKey));
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("portalPosX", this.portalPosX);
        nbt.m_128405_("portalPosY", this.portalPosY);
        nbt.m_128405_("portalPosZ", this.portalPosZ);
        nbt.m_128359_("portalDimension", this.portalDimension.m_135782_().toString());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

