/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.item.MoCItem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;

public class MoCItemCrabClaw
extends MoCItem {
    protected static final UUID REACH_DISTANCE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID TOUGHNESS_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public final int armor;
    public final int enchantability;
    public final float reach;
    public final float toughness;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;

    public MoCItemCrabClaw(Item.Properties properties, int enchantability, float toughness, int armor, float reach) {
        super(properties);
        this.armor = armor;
        this.enchantability = enchantability;
        this.reach = reach;
        this.toughness = toughness;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Item offhand = attacker.m_21206_().m_41720_();
        if (offhand instanceof MoCItemCrabClaw) {
            stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f && entity.m_21206_().m_41720_() instanceof MoCItemCrabClaw) {
            stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public int m_6473_() {
        return this.enchantability;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == MoCItems.ANIMALHIDE.get() || super.m_6832_(toRepair, repair);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (this.attributeModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(TOUGHNESS_MODIFIER, "Crab claw armor", (double)this.armor, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(REACH_DISTANCE_MODIFIER, "Crab claw reach", (double)this.reach, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(TOUGHNESS_MODIFIER, "Crab claw toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
            this.attributeModifiers = builder.build();
        }
        return slot == EquipmentSlot.OFFHAND ? this.attributeModifiers : super.m_7167_(slot);
    }
}

