/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.neutral.MoCEntityWyvern;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class MoCItemHorseAmulet
extends MoCItem {
    private int ageCounter = 0;
    private String name;
    private float health;
    private int age;
    private int creatureType;
    private String spawnClass;
    private boolean isGhost;
    private boolean rideable;
    private byte armor;
    private boolean adult;
    private UUID ownerUniqueId;
    private String ownerName;
    private int PetId;

    public MoCItemHorseAmulet(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (++this.ageCounter < 2) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!level.f_46443_) {
            this.initAndReadNBT(stack);
        }
        double dist = 3.0;
        double newPosY = player.m_20186_();
        double newPosX = player.m_20185_() - dist * Math.cos(MoCTools.realAngle(player.m_146908_() - 90.0f) / 57.29578f);
        double newPosZ = player.m_20189_() - dist * Math.sin(MoCTools.realAngle(player.m_146908_() - 90.0f) / 57.29578f);
        if (!level.f_46443_) {
            try {
                MoCEntityTameableAnimal storedCreature;
                this.spawnClass = this.spawnClass.replace("mocreatures:", "").toLowerCase();
                if (this.spawnClass.equalsIgnoreCase("Wyvern")) {
                    storedCreature = (MoCEntityTameableAnimal)((EntityType)MoCEntities.WYVERN.get()).m_20615_(level);
                    ((MoCEntityWyvern)storedCreature).setIsGhost(true);
                    this.isGhost = true;
                } else if (this.spawnClass.equalsIgnoreCase("WildHorse")) {
                    storedCreature = (MoCEntityTameableAnimal)((EntityType)MoCEntities.WILDHORSE.get()).m_20615_(level);
                } else {
                    ResourceLocation res = new ResourceLocation("mocreatures:" + this.spawnClass.toLowerCase());
                    storedCreature = (MoCEntityTameableAnimal)((EntityType)BuiltInRegistries.f_256780_.m_7745_(res)).m_20615_(level);
                    if (storedCreature instanceof MoCEntityBigCat) {
                        this.isGhost = true;
                        ((MoCEntityBigCat)storedCreature).setIsGhost(true);
                    }
                }
                storedCreature.m_6034_(newPosX, newPosY, newPosZ);
                storedCreature.setTypeMoC(this.creatureType);
                storedCreature.setTamed(true);
                storedCreature.setRideable(this.rideable);
                storedCreature.setPetName(this.name);
                storedCreature.m_21153_(this.health);
                storedCreature.setAdult(this.adult);
                storedCreature.setMoCAge(this.age);
                storedCreature.setArmorType(this.armor);
                storedCreature.setOwnerPetId(this.PetId);
                storedCreature.setOwnerId(player.m_20148_());
                this.ownerName = player.m_7755_().getString();
                if (level.m_7967_((Entity)storedCreature)) {
                    MoCPetData petData;
                    ItemStack replacement;
                    MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 64.0, level.m_46472_())), (Object)new MoCMessageAppear(storedCreature.m_19879_()));
                    MoCTools.playCustomSound((Entity)storedCreature, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR.get());
                    switch (this.creatureType) {
                        case 21: 
                        case 22: {
                            ItemStack itemStack = new ItemStack((ItemLike)MoCItems.AMULET_GHOST.get());
                            break;
                        }
                        case 26: 
                        case 27: 
                        case 28: {
                            ItemStack itemStack = new ItemStack((ItemLike)MoCItems.AMULET_BONE.get());
                            break;
                        }
                        case 39: 
                        case 40: {
                            ItemStack itemStack = new ItemStack((ItemLike)MoCItems.AMULET_PEGASUS.get());
                            break;
                        }
                        default: {
                            ItemStack itemStack = replacement = this.creatureType > 47 && this.creatureType < 60 ? new ItemStack((ItemLike)MoCItems.AMULET_FAIRY.get()) : ItemStack.f_41583_;
                        }
                    }
                    if (storedCreature.getIsGhost()) {
                        replacement = new ItemStack((ItemLike)MoCItems.AMULET_GHOST.get());
                    }
                    if (!replacement.m_41619_()) {
                        player.m_21008_(hand, replacement);
                    }
                    if ((petData = MoCreatures.instance.mapData.getPetData(storedCreature.getOwnerId())) != null) {
                        petData.setInAmulet(storedCreature.getOwnerPetId(), false);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Unable to find class for entity " + this.spawnClass);
                ex.printStackTrace();
            }
        }
        this.ageCounter = 0;
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void readFromNBT(CompoundTag tag) {
        this.PetId = tag.m_128451_("PetId");
        this.creatureType = tag.m_128451_("CreatureType");
        this.health = tag.m_128457_("Health");
        this.age = tag.m_128451_("Edad");
        this.name = tag.m_128461_("Name");
        int spawnClassOld = tag.m_128451_("SpawnClass");
        if (spawnClassOld > 0) {
            if (spawnClassOld == 100) {
                this.spawnClass = "Wyvern";
                this.isGhost = true;
            } else {
                this.spawnClass = "WildHorse";
            }
            tag.m_128473_("SpawnClass");
        } else {
            this.spawnClass = tag.m_128461_("SpawnClass");
        }
        this.rideable = tag.m_128471_("Rideable");
        this.armor = tag.m_128445_("Armor");
        this.adult = tag.m_128471_("Adult");
        this.ownerName = tag.m_128461_("OwnerName");
        if (tag.m_128403_("OwnerUUID")) {
            this.ownerUniqueId = tag.m_128342_("OwnerUUID");
        }
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128405_("PetId", this.PetId);
        tag.m_128405_("CreatureType", this.creatureType);
        tag.m_128350_("Health", this.health);
        tag.m_128405_("Edad", this.age);
        tag.m_128359_("Name", this.name);
        tag.m_128359_("SpawnClass", this.spawnClass);
        tag.m_128379_("Rideable", this.rideable);
        tag.m_128344_("Armor", this.armor);
        tag.m_128379_("Adult", this.adult);
        tag.m_128359_("OwnerName", this.ownerName);
        if (this.ownerUniqueId != null) {
            tag.m_128362_("OwnerUUID", this.ownerUniqueId);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        this.initAndReadNBT(stack);
        tooltip.add((Component)Component.m_237113_((String)this.spawnClass).m_130940_(ChatFormatting.AQUA));
        if (!this.name.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)this.name).m_130940_(ChatFormatting.BLUE));
        }
        if (!this.ownerName.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)("Owned by " + this.ownerName)).m_130940_(ChatFormatting.DARK_BLUE));
        }
    }

    private void initAndReadNBT(ItemStack itemstack) {
        if (!itemstack.m_41782_()) {
            itemstack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = itemstack.m_41783_();
        this.readFromNBT(tag);
    }
}

