/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.neutral.MoCEntityKitty;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class MoCItemPetAmulet
extends MoCItem {
    private String name = "";
    private float health;
    private int age;
    private int creatureType;
    private String spawnClass = "";
    private String ownerName = "";
    private UUID ownerUniqueId;
    private int amuletType;
    private boolean adult;
    private int PetId;

    public MoCItemPetAmulet(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public MoCItemPetAmulet(Item.Properties properties, int type) {
        this(properties);
        this.amuletType = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        block27: {
            stack = player.m_21120_(hand);
            double dist = 1.0;
            double newPosY = player.m_20186_();
            double newPosX = player.m_20185_() - dist * (double)Mth.m_14089_((float)(MoCTools.realAngle(player.m_146908_() - 90.0f) / 57.29578f));
            double newPosZ = player.m_20189_() - dist * (double)Mth.m_14031_((float)(MoCTools.realAngle(player.m_146908_() - 90.0f) / 57.29578f));
            ItemStack emptyAmulet = new ItemStack((ItemLike)MoCItems.FISH_NET.get(), 1);
            if (this.amuletType == 1) {
                emptyAmulet = new ItemStack((ItemLike)MoCItems.PET_AMULET.get(), 1);
            }
            if (!level.f_46443_) {
                this.initAndReadNBT(stack);
                if (this.spawnClass.isEmpty()) {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                try {
                    String formattedClass = switch (formattedClass = this.spawnClass.replace("mocreatures:", "").toLowerCase()) {
                        case "mochorse" -> "wildhorse";
                        case "polarbear" -> "wildpolarbear";
                        case "petmanticore" -> "manticorepet";
                        case "ray" -> {
                            if (this.creatureType == 1) {
                                yield "mantaray";
                            }
                            if (this.creatureType != 2) yield "stingray";
                        }
                    };
                    Mob entity = (Mob)((EntityType)EntityType.m_20632_((String)("mocreatures:" + formattedClass)).orElseThrow()).m_20615_(level);
                    if (entity instanceof IMoCTameable) {
                        IMoCTameable storedCreature = (IMoCTameable)entity;
                        entity.m_6034_(newPosX, newPosY, newPosZ);
                        storedCreature.setTypeMoC(this.creatureType);
                        storedCreature.setTamed(true);
                        storedCreature.setPetName(this.name);
                        storedCreature.setOwnerPetId(this.PetId);
                        storedCreature.setOwnerId(player.m_20148_());
                        this.ownerName = player.m_7755_().getString();
                        entity.m_21153_(this.health);
                        storedCreature.setAdult(this.adult);
                        storedCreature.setMoCAge(this.age);
                        if (entity instanceof MoCEntityBigCat) {
                            MoCEntityBigCat cat = (MoCEntityBigCat)entity;
                            cat.setHasAmulet(true);
                        }
                        if (formattedClass.equals("kitty")) {
                            ((MoCEntityKitty)entity).setKittyState(3);
                        }
                        UUID newOwnerUUID = player.m_20148_();
                        if (this.ownerUniqueId == null) {
                            this.ownerUniqueId = newOwnerUUID;
                            this.maybeRegisterPet(storedCreature, player);
                        } else if (!this.ownerUniqueId.equals(newOwnerUUID)) {
                            this.transferOwnership(storedCreature, player);
                        }
                        if (level.m_7967_((Entity)entity)) {
                            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 64.0, level.m_46472_())), (Object)new MoCMessageAppear(entity.m_19879_()));
                            if (this.ownerUniqueId == null || this.name.isEmpty()) {
                                MoCTools.tameWithName(player, storedCreature);
                            }
                            player.m_21008_(hand, emptyAmulet);
                            MoCPetData petData = MoCreatures.instance.mapData.getPetData(storedCreature.getOwnerId());
                            if (petData != null) {
                                petData.setInAmulet(storedCreature.getOwnerPetId(), false);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!MoCreatures.proxy.debug) break block27;
                    MoCreatures.LOGGER.warn("Error spawning creature from amulet: ", (Throwable)e);
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void maybeRegisterPet(IMoCTameable creature, Player player) {
        if (MoCreatures.instance.mapData == null) {
            return;
        }
        MoCPetData data = MoCreatures.instance.mapData.getPetData(player.m_20148_());
        int max = MoCreatures.proxy.maxTamed;
        if (MoCTools.isThisPlayerAnOP(player)) {
            max = MoCreatures.proxy.maxOPTamed;
        }
        if (data == null) {
            if (max > 0 || !MoCreatures.proxy.enableOwnership) {
                MoCreatures.instance.mapData.updateOwnerPet(creature);
            }
        } else if (data.getTamedList().size() < max || !MoCreatures.proxy.enableOwnership) {
            MoCreatures.instance.mapData.updateOwnerPet(creature);
        }
    }

    private void transferOwnership(IMoCTameable creature, Player player) {
        if (MoCreatures.instance.mapData == null) {
            return;
        }
        UUID oldOwner = this.ownerUniqueId;
        UUID newOwner = player.m_20148_();
        MoCPetData oldData = MoCreatures.instance.mapData.getPetData(oldOwner);
        MoCPetData newData = MoCreatures.instance.mapData.getPetData(newOwner);
        int max = MoCreatures.proxy.maxTamed;
        if (MoCTools.isThisPlayerAnOP(player)) {
            max = MoCreatures.proxy.maxOPTamed;
        }
        if (newData != null && newData.getTamedList().size() < max || newData == null && max > 0 || !MoCreatures.proxy.enableOwnership) {
            MoCreatures.instance.mapData.updateOwnerPet(creature);
        }
        if (oldData != null) {
            // empty if block
        }
    }

    public void readFromNBT(CompoundTag nbt) {
        this.PetId = nbt.m_128451_("PetId");
        this.creatureType = nbt.m_128451_("CreatureType");
        this.health = nbt.m_128457_("Health");
        this.age = nbt.m_128451_("Edad");
        this.name = nbt.m_128461_("Name");
        this.spawnClass = nbt.m_128461_("SpawnClass");
        this.adult = nbt.m_128471_("Adult");
        this.ownerName = nbt.m_128461_("OwnerName");
        if (nbt.m_128403_("OwnerUUID")) {
            this.ownerUniqueId = nbt.m_128342_("OwnerUUID");
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("PetId", this.PetId);
        nbt.m_128405_("CreatureType", this.creatureType);
        nbt.m_128350_("Health", this.health);
        nbt.m_128405_("Edad", this.age);
        nbt.m_128359_("Name", this.name);
        nbt.m_128359_("SpawnClass", this.spawnClass);
        nbt.m_128379_("Adult", this.adult);
        nbt.m_128359_("OwnerName", this.ownerName);
        if (this.ownerUniqueId != null) {
            nbt.m_128362_("OwnerUUID", this.ownerUniqueId);
        }
    }

    private void initAndReadNBT(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        this.readFromNBT(stack.m_41783_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        this.initAndReadNBT(stack);
        if (!this.spawnClass.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)this.spawnClass).m_130940_(ChatFormatting.AQUA));
        }
        if (!this.name.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)this.name).m_130940_(ChatFormatting.BLUE));
        }
        if (!this.ownerName.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)("Owned by " + this.ownerName)).m_130940_(ChatFormatting.DARK_BLUE));
        }
    }
}

