/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.item.MoCItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MoCItemWeapon
extends MoCItem {
    private final Tier material;
    private final float attackDamage;
    private int specialWeaponType = 0;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public MoCItemWeapon(Item.Properties properties, Tier material) {
        super(properties.m_41487_(1).m_41503_(material.m_6609_()));
        this.material = material;
        this.attackDamage = 3.0f + material.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public MoCItemWeapon(Item.Properties properties, Tier material, int damageType) {
        this(properties, material);
        this.specialWeaponType = damageType;
    }

    public float getAttackDamage() {
        return this.material.m_6631_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return 1.5f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (MoCreatures.proxy.weaponEffects) {
            int timer = 10;
            switch (this.specialWeaponType) {
                case 1: {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, timer * 20, 1));
                    break;
                }
                case 2: {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, timer * 20, 0));
                    break;
                }
                case 3: {
                    target.m_20254_(timer);
                    break;
                }
                case 4: {
                    if (target instanceof Player) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, timer * 20, 0));
                        break;
                    }
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, timer * 20, 0));
                    break;
                }
                case 5: {
                    if (target instanceof Player) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, timer * 20, 0));
                        break;
                    }
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, timer * 20, 0));
                }
            }
        }
        stack.m_41622_(1, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public int m_6473_() {
        return this.material.m_6601_();
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!world.f_46443_ && state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.material.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (MoCreatures.proxy.weaponEffects) {
            switch (this.specialWeaponType) {
                case 1: {
                    tooltip.add((Component)Component.m_237115_((String)"info.mocreatures.stingdefault1").m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case 2: {
                    tooltip.add((Component)Component.m_237115_((String)"info.mocreatures.stingdefault2").m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case 3: {
                    tooltip.add((Component)Component.m_237115_((String)"info.mocreatures.stingdefault3").m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case 4: {
                    tooltip.add((Component)Component.m_237115_((String)"info.mocreatures.stingdefault4").m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case 5: {
                    tooltip.add((Component)Component.m_237115_((String)"info.mocreatures.stingdefault5").m_130940_(ChatFormatting.BLUE));
                }
            }
        }
    }
}

