/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.hunter.MoCEntityPetScorpion;
import drzhark.mocreatures.entity.neutral.MoCEntityElephant;
import drzhark.mocreatures.entity.neutral.MoCEntityKitty;
import drzhark.mocreatures.entity.neutral.MoCEntityOstrich;
import drzhark.mocreatures.entity.neutral.MoCEntityWyvern;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.item.MoCItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;

public class MoCItemWhip
extends MoCItem {
    public MoCItemWhip(Item.Properties properties) {
        super(properties.m_41487_(1).m_41503_(24));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(context.m_43724_());
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Block block = level.m_8055_(pos).m_60734_();
        Block blockAbove = level.m_8055_(pos.m_7494_()).m_60734_();
        if (context.m_43719_() != Direction.DOWN && blockAbove == Blocks.f_50016_ && block != Blocks.f_50016_ && !(block instanceof StandingSignBlock)) {
            this.whipFX(level, pos);
            level.m_5594_(player, pos, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_WHIP.get(), SoundSource.PLAYERS, 0.5f, 0.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            List entities = level.m_45933_((Entity)player, player.m_20191_().m_82400_(12.0));
            for (Entity entity : entities) {
                MoCEntityElephant elephant;
                MoCEntityPetScorpion scorpion;
                MoCEntityWyvern wyvern;
                MoCEntityKitty kitty;
                MoCEntityHorse horse;
                if (entity instanceof MoCEntityAnimal) {
                    MoCEntityAnimal animal = (MoCEntityAnimal)entity;
                    if (MoCreatures.proxy.enableOwnership && animal.getOwnerId() != null && !player.m_20148_().equals(animal.getOwnerId()) && !MoCTools.isThisPlayerAnOP(player)) continue;
                }
                if (entity instanceof MoCEntityBigCat) {
                    MoCEntityBigCat bigCat = (MoCEntityBigCat)entity;
                    if (bigCat.getIsTamed()) {
                        bigCat.setSitting(!bigCat.getIsSitting());
                        bigCat.setIsJumping(false);
                        bigCat.m_21573_().m_26573_();
                        bigCat.m_6710_(null);
                    } else if (level.m_46791_().m_19028_() > 0 && bigCat.getIsAdult()) {
                        bigCat.m_6710_((LivingEntity)player);
                    }
                }
                if (entity instanceof MoCEntityHorse && (horse = (MoCEntityHorse)entity).getIsTamed()) {
                    if (horse.m_20202_() == null) {
                        horse.setSitting(!horse.getIsSitting());
                        horse.setIsJumping(false);
                        horse.m_21573_().m_26573_();
                        horse.m_6710_(null);
                    } else if (horse.isNightmare()) {
                        horse.setNightmareInt(100);
                    } else if (horse.sprintCounter == 0) {
                        horse.sprintCounter = 1;
                    }
                }
                if (entity instanceof MoCEntityKitty && (kitty = (MoCEntityKitty)entity).getKittyState() > 2 && kitty.whipable()) {
                    kitty.setSitting(!kitty.getIsSitting());
                    kitty.setIsJumping(false);
                    kitty.m_21573_().m_26573_();
                    kitty.m_6710_(null);
                }
                if (entity instanceof MoCEntityWyvern && (wyvern = (MoCEntityWyvern)entity).getIsTamed() && wyvern.m_20202_() == null && !wyvern.isOnAir()) {
                    wyvern.setSitting(!wyvern.getIsSitting());
                    wyvern.setIsJumping(false);
                    wyvern.m_21573_().m_26573_();
                    wyvern.m_6710_(null);
                }
                if (entity instanceof MoCEntityPetScorpion && (scorpion = (MoCEntityPetScorpion)entity).getIsTamed() && scorpion.m_20202_() == null) {
                    scorpion.setSitting(!scorpion.getIsSitting());
                    scorpion.setIsJumping(false);
                    scorpion.m_21573_().m_26573_();
                    scorpion.m_6710_(null);
                }
                if (entity instanceof MoCEntityOstrich) {
                    MoCEntityOstrich ostrich = (MoCEntityOstrich)entity;
                    if (ostrich.m_20160_() && ostrich.sprintCounter == 0) {
                        ostrich.sprintCounter = 1;
                    }
                    if (ostrich.getIsTamed() && ostrich.m_20202_() == null) {
                        ostrich.setHiding(!ostrich.getHiding());
                        ostrich.setIsJumping(false);
                        ostrich.m_21573_().m_26573_();
                        ostrich.m_6710_(null);
                    }
                }
                if (!(entity instanceof MoCEntityElephant) || !(elephant = (MoCEntityElephant)entity).m_20160_() || elephant.sprintCounter != 0) continue;
                elephant.sprintCounter = 1;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void whipFX(Level level, BlockPos pos) {
        double d = (float)pos.m_123341_() + 0.5f;
        double d1 = (float)pos.m_123342_() + 1.0f;
        double d2 = (float)pos.m_123343_() + 0.5f;
        double spread = 0.27;
        double rise = 0.22;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d - spread, d1 + rise, d2, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d + spread, d1 + rise, d2, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d, d1 + rise, d2 - spread, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d, d1 + rise, d2 + spread, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d, d1, d2, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d - spread, d1 + rise, d2, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + spread, d1 + rise, d2, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, d1 + rise, d2 - spread, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, d1 + rise, d2 + spread, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, d1, d2, 0.0, 0.0, 0.0);
    }
}

