/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class CommandMoCPets {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mocpets").requires(source -> source.m_6761_(2))).executes(context -> CommandMoCPets.execute((CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
            return CommandMoCPets.execute((CommandSourceStack)context.getSource(), page);
        })));
    }

    private static int execute(CommandSourceStack source) {
        return CommandMoCPets.execute(source, 1);
    }

    private static int execute(CommandSourceStack source, int page) {
        try {
            int finalTotalCount;
            ServerPlayer player = source.m_81375_();
            int unloadedCount = 0;
            int loadedCount = 0;
            ArrayList<Integer> foundIds = new ArrayList<Integer>();
            ArrayList<String> tamedList = new ArrayList<String>();
            UUID playerId = player.m_20148_();
            for (ServerLevel world : source.m_81377_().m_129785_()) {
                for (Entity entity : world.m_8583_()) {
                    IMoCTameable mocreature;
                    if (!(entity instanceof IMoCTameable) || (mocreature = (IMoCTameable)entity).getOwnerId() == null || !mocreature.getOwnerId().equals(playerId)) continue;
                    ++loadedCount;
                    foundIds.add(mocreature.getOwnerPetId());
                    tamedList.add("Found pet with Type: " + ((Mob)mocreature).m_7755_().getString() + ", Name: " + mocreature.getPetName() + ", Owner: " + player.m_7755_().getString() + ", PetId: " + mocreature.getOwnerPetId() + ", Dimension: " + entity.m_9236_().m_46472_().m_135782_() + ", Pos: " + Math.round(entity.m_20185_()) + ", " + Math.round(entity.m_20186_()) + ", " + Math.round(entity.m_20189_()));
                }
            }
            MoCPetData ownerPetData = MoCreatures.instance.mapData.getPetData(player.m_20148_());
            if (ownerPetData != null) {
                for (int i = 0; i < ownerPetData.getTamedList().size(); ++i) {
                    CompoundTag nbt = ownerPetData.getTamedList().m_128728_(i);
                    if (!nbt.m_128441_("PetId") || foundIds.contains(nbt.m_128451_("PetId"))) continue;
                    ++unloadedCount;
                    double posX = nbt.m_128437_("Pos", 6).m_128772_(0);
                    double posY = nbt.m_128437_("Pos", 6).m_128772_(1);
                    double posZ = nbt.m_128437_("Pos", 6).m_128772_(2);
                    if (nbt.m_128471_("InAmulet")) {
                        tamedList.add("Found unloaded pet in AMULET with Type: " + nbt.m_128461_("id").replace("MoCreatures.", "") + ", Name: " + nbt.m_128461_("Name") + ", Owner: " + nbt.m_128461_("Owner") + ", PetId: " + nbt.m_128451_("PetId"));
                        continue;
                    }
                    tamedList.add("Found unloaded pet with Type: " + nbt.m_128461_("id").replace("MoCreatures.", "") + ", Name: " + nbt.m_128461_("Name") + ", Owner: " + nbt.m_128461_("Owner") + ", PetId: " + nbt.m_128451_("PetId") + ", Dimension: " + nbt.m_128461_("Dimension") + ", Pos: " + Math.round(posX) + ", " + Math.round(posY) + ", " + Math.round(posZ));
                }
            }
            int finalLoadedCount = loadedCount;
            int finalUnloadedCount = unloadedCount;
            int n = finalTotalCount = ownerPetData != null ? ownerPetData.getTamedList().size() : 0;
            if (tamedList.size() > 0) {
                CommandMoCPets.sendPageHelp(source, (byte)10, tamedList, page);
                source.m_288197_(() -> Component.m_237113_((String)("Loaded tamed count: " + finalLoadedCount + ", Unloaded count: " + finalUnloadedCount + ", Total count: " + finalTotalCount)), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Loaded tamed count: " + finalLoadedCount + ", Unloaded Count: " + finalUnloadedCount + ", Total count: " + (finalLoadedCount + finalUnloadedCount))), false);
            }
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Error: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static void sendPageHelp(CommandSourceStack sender, byte pageLimit, ArrayList<String> list, int page) {
        int totalPages = (list.size() - 1) / pageLimit;
        int finalPage = Math.max(0, Math.min(page - 1, totalPages));
        int start = finalPage * pageLimit;
        int end = Math.min((finalPage + 1) * pageLimit, list.size());
        sender.m_288197_(() -> Component.m_237113_((String)("--- Showing MoCreatures Help Info " + (finalPage + 1) + " of " + (totalPages + 1) + " (/mocpets <page>) ---")), false);
        for (int i = start; i < end; ++i) {
            String tamedInfo = list.get(i);
            sender.m_288197_(() -> Component.m_237113_((String)tamedInfo), false);
        }
    }
}

